/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.awt.Shape;
import java.awt.geom.Area;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JPanel;
import org.joda.time.Interval;

class ShapeBuffer {
    final long hash;
    final long ts;
    final Interval scope;
    private boolean invalid;
    final LinkedList<Shape> stroke = new LinkedList();
    final LinkedList<Shape> knockoutStroke = new LinkedList();
    final LinkedList<Shape> fillLight = new LinkedList();
    final LinkedList<Shape> fillDark = new LinkedList();
    Area collision = null;

    ShapeBuffer(JPanel target, AppState state) {
        this.hash = this.calculateHash(target, state);
        this.ts = System.currentTimeMillis();
        this.scope = state.getScope();
        this.invalid = false;
    }

    ShapeBuffer() {
        this.hash = 0L;
        this.ts = 0L;
        this.scope = null;
        this.invalid = true;
    }

    void invalidate() {
        this.invalid = true;
    }

    private long calculateHash(JPanel target, AppState state) {
        return Objects.hashCode(state.getScope(), target.getHeight(), target.getWidth());
    }

    public double getComplexity() {
        ImmutableCollection all = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.stroke)).addAll(this.knockoutStroke)).addAll(this.fillLight)).addAll(this.fillLight)).build();
        double score = 0.0;
        for (Shape shape : all) {
            try {
                score += (double)SGUtils.sizeOf(shape);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return score;
    }

    boolean isValid(JPanel target, AppState state) {
        return !this.invalid && this.calculateHash(target, state) == this.hash;
    }
}

