/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.systems.Settings;
import ch.bruker.util.treetable.ExternalCellEditor;
import com.google.common.collect.Range;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class RangeCellEditor
extends ExternalCellEditor {
    private Plot plot;
    private AppState appState;
    private static final DecimalFormat LINEAR_FORMAT = new DecimalFormat("#.##");
    private static final DecimalFormat LOGARITHMIC_FORMAT = new DecimalFormat("0.0E0");

    public RangeCellEditor(Component parent, AppState appState) {
        super(parent);
        this.appState = appState;
    }

    @Override
    protected Object getValue() {
        return this.plot.getClippingRange();
    }

    @Override
    protected void setValue(Object value) {
        System.out.println();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.plot = (Plot)table.getModel().getValueAt(row, 0);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    protected void showDialog() {
        if (!(this.plot instanceof GraphPlot)) {
            return;
        }
        RangeEditorPanel rangeEditorPanel = new RangeEditorPanel(this.appState, (GraphPlot)this.plot);
        Object[] complexMsg = new Object[]{"Please specify the range:   [" + ((GraphPlot)this.plot).getUnit() + "]", rangeEditorPanel};
        int userAction = 0;
        boolean valid = false;
        while (!valid) {
            userAction = JOptionPane.showOptionDialog(this.parent, complexMsg, "Range Editor", 2, 3, null, null, null);
            valid = userAction == 0 ? rangeEditorPanel.apply() : true;
            if (valid) continue;
            String errorMsg = "Please enter a valid range or select the auto range option!";
            JOptionPane.showMessageDialog(this.parent, errorMsg, "Invalid input", 0);
        }
        if (userAction == 0) {
            this.getOkActionListener().actionPerformed(null);
        } else {
            this.getCancelActionListener().actionPerformed(null);
        }
    }

    private class RangeEditorPanel
    extends JPanel {
        private static final long serialVersionUID = -3068205042246968606L;
        private final JTextField minTextField;
        private final JTextField maxTextField;
        private final Settings.ScalingModes graphScalingMethod;
        private final JCheckBox autoRangeCheckBox = new JCheckBox();
        private final GraphPlot plotToEdit;

        public RangeEditorPanel(AppState appState, GraphPlot plotToEdit) {
            String maxLabel;
            double maxValue;
            String minLabel;
            this.plotToEdit = plotToEdit;
            this.graphScalingMethod = appState.settings.scaling.get();
            double minValue = plotToEdit.getRange().lowerEndpoint();
            switch (this.graphScalingMethod) {
                case BASE_DIV: {
                    minLabel = "Baseline:";
                    maxValue = plotToEdit.getDiv();
                    if (plotToEdit.scaling == GraphPlot.Scaling.LINEAR) {
                        maxLabel = "Division:";
                        break;
                    }
                    maxLabel = "Factor per Division:";
                    break;
                }
                default: {
                    minLabel = "Minimum:";
                    maxLabel = "Maximum:";
                    maxValue = plotToEdit.getRange().upperEndpoint();
                }
            }
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = SGUtils.createDefaultGridBagConstraints(4, 16);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.add((Component)new JLabel(minLabel), constraints);
            constraints.gridx = 1;
            this.minTextField = new JTextField("");
            this.minTextField.setColumns(5);
            if (plotToEdit.scaling == GraphPlot.Scaling.LINEAR) {
                this.minTextField.setText(LINEAR_FORMAT.format(minValue));
            } else {
                this.minTextField.setText(LOGARITHMIC_FORMAT.format(minValue));
            }
            this.minTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    RangeEditorPanel.this.minTextField.selectAll();
                }
            });
            this.add((Component)this.minTextField, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            this.add((Component)new JLabel(maxLabel), constraints);
            constraints.gridx = 1;
            this.maxTextField = new JTextField("");
            this.maxTextField.setColumns(5);
            this.maxTextField.setText(LINEAR_FORMAT.format(maxValue));
            this.maxTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    RangeEditorPanel.this.maxTextField.selectAll();
                }
            });
            this.add((Component)this.maxTextField, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            this.add((Component)new JLabel("Autoscale:"), constraints);
            constraints.gridx = 1;
            this.add((Component)this.autoRangeCheckBox, constraints);
            this.autoRangeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RangeEditorPanel.this.minTextField.setEnabled(!RangeEditorPanel.this.autoRangeCheckBox.isSelected());
                    RangeEditorPanel.this.maxTextField.setEnabled(!RangeEditorPanel.this.autoRangeCheckBox.isSelected());
                }
            });
            this.autoRangeCheckBox.setSelected(plotToEdit.updateClipping);
            appState.doAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RangeEditorPanel.this.minTextField.requestFocusInWindow();
                            RangeEditorPanel.this.minTextField.selectAll();
                        }
                    });
                }
            });
        }

        public boolean apply() {
            if (this.autoRangeCheckBox.isSelected()) {
                this.plotToEdit.setAutoUpdateClipping(true);
            } else {
                double maxValue;
                double minValue;
                this.plotToEdit.setAutoUpdateClipping(false);
                try {
                    minValue = Double.parseDouble(this.minTextField.getText());
                    maxValue = Double.parseDouble(this.maxTextField.getText());
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                if (this.graphScalingMethod == Settings.ScalingModes.BASE_DIV) {
                    if (this.plotToEdit.scaling == GraphPlot.Scaling.LINEAR) {
                        maxValue = minValue + 10.0 * maxValue;
                    } else {
                        if (minValue <= 0.0) {
                            return false;
                        }
                        if (maxValue <= 1.0) {
                            return false;
                        }
                        maxValue = (float)(minValue * Math.pow(maxValue, 10.0));
                    }
                } else if (minValue > maxValue) {
                    double t = maxValue;
                    maxValue = minValue;
                    minValue = t;
                }
                Range<Double> valueRange = Range.closed(minValue, maxValue);
                this.plotToEdit.setClippingRange(valueRange);
            }
            return true;
        }
    }
}

