/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Colors;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.CacheVisualizer;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.TimeLine;
import ch.bruker.jac.servicegui.data.TimeMapping;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.graphical.DateUtils;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.GraphTab;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import com.google.common.base.Objects;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

class PlotPanel
extends JPanel {
    static final int OVERSCAN_PXL = 200;
    static final int TRACKING_MAX_PXL = 32;
    private static final boolean LOG_FPS = false;
    private static final int TIMELINE_HEIGHT = 22;
    static final int MARGIN_BOTTOM = 30;
    private static final int CACHE_STATE_HEIGHT = 4;
    static final int MARGIN_TOP = 8;
    private static final long MIN_WINDOW_MS = 10000L;
    private static final long MAX_WINDOW_MS = 92275200000L;
    private static final boolean DRAW_SYSTEM_STARTUPS = false;
    private static final Color BACKGROUND_COLOR = new JLabel().getBackground();
    private static final TexturePaint HATCHED_PATTERN;
    private final SimpleDateFormat secTimeFormat = new SimpleDateFormat("HH:mm:ss", SGUtils.getLocale());
    private final SimpleDateFormat minTimeFormat = new SimpleDateFormat("HH:mm", SGUtils.getLocale());
    private final SimpleDateFormat noTimeFormat = new SimpleDateFormat("", SGUtils.getLocale());
    private final SimpleDateFormat dayDateFormat = new SimpleDateFormat("MMM d", SGUtils.getLocale());
    private final SimpleDateFormat sMonthDateFormat = new SimpleDateFormat("MMM yyyy", SGUtils.getLocale());
    private final SimpleDateFormat lMonthDateFormat = new SimpleDateFormat("MMMM yyyy", SGUtils.getLocale());
    private final SimpleDateFormat yearDateFormat = new SimpleDateFormat("yyyy", SGUtils.getLocale());
    private final AppState appState;
    private final PanelState panelState;
    private final JPopupMenu contextMenu;
    private Font labelFont = new Font("Dialog", 0, 12);
    private int fontHeight = this.getFontMetrics(this.labelFont).getHeight();
    private long mouseDownMillis = -1L;
    private int mouseDownPointer = 0;
    private long trackingStartMillis = 0L;
    private int panDistance_;
    private double trackingPan_;
    private int pointerX;
    private int pointerY;
    private boolean isLeftMouseButtonDown;
    private boolean isRightMouseButtonDown;
    private Cursor openHandCursor;
    private Cursor closedHandCursor;
    private AffineTransform affineTransform = new AffineTransform();
    private Timer panTimer;
    private Timer repaintTimer;
    private boolean mouseCursor = true;
    private long lastPaint;
    public Ordinate leftOrdinate;
    public Ordinate rightOrdinate;
    private JToolTip toolTip;

    public PlotPanel(GraphTab tab, final AppState appState, final PanelState panelState) {
        this.appState = appState;
        this.panelState = panelState;
        this.leftOrdinate = new Ordinate(true);
        this.rightOrdinate = new Ordinate(false);
        this.setBackground(Color.white);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("OpenHand32x32.png"));
        this.openHandCursor = this.getToolkit().createCustomCursor(icon.getImage(), new Point(12, 11), "OPEN_HAND_CURSOR");
        icon = new ImageIcon(this.getClass().getResource("ClosedHand32x32.png"));
        this.closedHandCursor = this.getToolkit().createCustomCursor(icon.getImage(), new Point(12, 11), "CLOSED_HAND_CURSOR");
        this.setToolTipText("");
        this.repaintTimer = new Timer(30, new ActionListener(){

            @Override
            public synchronized void actionPerformed(ActionEvent ae) {
                if (PlotPanel.this.isShowing() && appState.getScope().contains(appState.getCursor())) {
                    PlotPanel.this.repaint();
                }
            }
        });
        this.repaintTimer.setInitialDelay(3000);
        this.repaintTimer.start();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PlotPanel.this.mouseButtonPressed(e)) {
                    return;
                }
                super.mousePressed(e);
                PlotPanel.this.mouseDownMillis = PlotPanel.this.map(PlotPanel.this.backward(e.getX()));
                PlotPanel.this.mouseDownPointer = e.getX();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    PlotPanel.this.repaint();
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    PlotPanel.this.setCursor(PlotPanel.this.closedHandCursor);
                    PlotPanel.this.panDistance_ = 0;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (PlotPanel.this.mouseButtonPressed(e)) {
                    return;
                }
                super.mouseReleased(e);
                int x = e.getX();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    PlotPanel.this.bakeAffineTransform();
                    long start = PlotPanel.this.mouseDownMillis;
                    long end = PlotPanel.this.map(x);
                    if (Math.abs(PlotPanel.this.mouseDownPointer - x) > 3) {
                        long duration;
                        if (start > end) {
                            long tmp = end;
                            end = start;
                            start = tmp;
                        }
                        if ((duration = end - start) > 92275200000L) {
                            start += (duration - 92275200000L) / 2L;
                            end -= (duration - 92275200000L) / 2L;
                        }
                        if (duration < 10000L) {
                            start += (duration - 10000L) / 2L;
                            end -= (duration - 10000L) / 2L;
                        }
                        appState.setScope(new Interval(start, end));
                    } else if (appState.getTimeLineEnd().isBefore(end)) {
                        appState.setTracking(true);
                    } else {
                        appState.setTracking(false);
                        appState.setCursor(new DateTime(end));
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    if (PlotPanel.this.panDistance_ != 0) {
                        PlotPanel.this.setCursor(null);
                        PlotPanel.this.bakeAffineTransform();
                    } else {
                        PlotPanel.this.contextMenu.show(PlotPanel.this, e.getX(), e.getY());
                    }
                }
                PlotPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PlotPanel.this.mouseCursor = false;
                ToolTipManager.sharedInstance().setDismissDelay(20000);
                PlotPanel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PlotPanel.this.mouseCursor = true;
                ToolTipManager.sharedInstance().setDismissDelay(2000);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                PlotPanel.this.pointerX = e.getX();
                PlotPanel.this.pointerY = e.getY();
                PlotPanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    int panDistance = e.getX() - PlotPanel.this.mouseDownPointer;
                    PlotPanel.this.affineTransform.translate(panDistance - PlotPanel.this.panDistance_, 0.0);
                    PlotPanel.this.panDistance_ = panDistance;
                    if (Math.abs(panDistance) > 200) {
                        PlotPanel.this.bakeAffineTransform();
                    }
                }
                PlotPanel.this.pointerX = e.getX();
                PlotPanel.this.pointerY = e.getY();
                PlotPanel.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (PlotPanel.this.mouseButtonPressed(e)) {
                    return;
                }
                int notches = e.getWheelRotation();
                if (!e.isControlDown()) {
                    AffineTransform aT = (AffineTransform)PlotPanel.this.affineTransform.clone();
                    double factor = e.isShiftDown() ? 0.02 : 0.1;
                    double zoomFactor = Math.pow(1.0 + factor, -1 * notches);
                    aT.translate((1.0 - zoomFactor) * (double)e.getX(), 0.0);
                    aT.scale(zoomFactor, 1.0);
                    if (PlotPanel.this.checkAffineTransform(aT)) {
                        PlotPanel.this.affineTransform = aT;
                    }
                } else {
                    double factor = e.isShiftDown() ? 5.0 : 40.0;
                    PlotPanel.this.affineTransform.translate(-1.0 * factor * (double)notches, 0.0);
                }
                PlotPanel.this.repaint();
                if (PlotPanel.this.panTimer != null) {
                    return;
                }
                PlotPanel.this.panTimer = new Timer(100, new ActionListener(){

                    @Override
                    public synchronized void actionPerformed(ActionEvent ae) {
                        PlotPanel.this.panTimer.stop();
                        PlotPanel.this.panTimer = null;
                        PlotPanel.this.bakeAffineTransform();
                    }
                });
                PlotPanel.this.panTimer.start();
            }
        });
        this.contextMenu = new JPopupMenu(){
            private Point location;

            @Override
            public Point getLocation() {
                return this.location;
            }

            @Override
            public void show(Component invoker, int x, int y) {
                this.location = new Point(x, y);
                super.show(invoker, x, y);
            }
        };
        JMenuItem copy = new JMenuItem("Copy Values");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateTime time = appState.getCursor();
                appState.getCursor();
                StringBuffer out = new StringBuffer();
                out.append(appState.zonedDateTimeFormat().print(time));
                for (Plot plot : panelState.getActivePlotsSorted()) {
                    Sample sample;
                    Descriptor descriptor = appState.getDescriptor(plot.parId);
                    if (descriptor == null || (sample = appState.cachedSample(plot.parId, time.getMillis())).isAbsent()) continue;
                    out.append("\n  ").append(descriptor.name).append(": ").append(appState.sampleLabel(plot.parId, sample, time.getMillis()));
                }
                StringSelection stringSelection = new StringSelection(out.toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            }
        });
        this.contextMenu.add(copy);
        this.labelFont = new Font("Dialog", 0, 12);
        this.fontHeight = this.getFontMetrics(this.labelFont).getHeight();
    }

    public long map(int x) {
        Interval scope = this.appState.getScope();
        return (long)((double)x / (double)this.getWidth() * (double)scope.toDurationMillis() + (double)scope.getStartMillis());
    }

    public int map(long millis) {
        double pxPerMs = (double)this.getWidth() / (double)this.appState.getScope().toDurationMillis();
        return (int)((double)(millis - this.appState.getScope().getStartMillis()) * pxPerMs);
    }

    public int map(ReadableInstant instant) {
        return this.map(instant.getMillis());
    }

    private boolean mouseButtonPressed(MouseEvent e) {
        if (this.isRightMouseButtonDown && !SwingUtilities.isRightMouseButton(e) || this.isLeftMouseButtonDown && !SwingUtilities.isLeftMouseButton(e)) {
            return true;
        }
        if (e instanceof MouseWheelEvent && (this.isLeftMouseButtonDown || this.isRightMouseButtonDown)) {
            return true;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (e.getID() == 501) {
                this.isRightMouseButtonDown = true;
            } else if (e.getID() == 502) {
                this.isRightMouseButtonDown = false;
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getID() == 501) {
                this.isLeftMouseButtonDown = true;
            } else if (e.getID() == 502) {
                this.isLeftMouseButtonDown = false;
            }
        }
        return false;
    }

    private int forward(int x) {
        if (this.affineTransform.isIdentity()) {
            return x;
        }
        double[] target = new double[2];
        this.affineTransform.transform(new double[]{x, 0.0}, 0, target, 0, 1);
        return (int)target[0];
    }

    private int backward(int x) {
        if (this.affineTransform.isIdentity()) {
            return x;
        }
        double[] target = new double[2];
        try {
            this.affineTransform.inverseTransform(new double[]{x, 0.0}, 0, target, 0, 1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return (int)target[0];
    }

    private void bakeAffineTransform() {
        if (this.affineTransform.isIdentity()) {
            return;
        }
        Interval scope = this.appState.getScope();
        scope = new Interval(this.map(this.backward(this.map(scope.getStartMillis()))), this.map(this.backward(this.map(scope.getEndMillis()))));
        this.affineTransform.setToIdentity();
        this.appState.setScope(scope);
    }

    private boolean checkAffineTransform(AffineTransform affineTransform) {
        double scaleX = affineTransform.getScaleX();
        long millis = (long)((double)this.appState.getScope().toDurationMillis() / scaleX);
        if (millis < 10000L) {
            return scaleX < 1.0;
        }
        if (millis > 92275200000L) {
            return scaleX > 1.0;
        }
        return true;
    }

    private double msPerPixel() {
        return (double)this.appState.getScope().toDurationMillis() / (double)this.getWidth();
    }

    @Override
    public void paint(Graphics g1d) {
        super.paint(g1d);
        long begin = System.nanoTime();
        Graphics2D g = (Graphics2D)g1d;
        Shape originalClip = g.getClip();
        AffineTransform originalTransform = g.getTransform();
        if (this.appState.isMode(GuiMode.TRACKING)) {
            long now = System.currentTimeMillis();
            if (this.trackingStartMillis == 0L) {
                this.trackingStartMillis = now;
            }
            long trackingMillis = this.trackingStartMillis - now;
            double trackingPan = (double)trackingMillis / this.msPerPixel();
            this.affineTransform.translate(trackingPan - this.trackingPan_, 0.0);
            this.trackingPan_ = trackingPan;
            if (trackingPan < -32.0) {
                long leftMillis = this.appState.getScope().getStartMillis() - trackingMillis;
                this.bakeAffineTransform();
                long bakeRoundingError = leftMillis - this.appState.getScope().getStartMillis();
                bakeRoundingError = 0L;
                this.trackingStartMillis = now - bakeRoundingError;
                this.trackingPan_ = 0.0;
            }
        } else {
            this.trackingStartMillis = 0L;
        }
        g.transform(this.affineTransform);
        g.setPaint(HATCHED_PATTERN);
        g.fillRect(-200, 0, this.getWidth() + 400, this.getHeight());
        this.drawCoverage(g);
        this.drawGrid(g);
        this.drawTimeline(g);
        if (SGUtils.isCapsLocked()) {
            this.drawTimeMapping(g);
        }
        for (Plot plot : this.panelState.getActivePlots()) {
            plot.draw(g, this);
        }
        this.drawTimeCursor(g);
        this.drawCacheState(g);
        g.setTransform(originalTransform);
        g.setClip(originalClip);
        if (this.isLeftMouseButtonDown) {
            this.drawDraggingRect(g, this.forward(this.map(this.mouseDownMillis)), this.pointerX);
        } else if (this.panelState.getDrawCursor()) {
            this.drawMouseCursor(g);
        }
        if (this.appState.settings.showAxes.getBoolean()) {
            this.leftOrdinate.draw(g);
            this.rightOrdinate.draw(g);
        }
        long now = System.nanoTime();
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Dimension d;
        int x = event.getX();
        int y = event.getY();
        Dimension dimension = d = this.toolTip == null ? new Dimension() : this.toolTip.getPreferredSize();
        if (x > this.getWidth() - 300) {
            x = (int)((double)x + -d.getWidth());
        }
        if (d.getHeight() < 80.0) {
            y = (int)((double)y + -d.getHeight());
        }
        return new Point(x, y);
    }

    @Override
    public JToolTip createToolTip() {
        this.toolTip = super.createToolTip();
        return this.toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText(event.getPoint());
    }

    public String getToolTipText(Point point) {
        int eventX = (int)point.getX();
        int eventY = (int)point.getY();
        long time = this.map(this.backward(eventX));
        Ordinate ordinate = this.getOrdinateAt(point);
        StringBuilder out = new StringBuilder("<html>");
        if (eventY - this.getY() < 8) {
            out.append("<b>What data is present?</b><br />").append("<span style='color: #C6E5FF'>&#9632;</span> All drawn or all parameters, full resolution<br />").append("<span style='color: #FFFFFF'>&#9632;</span> All drawn parameters, downsampled<br />").append("<span style='color: #CCF0D0'>&#9632;</span> Downsampled only (light-weight logfile)<br />").append("<span style='color: #E41600'>&#9632;</span> Queued for loading<br />").append("<span style='color: #FFBBB3'>&#9632;</span> Currently loading");
        } else {
            out.append("<i>");
            out.append(this.appState.zonedDateTimeFormat().print(time));
            out.append("</i><br />");
            if (SGUtils.isCapsLocked()) {
                out.append("<b>HwClock</b>: ").append(this.appState.millisToHwClock(time)).append("<br />");
            }
            if ((eventX < 50 || this.getWidth() - eventX < 50) && ordinate != null && ordinate.plot != null) {
                out.delete(6, 100).append("<i>Axis:</i><br />").append("<span style='color: ").append(ordinate.plot.getHexColor()).append("'>&#9632;</span>").append("<b> ").append(this.appState.getDescriptor((String)((Ordinate)ordinate).plot.parId).name).append("</b>");
            } else {
                Collection<Plot> hovered = this.getPlotsAt(new Point(this.backward(eventX), eventY), 12);
                if (hovered.isEmpty()) {
                    TimeLine.CoverageState state = this.appState.getTimeLine().getCoverage().get(new DateTime(time));
                    out.append("<span style='color: #888888'>");
                    if (state == TimeLine.CoverageState.RAW_FILES) {
                        out.append("Full log available");
                    } else if (state == TimeLine.CoverageState.DOWNSAMPLED) {
                        out.append("Downsampled Log");
                    } else if (state == TimeLine.CoverageState.NOT_INCLUDED) {
                        out.append("Log not available");
                    } else if (this.appState.getTimeLineEnd().isBefore(time)) {
                        out.append("Out of Scope");
                    } else {
                        out.append("System off");
                    }
                    out.append("</span>");
                }
                for (Plot plot : hovered) {
                    Sample sample;
                    Descriptor descriptor = this.appState.getDescriptor(plot.parId);
                    if (descriptor == null || (sample = this.appState.cachedSample(plot.parId, time)).isAbsent()) continue;
                    out.append("<span style='color: ").append(plot.getHexColor()).append("'>&#9632;</span> <b>").append(descriptor.name).append("</b>: ").append(this.appState.sampleLabel(plot.parId, sample, time)).append("<br />");
                }
            }
        }
        return out.append("</html>").toString();
    }

    private Collection<Plot> getPlotsAt(Point at, int tolerance) {
        LinkedList<Plot> hovered = new LinkedList<Plot>();
        int x = (int)at.getX();
        int y = (int)at.getY();
        Rectangle2D.Float cursor = new Rectangle2D.Float(x - tolerance, y - tolerance, 2 * tolerance, 2 * tolerance);
        for (Plot plot : this.panelState.getActivePlotsSorted()) {
            if (!plot.intersects(cursor)) continue;
            hovered.add(plot);
        }
        return hovered;
    }

    @Subscribe
    public void handleScopeUpdate(Interval scope) {
        this.repaint();
    }

    @Subscribe
    public void handleCacheUpdate(CacheUpdate cacheUpdate) {
        if (this.appState.getScope() == null) {
            return;
        }
        if (this.appState.isMode(GuiMode.TRACKING) && !cacheUpdate.getClkSpan().hasUpperBound()) {
            this.appState.setCursor(this.appState.getTimeLineEnd().minusMillis(10));
        }
        if (cacheUpdate.span.overlaps(this.appState.getScope())) {
            this.repaint();
        }
    }

    @Subscribe
    public void handleTrigger(Trigger trigger) {
        if (trigger.is("timeLineRepaint")) {
            this.repaint();
        }
    }

    private void drawGrid(Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        Color DIVISION_COLOR = new Color(0, 0, 0, 50);
        if (!this.appState.settings.showGrid.getBoolean()) {
            return;
        }
        gg.setColor(DIVISION_COLOR);
        gg.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 4.0f}, 0.0f));
        for (double y : this.leftOrdinate.getTicks()) {
            gg.drawLine(0, (int)y, this.getWidth(), (int)y);
        }
        gg.setStroke(new BasicStroke());
    }

    private void drawOrdinateAxis(Graphics g, boolean left, String[] labels, Color color) {
        Graphics2D gg = (Graphics2D)g;
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (labels.length == 0) {
            return;
        }
    }

    private void drawTimeMapping(Graphics2D g) {
        Graphics2D gg = g;
        TimeLine tl = this.appState.getTimeLine();
        int h = this.getHeight();
        RangeMap<DateTime, TimeMapping> mappings = tl.millisMap.subRangeMap(TimeLine.m(this.appState.getScope()));
        for (Map.Entry<Range<DateTime>, TimeMapping> entry : mappings.asMapOfRanges().entrySet()) {
            TimeMapping mapping = entry.getValue();
            if (mapping.getOrigin().equals((Object)TimeMapping.Origin.SINGULAR)) continue;
            Range<DateTime> timeRange = entry.getKey();
            Color c2 = Colors.getHashColor(0.8f, 0.6f, mapping);
            for (Map.Entry<HwClock, DateTime> anchor : mapping.anchors.entrySet()) {
                int x = this.map(anchor.getValue());
                gg.setColor(c2);
                gg.fillOval(x - 4, h - 12, 8, 8);
                gg.setColor(Color.WHITE);
                gg.drawOval(x - 4, h - 12, 8, 8);
            }
            gg.setColor(c2);
            if (this.msPerPixel() > 200.0) {
                Interval r = TimeLine.m(timeRange);
                int left = this.map(r.getStartMillis());
                int right = this.map(r.getEndMillis());
                gg.fillRect(left, h - 3, right - left, 3);
                continue;
            }
            HwClock cursor = mapping.map(timeRange.lowerEndpoint().getMillis());
            while (mapping.map(cursor).isBefore(timeRange.upperEndpoint())) {
                int x = this.map(mapping.map(cursor).getMillis());
                gg.fillRect(x - 2, h - 4, 4, 4);
                int ts = cursor.ts;
                int y = h - 22 - 10;
                if (this.msPerPixel() < 40.0) {
                    while (ts > 0) {
                        String label = String.format("%03d", ts % 1000);
                        gg.drawString(label, x - 10, y);
                        ts /= 1000;
                        y -= 10;
                    }
                }
                cursor = new HwClock(cursor.ts + 1);
            }
        }
    }

    private void drawTimeline(Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        long[] DURATIONS = new long[]{-1L, 31536000000L, 2592000000L, -1L, 604800000L, 86400000L, -1L, -1L, -1L, -1L, -1L, 3600000L, 60000L, 1000L};
        boolean MAJOR = false;
        boolean VALUE = true;
        int MINOR = 2;
        int TFORMAT = 3;
        int DFORMAT = 4;
        int CENTER = 5;
        Object[][] table = new Object[][]{{13, 1, 13, this.secTimeFormat, this.dayDateFormat, false}, {13, 2, 13, this.secTimeFormat, this.dayDateFormat, false}, {13, 5, 13, this.secTimeFormat, this.dayDateFormat, false}, {13, 10, 13, this.secTimeFormat, this.dayDateFormat, false}, {13, 30, 13, this.secTimeFormat, this.dayDateFormat, false}, {12, 1, 12, this.minTimeFormat, this.dayDateFormat, false}, {12, 2, 12, this.minTimeFormat, this.dayDateFormat, false}, {12, 5, 12, this.minTimeFormat, this.dayDateFormat, false}, {12, 10, 12, this.minTimeFormat, this.dayDateFormat, false}, {12, 30, 12, this.minTimeFormat, this.dayDateFormat, false}, {11, 1, 11, this.minTimeFormat, this.dayDateFormat, false}, {11, 2, 11, this.minTimeFormat, this.dayDateFormat, false}, {11, 4, 11, this.minTimeFormat, this.dayDateFormat, false}, {11, 6, 11, this.minTimeFormat, this.dayDateFormat, false}, {11, 12, 11, this.minTimeFormat, this.dayDateFormat, false}, {5, -1, 11, this.noTimeFormat, this.dayDateFormat, true}, {2, -1, 5, this.noTimeFormat, this.lMonthDateFormat, true}, {2, -1, 5, this.noTimeFormat, this.sMonthDateFormat, true}, {1, -1, 2, this.noTimeFormat, this.yearDateFormat, true}};
        Date sampleDate = new Date(978206399757L);
        int LABEL_OFFSET_Y = this.fontHeight;
        int TICK_HEIGHT = this.fontHeight;
        int MINOR_TICK_HEIGHT = 2;
        Color TIMELINE_COLOR = Color.black;
        int w = this.getWidth();
        int h = this.getHeight();
        gg.setColor(this.getBackground());
        gg.fillRect(-200, h - 22, w + 400, 22);
        gg.setFont(this.labelFont);
        gg.setColor(TIMELINE_COLOR);
        gg.drawLine(-200, h - 22, w + 200, h - 22);
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long majorInterval = 0L;
        long minorInterval = 0L;
        int majorField = 0;
        int minorField = 0;
        int value = 0;
        boolean centeredLabel = false;
        DateFormat timeFormat = null;
        DateFormat dateFormat = null;
        for (int i = 0; i < table.length; ++i) {
            int minPxInterval;
            value = (Integer)table[i][1];
            majorField = (Integer)table[i][0];
            minorField = (Integer)table[i][2];
            majorInterval = DURATIONS[majorField] * (long)Math.abs(value);
            minorInterval = DURATIONS[minorField];
            timeFormat = (SimpleDateFormat)table[i][3];
            dateFormat = (SimpleDateFormat)table[i][4];
            centeredLabel = (Boolean)table[i][5];
            int pxInterval = (int)(majorInterval * (long)w / this.appState.getScope().toDurationMillis());
            if (pxInterval >= (minPxInterval = (int)(1.2 * (double)this.getFontMetrics(this.labelFont).stringWidth(timeFormat.format(sampleDate))) + (int)(1.2 * (double)this.getFontMetrics(this.labelFont).stringWidth(dateFormat.format(sampleDate))))) break;
        }
        timeFormat.setTimeZone(this.appState.getConfiguredTimeZone().toTimeZone());
        dateFormat.setTimeZone(this.appState.getConfiguredTimeZone().toTimeZone());
        long currentTick = this.appState.getScope().getStartMillis() - 2L * majorInterval;
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"), SGUtils.getLocale());
        c2.setTimeZone(this.appState.getConfiguredTimeZone().toTimeZone());
        do {
            long nextTickApprox = currentTick + (long)(1.4 * (double)minorInterval);
            c2.setTimeInMillis(nextTickApprox);
            c2 = DateUtils.truncate(c2, minorField);
            currentTick = c2.getTimeInMillis();
            double prop = (double)w / (double)this.appState.getScope().toDurationMillis();
            int tickX = (int)(prop * (double)(currentTick - this.appState.getScope().getStartMillis()));
            if (value < 0 && c2.get(minorField) == c2.getMinimum(minorField) || value > 0 && c2.get(majorField) % value == 0) {
                Date tickTime = new Date(currentTick);
                String dateLabel = dateFormat.format(tickTime);
                String timeLabel = timeFormat.format(tickTime);
                int dateLabelOffset = !centeredLabel ? (int)(-1.1 * (double)g.getFontMetrics().stringWidth(dateLabel)) : (int)((prop * (double)majorInterval - (double)g.getFontMetrics().stringWidth(dateLabel)) / 2.0);
                int timeLabelOffset = (int)(0.1 * (double)g.getFontMetrics().stringWidth(timeLabel));
                gg.drawLine(tickX, h - 22, tickX, h - 22 + TICK_HEIGHT);
                gg.drawString(dateLabel, tickX + dateLabelOffset, h - 22 + LABEL_OFFSET_Y);
                gg.drawString(timeLabel, tickX + timeLabelOffset, h - 22 + LABEL_OFFSET_Y);
                continue;
            }
            gg.drawLine(tickX, h - 22, tickX, h - 22 + 2);
        } while (currentTick < this.appState.getScope().getEndMillis());
    }

    private void drawCacheState(Graphics g) {
        Interval scope = this.appState.getScope();
        Range<DateTime> targetRange = TimeLine.pad(TimeLine.m(scope), (long)(this.msPerPixel() * 200.0));
        try {
            targetRange = targetRange.intersection(Range.atMost(this.appState.getTimeLineEnd()));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        RangeMap<DateTime, CacheVisualizer.DataState> scopedDataState = this.appState.getCacheState().subRangeMap(targetRange);
        for (Map.Entry<Range<DateTime>, CacheVisualizer.DataState> entry : scopedDataState.asMapOfRanges().entrySet()) {
            CacheVisualizer.DataState dataState = entry.getValue();
            int left = this.map(entry.getKey().lowerEndpoint());
            int right = this.map(entry.getKey().upperEndpoint());
            switch (dataState) {
                case VOID: {
                    g.setColor(new Color(250, 236, 235, 230));
                    g.fillRect(left, 0, right - left, this.getHeight() - 22);
                    g.setColor(new Color(228, 22, 0));
                    g.fillRect(left, 0, right - left, 4);
                    break;
                }
                case MISSING: {
                    g.setColor(new Color(228, 22, 0));
                    g.fillRect(left, 0, right - left, 4);
                    break;
                }
                case LOADING: {
                    g.setColor(new Color(255, 187, 179));
                    g.fillRect(left, 0, right - left, 4);
                    break;
                }
                case FULLRES_REMAINING: {
                    g.setColor(new Color(198, 229, 255));
                    g.fillRect(left, 0, right - left, 4);
                    break;
                }
                case PRUNED: {
                    g.setColor(new Color(204, 240, 208));
                    g.fillRect(left, 0, right - left, 4);
                    break;
                }
                case FAILED: {
                    g.setColor(new Color(150, 150, 150));
                    g.fillRect(left, 0, right - left, 4);
                }
            }
        }
    }

    private void drawCoverage(Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        Range<DateTime> targetScope = TimeLine.pad(TimeLine.m(this.appState.getScope()), (long)(this.msPerPixel() * 200.0));
        for (Map.Entry<Range<DateTime>, TimeLine.CoverageState> n : this.appState.getTimeLine().getCoverage().asMapOfRanges().entrySet()) {
            if (!n.getKey().isConnected(targetScope)) continue;
            switch (n.getValue()) {
                case DOWNSAMPLED: 
                case RAW_FILES: {
                    gg.setColor(Color.WHITE);
                    break;
                }
                case NOT_INCLUDED: {
                    gg.setColor(new Color(240, 240, 240));
                }
            }
            int left = this.map(n.getKey().lowerEndpoint().getMillis());
            int width = this.map(n.getKey().upperEndpoint().getMillis()) - left;
            gg.fillRect(left, 0, width, this.getHeight());
            int s = 2;
            if (this.appState.getScope().toDuration().getStandardHours() <= 3L) continue;
            s = 1;
        }
    }

    private void drawMouseCursor(Graphics g) {
        if (!this.mouseCursor) {
            return;
        }
        Color MOUSE_CURSOR_COLOR = new Color(0, 0, 0, 107);
        g.setColor(MOUSE_CURSOR_COLOR);
        g.drawLine(this.pointerX, 0, this.pointerX, this.getHeight() - 22);
    }

    private void drawTimeCursor(Graphics g) {
        Color TIME_CURSOR_COLOR = Color.black;
        Graphics2D gg = (Graphics2D)g;
        int x = this.map(this.appState.getCursor());
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gg.setStroke(new BasicStroke(3.0f));
        g.setColor(Color.white);
        gg.drawLine(x, 0, x, this.getHeight() - 22 - 3);
        float[] arr = new float[]{10.0f, 5.0f};
        float dash_phase = 15.0f - (float)(System.currentTimeMillis() / 2L % 1000L) / 1000.0f * 15.0f;
        gg.setStroke(new BasicStroke(1.5f, 0, 0, 10.0f, arr, dash_phase));
        g.setColor(TIME_CURSOR_COLOR);
        gg.drawLine(x, 0, x, this.getHeight() - 22 - 0);
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        gg.setStroke(new BasicStroke());
    }

    private void drawDraggingRect(Graphics g, int startPos, int currentPos) {
        Color DRAGGING_CURSOR_COLOR = new Color(128, 128, 128, 128);
        Color DRAGGING_AREA_COLOR = new Color(192, 192, 192, 72);
        g.setColor(DRAGGING_AREA_COLOR);
        g.fillRect(Math.min(startPos, currentPos), 0, Math.abs(currentPos - startPos), this.getHeight() - 22);
        g.setColor(DRAGGING_CURSOR_COLOR);
    }

    Ordinate getOrdinateAt(Point location) {
        return location.x < this.getWidth() / 2 ? this.leftOrdinate : this.rightOrdinate;
    }

    private GraphPlot selectNewOrdinate() {
        HashSet<GraphPlot> plots = this.panelState.getGraphPlots();
        GraphPlot other = null;
        if (this.leftOrdinate.plot != null && this.leftOrdinate.plot.isActive() && ((Ordinate)this.leftOrdinate).plot.transform != null && this.appState.getDescriptor(((Ordinate)this.leftOrdinate).plot.parId) != null) {
            other = this.leftOrdinate.plot;
        } else if (this.rightOrdinate.plot != null && this.rightOrdinate.plot.isActive() && ((Ordinate)this.rightOrdinate).plot.transform != null && this.appState.getDescriptor(((Ordinate)this.rightOrdinate).plot.parId) != null) {
            other = this.rightOrdinate.plot;
        }
        if (other == null) {
            for (GraphPlot plot : plots) {
                if (!plot.isActive() || plot.transform == null || this.appState.getDescriptor(plot.parId) == null) continue;
                return plot;
            }
            return null;
        }
        GraphPlot newOrdinate = null;
        for (GraphPlot plot : plots) {
            if (!plot.isActive() || plot == other || this.appState.getDescriptor(plot.parId) == null || plot.transform == null) continue;
            newOrdinate = plot;
            break;
        }
        return newOrdinate;
    }

    static /* synthetic */ int access$1500(PlotPanel x0) {
        return x0.fontHeight;
    }

    static {
        BufferedImage img = new BufferedImage(8, 8, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setColor(BACKGROUND_COLOR);
        g2d.fillRect(0, 0, 8, 8);
        g2d.setColor(new Color(204, 204, 204));
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawLine(0, 1, 1, 0);
        g2d.drawLine(0, 9, 9, 0);
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, 8.0f, 8.0f);
        HATCHED_PATTERN = new TexturePaint(img, rect);
    }

    class Ordinate {
        private static final int WIDTH = 150;
        final int TICK_WIDTH = 6;
        final int LABEL_Y_OFFSET = (int)Math.round((double)PlotPanel.access$1500(PlotPanel.this) * 0.25);
        final int LABEL_X_OFFSET = 9;
        private static final int ARC = 50;
        private static final int HL_STROKE = 4;
        private final boolean isLeft;
        private GraphPlot plot;
        private Image buffer;
        private long buffered = 0L;
        boolean highlight = false;

        Ordinate(boolean isLeft) {
            this.isLeft = isLeft;
        }

        public void setPlot(GraphPlot plot) {
            this.plot = plot;
            this.buffered = 0L;
        }

        private long calculateHash() {
            return Objects.hashCode(this.plot.getRange(), this.plot.getColor(), PlotPanel.this.getHeight(), this.plot.getUnit());
        }

        void draw(Graphics g) {
            Graphics2D gg = (Graphics2D)g;
            int zero = this.isLeft ? 4 : PlotPanel.this.getWidth() - 150 - 4;
            BasicStroke dashed = new BasicStroke(4.0f, 0, 2, 0.0f, new float[]{10.0f, 10.0f}, 0.0f);
            if (this.plot == null || !this.plot.isActive() || this.plot.transform == null || PlotPanel.this.appState.getDescriptor(this.plot.parId) == null) {
                this.plot = PlotPanel.this.selectNewOrdinate();
            }
            if (this.plot != null) {
                if (this.buffered != this.calculateHash()) {
                    this.render(g);
                }
                g.drawImage(this.buffer, zero, 0, null);
            }
            if (this.highlight) {
                gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gg.setColor(new Color(255, 255, 255, 96));
                gg.fillRoundRect(zero, 8, 150, PlotPanel.this.getHeight() - 30 - 8, 50, 50);
                gg.setColor(Color.darkGray);
                gg.setStroke(dashed);
                gg.drawRoundRect(zero, 8, 150, PlotPanel.this.getHeight() - 30 - 8, 50, 50);
                gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }

        private void render(Graphics g) {
            if (this.plot.transform == null) {
                this.buffer = null;
                return;
            }
            Graphics2D gg = (Graphics2D)g;
            int height = PlotPanel.this.getHeight();
            DecimalFormat format = new DecimalFormat("########.######");
            this.buffer = gg.getDeviceConfiguration().createCompatibleImage(150, height, 3);
            gg = (Graphics2D)this.buffer.getGraphics();
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Range<Double> range = this.plot.getRange();
            Color fixed = this.plot.getColor();
            float MAX_LUMA = 0.55f;
            if (Colors.getLuma(fixed) > 0.55f) {
                fixed = Colors.fixLuma(fixed, 0.55f);
            }
            int dir = this.isLeft ? 1 : -1;
            int x = this.isLeft ? 0 : 150;
            x += dir;
            FontMetrics fm = PlotPanel.this.getFontMetrics(PlotPanel.this.labelFont);
            Descriptor d = PlotPanel.this.appState.getDescriptor(this.plot.parId);
            gg.setFont(PlotPanel.this.labelFont);
            BasicStroke stroke = new BasicStroke(3.0f, 1, 1);
            gg.setStroke(stroke);
            gg.setColor(Color.white);
            double[] ticks = this.getTicks();
            int h = (int)ticks[10];
            gg.drawLine(x, (int)ticks[0], x, h);
            double stepSize = 0.1;
            int decimalPlaces = 1;
            if (this.plot.scaling == GraphPlot.Scaling.LINEAR) {
                stepSize = (range.upperEndpoint() - range.lowerEndpoint()) / 10.0;
            } else {
                double exponentMax;
                double minDecimalPlacesFrom0;
                double diff = range.upperEndpoint() - range.lowerEndpoint();
                if (diff > 0.0 && (minDecimalPlacesFrom0 = Math.floor(Math.log10(diff))) < (exponentMax = Math.floor(Math.log10(range.upperEndpoint()))) && (decimalPlaces = (int)exponentMax - (int)minDecimalPlacesFrom0) > 5) {
                    decimalPlaces = 5;
                }
            }
            for (int i = 0; i < 11; ++i) {
                String label;
                double value;
                double y = ticks[10 - i];
                int sY = (int)(Math.round(y) + (long)this.LABEL_Y_OFFSET);
                if (this.plot.scaling == GraphPlot.Scaling.LINEAR) {
                    value = range.lowerEndpoint() + (double)i * stepSize;
                    label = format.format(value) + " " + d.unit;
                } else {
                    value = this.plot.transform.unmap(y);
                    double e = Math.floor(Math.log10(value));
                    double m = value * Math.pow(0.1, e);
                    label = String.format("%." + decimalPlaces + "f E %.0f %s", m, e, d.unit);
                }
                int labelXOffset = this.isLeft ? 0 : fm.stringWidth(label);
                int sX = x + dir * (9 + labelXOffset);
                TextLayout outline = new TextLayout(label, PlotPanel.this.labelFont, gg.getFontRenderContext());
                gg.setStroke(new BasicStroke(2.0f, 1, 1));
                gg.setColor(Color.white);
                Shape shape = outline.getOutline(AffineTransform.getTranslateInstance(sX, sY));
                gg.draw(shape);
                gg.setStroke(new BasicStroke(3.0f));
                gg.drawLine(x, (int)y, x + dir * 6, (int)y);
                gg.setColor(fixed);
                gg.setStroke(new BasicStroke(1.0f));
                gg.drawLine(x, (int)y, x + dir * 6, (int)y);
                gg.fill(shape);
            }
            gg.drawLine(x, (int)ticks[0], x, h);
            this.buffered = this.calculateHash();
        }

        double[] getTicks() {
            double[] y = new double[11];
            double step = ((double)PlotPanel.this.getHeight() - 30.0 - 8.0) / 10.0;
            for (int i = 0; i < 11; ++i) {
                y[i] = 8.0 + (double)i * step;
            }
            return y;
        }
    }
}

