/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.NamedThreadFactory;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.PlotPanel;
import ch.bruker.jac.servicegui.graphical.ShapeBuffer;
import com.google.common.collect.Range;
import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.joda.time.Interval;

public abstract class Plot {
    public final String parId;
    PanelState state;
    private boolean active = false;
    protected ShapeBuffer buffer;
    private static ExecutorService worker = Executors.newSingleThreadExecutor(new NamedThreadFactory("Rendering Worker", 1));
    private Future<?> busy;

    Plot(Descriptor descriptor, PanelState state) {
        this.parId = descriptor.id;
        this.active = descriptor.defaultSelected;
        this.state = state;
        this.buffer = new ShapeBuffer();
    }

    static Path2D.Double reversePath(Path2D.Double path) {
        class Segment {
            private double[] coords = new double[6];
            private int type;

            Segment() {
            }
        }
        LinkedList<Segment> segments = new LinkedList<Segment>();
        PathIterator pi = path.getPathIterator(null);
        while (!pi.isDone()) {
            Segment s = new Segment();
            s.type = pi.currentSegment(s.coords);
            segments.push(s);
            pi.next();
        }
        Path2D.Double reverse = new Path2D.Double();
        int type = 0;
        for (Segment s : segments) {
            switch (type) {
                case 0: {
                    reverse.moveTo(s.coords[0], s.coords[1]);
                    break;
                }
                case 1: {
                    reverse.lineTo(s.coords[0], s.coords[1]);
                    break;
                }
                case 2: {
                    reverse.quadTo(s.coords[0], s.coords[1], s.coords[2], s.coords[3]);
                    break;
                }
                case 3: {
                    reverse.curveTo(s.coords[0], s.coords[1], s.coords[2], s.coords[3], s.coords[4], s.coords[5]);
                }
            }
            type = s.type;
        }
        return reverse;
    }

    abstract ShapeBuffer render(PlotPanel var1);

    private void checkBuffer(final PlotPanel target, Graphics2D g) {
        if (this.buffer.isValid(target, this.state.app)) {
            return;
        }
        if (this.busy != null && !this.busy.isDone()) {
            return;
        }
        final Plot plotRef = this;
        this.busy = worker.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ShapeBuffer buffer_ = Plot.this.render(target);
                    Plot plot = plotRef;
                    synchronized (plot) {
                        Plot.this.buffer = buffer_;
                    }
                }
                catch (Exception unexpected) {
                    unexpected.printStackTrace();
                }
                target.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g, PlotPanel target) {
        this.checkBuffer(target, g);
        AffineTransform initialTransform = g.getTransform();
        Interval appScope = this.state.app.getScope();
        Plot plot = this;
        synchronized (plot) {
            if (this.buffer.scope != null && !this.buffer.scope.equals(appScope)) {
                AffineTransform t = new AffineTransform();
                double dScale = (double)this.buffer.scope.toDurationMillis() / (double)appScope.toDurationMillis();
                double dMillis = this.buffer.scope.getStartMillis() - appScope.getStartMillis();
                double millisToPixel = (double)target.getWidth() / (double)appScope.toDurationMillis();
                t.translate(dMillis * millisToPixel, 0.0);
                t.scale(dScale, 1.0);
                g.transform(t);
            }
            Color color = this.getColor();
            Color light = new Color(color.getRed(), color.getGreen(), color.getBlue(), 50);
            Color darker = color.darker();
            g.setStroke(new BasicStroke(1.0f, 0, 2));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(light);
            for (Shape shape : this.buffer.fillLight) {
                g.fill(shape);
            }
            g.setColor(color);
            for (Shape shape : this.buffer.stroke) {
                g.draw(shape);
            }
            for (Shape shape : this.buffer.knockoutStroke) {
                g.setColor(Color.WHITE);
                g.fill(shape);
                g.setColor(color);
                g.draw(shape);
            }
            g.setColor(darker);
            for (Shape shape : this.buffer.fillDark) {
                g.fill(shape);
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setTransform(initialTransform);
    }

    @Subscribe
    public void handleCacheUpdate(CacheUpdate cacheUpdate) {
        if (!cacheUpdate.span.overlaps(this.state.app.getScope())) {
            return;
        }
        if (cacheUpdate.parIds.contains(this.parId) || cacheUpdate.parIds.contains("errordata")) {
            this.buffer.invalidate();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.state.app.setParVisibility(this.parId, active);
        this.state.updates.post(new Trigger("panelRefresh"));
    }

    public Color getColor() {
        return this.state.getColor(this);
    }

    public void setColor(Color newColor) {
        this.state.setColor(this, newColor);
    }

    public boolean equals(Object that) {
        if (!(that instanceof Plot)) {
            return false;
        }
        return this.parId.equals(((Plot)that).parId);
    }

    public String getRangeText() {
        return " - ";
    }

    public String toString() {
        return this.parId;
    }

    public abstract Range<Double> getClippingRange();

    public Range<Double> getRange() {
        return null;
    }

    public String getHexColor() {
        Color c2 = this.getColor();
        return String.format("#%02X%02X%02X", c2.getRed(), c2.getGreen(), c2.getBlue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean intersects(Rectangle2D target) {
        Plot plot = this;
        synchronized (plot) {
            if (this.buffer.collision == null) {
                this.buffer.collision = new Area();
                for (Shape lineShape : this.buffer.fillLight) {
                    this.buffer.collision.add(new Area(lineShape));
                }
            }
            return this.buffer.collision.intersects(target) || !this.buffer.fillLight.isEmpty() && this.buffer.fillLight.get(0).intersects(target);
        }
    }
}

