/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Colors;
import ch.bruker.jac.servicegui.TransferHandler_;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.GraphTab;
import ch.bruker.jac.servicegui.graphical.JumboFrame;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.RangeCellEditor;
import ch.bruker.jac.servicegui.systems.Settings;
import ch.bruker.util.PopupListener;
import ch.bruker.util.treetable.AbstractTreeTableModel;
import ch.bruker.util.treetable.BooleanCellRenderer;
import ch.bruker.util.treetable.ColorCellEditor;
import ch.bruker.util.treetable.ColorRenderer;
import ch.bruker.util.treetable.JTreeTable;
import ch.bruker.util.treetable.TreeTableModel;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreePath;
import org.joda.time.DateTime;

class ParPanel
extends JPanel {
    static final DataFlavor PLOT_FLAVOR = new DataFlavor(GraphPlot.class, "Linear Plot");
    private final AppState appState;
    private final PanelState panelState;
    private final GraphTab parent;
    private Cols[] colValues = Cols.values();
    private JTreeTable treeTable;
    private PlotTreeTableModel dataModel;

    ParPanel(GraphTab tab, PanelState panelState) {
        this.parent = tab;
        this.panelState = panelState;
        this.appState = panelState.app;
        this.setLayout(new GridBagLayout());
        this.rearrange(true);
    }

    @Subscribe
    public void handleCursorUpdate(DateTime cursor) {
        this.rearrange(false);
        this.appState.prepareData(cursor.getMillis(), Collections.singleton(""));
    }

    @Subscribe
    public void handleCacheUpdate(CacheUpdate update) {
        if (update.span.contains(this.appState.getCursor())) {
            this.rearrange(false);
        }
    }

    @Subscribe
    public void handleTrigger(Trigger trigger) {
        if (trigger.is("panelRebuild")) {
            this.rearrange(true);
        } else if (trigger.is("panelRefresh")) {
            this.rearrange(false);
        }
    }

    public void rearrange(boolean fullRebuild) {
        if (fullRebuild) {
            this.removeAll();
            this.addTreeTable();
        } else {
            this.treeTable.repaint();
        }
        this.revalidate();
        this.parent.repaint();
    }

    private void addTreeTable() {
        this.dataModel = new PlotTreeTableModel();
        this.treeTable = new JTreeTable(this.dataModel);
        this.treeTable.setCellPrinter(new JTreeTable.CellPrinter(){

            @Override
            public String toString(Object o) {
                if (o instanceof Plot) {
                    Plot plot = (Plot)o;
                    Descriptor descriptor = ParPanel.this.appState.getDescriptor(plot.parId);
                    if (descriptor == null) {
                        return "<html><i>(No Header)</i></html>";
                    }
                    return descriptor.name;
                }
                return null;
            }
        });
        Color background = this.treeTable.getBackground();
        Color selected = Colors.fixLuma(background, Colors.getLuma(background) * 0.8f);
        this.treeTable.setSelectionBackground(selected);
        this.treeTable.setSelectionForeground(Color.black);
        this.treeTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.treeTable.setBackground(this.getBackground());
        this.treeTable.setRootVisible(false);
        this.expandGroupsWithSelectedDataRows(this.dataModel);
        this.treeTable.setDefaultRenderer(Color.class, new ColorRenderer());
        this.treeTable.setDefaultEditor(Color.class, new ColorCellEditor(this.parent));
        this.treeTable.setDefaultRenderer(Boolean.class, new BooleanCellRenderer());
        this.treeTable.setDefaultEditor(Range.class, new RangeCellEditor(this.parent, this.appState));
        DefaultTableCellRenderer tooltippedRenderer = new DefaultTableCellRenderer(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return ((DefaultTableCellRenderer)event.getSource()).getText();
            }
        };
        tooltippedRenderer.setHorizontalAlignment(4);
        this.treeTable.getColumnModel().getColumn(3).setCellRenderer(tooltippedRenderer);
        this.treeTable.getColumnModel().getColumn(4).setCellRenderer(tooltippedRenderer);
        this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.treeTable.getColumnModel().getColumn(1).setMinWidth(22);
        this.treeTable.getColumnModel().getColumn(1).setMaxWidth(22);
        this.treeTable.getColumnModel().getColumn(1).setResizable(false);
        this.treeTable.getColumnModel().getColumn(2).setMinWidth(22);
        this.treeTable.getColumnModel().getColumn(2).setMaxWidth(22);
        this.treeTable.getColumnModel().getColumn(2).setResizable(false);
        this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setDragEnabled(true);
        this.treeTable.setTransferHandler(new DragHandler(this.treeTable));
        this.appState.wrapTransferHandler(this.treeTable);
        this.addContextMenu(this.treeTable);
        JScrollPane scrollPane = new JScrollPane(this.treeTable, 20, 31);
        Dimension d = scrollPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(390, d.height));
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void expandGroupsWithSelectedDataRows(PlotTreeTableModel dataModel) {
        for (int i = dataModel.getChildCount(dataModel.getRoot()) - 1; i >= 0; --i) {
            String group = (String)dataModel.getChild(dataModel.getRoot(), i);
            boolean expand = false;
            for (int j = 0; j < dataModel.getChildCount(group); ++j) {
                Plot plot = (Plot)dataModel.getChild(group, j);
                if (!plot.isActive()) continue;
                expand = true;
                break;
            }
            if (!expand) continue;
            this.treeTable.expandRow(i);
        }
    }

    private void addContextMenu(final JTreeTable toComponent) {
        JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem label = new JMenuItem("Select parameters:");
        label.setEnabled(false);
        contextMenu.add(label);
        contextMenu.add(new JPopupMenu.Separator());
        JMenuItem deselectAll = new JMenuItem("None");
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Plot plot : ParPanel.this.panelState.getActivePlots()) {
                    plot.setActive(false);
                }
                ParPanel.this.parent.repaint();
            }
        });
        contextMenu.add(deselectAll);
        JMenuItem activateSameUnit = new JMenuItem("Same unit");
        activateSameUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path;
                Point pos = null;
                for (MouseListener listener : toComponent.getMouseListeners()) {
                    if (!(listener instanceof PopupListener)) continue;
                    pos = ((PopupListener)listener).getLastPos();
                    break;
                }
                if (!((path = toComponent.getTree().getPathForRow(toComponent.getTree().getClosestRowForLocation(pos.x, pos.y))).getLastPathComponent() instanceof Plot)) {
                    return;
                }
                Plot plot = (Plot)path.getLastPathComponent();
                String unit = ((ParPanel)ParPanel.this).appState.getDescriptor((String)plot.parId).unit;
                for (Plot plot_ : ParPanel.this.panelState.getPlots().values()) {
                    Descriptor descriptor = ParPanel.this.appState.getDescriptor(plot_.parId);
                    if (descriptor == null || !unit.equals(descriptor.unit)) continue;
                    plot_.setActive(true);
                }
                ParPanel.this.parent.repaint();
            }
        });
        contextMenu.add(activateSameUnit);
        JMenuItem activateSameRange = new JMenuItem("Same range");
        activateSameRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path;
                Point pos = null;
                for (MouseListener listener : toComponent.getMouseListeners()) {
                    if (!(listener instanceof PopupListener)) continue;
                    pos = ((PopupListener)listener).getLastPos();
                    break;
                }
                if (!((path = toComponent.getTree().getPathForRow(toComponent.getTree().getClosestRowForLocation(pos.x, pos.y))).getLastPathComponent() instanceof Plot)) {
                    return;
                }
                Plot plot = (Plot)path.getLastPathComponent();
                String unit = ((ParPanel)ParPanel.this).appState.getDescriptor((String)plot.parId).unit;
                for (Plot plot_ : ParPanel.this.panelState.getPlots().values()) {
                    Descriptor descriptor = ParPanel.this.appState.getDescriptor(plot_.parId);
                    if (descriptor == null || !unit.equals(descriptor.unit) || !plot.getRangeText().equals(plot_.getRangeText())) continue;
                    plot_.setActive(true);
                }
                ParPanel.this.parent.repaint();
            }
        });
        contextMenu.add(activateSameRange);
        JMenuItem activateSameGroup = new JMenuItem("Same group");
        activateSameGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path;
                Point pos = null;
                for (MouseListener listener : toComponent.getMouseListeners()) {
                    if (!(listener instanceof PopupListener)) continue;
                    pos = ((PopupListener)listener).getLastPos();
                    break;
                }
                if (!((path = toComponent.getTree().getPathForRow(toComponent.getTree().getClosestRowForLocation(pos.x, pos.y))).getLastPathComponent() instanceof Plot)) {
                    return;
                }
                Plot plot = (Plot)path.getLastPathComponent();
                String group = ((ParPanel)ParPanel.this).appState.getDescriptor((String)plot.parId).guiGroupLabel;
                for (Plot plot_ : ParPanel.this.panelState.getPlots().values()) {
                    Descriptor descriptor = ParPanel.this.appState.getDescriptor(plot_.parId);
                    if (descriptor == null || !group.equals(descriptor.guiGroupLabel)) continue;
                    plot_.setActive(true);
                }
                ParPanel.this.parent.repaint();
            }
        });
        contextMenu.add(activateSameGroup);
        JMenuItem defaults = new JMenuItem("Default set");
        defaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Plot plot : ParPanel.this.panelState.getPlots().values()) {
                    Descriptor descriptor = ParPanel.this.appState.getDescriptor(plot.parId);
                    if (descriptor == null) continue;
                    plot.setActive(descriptor.defaultSelected);
                }
                ParPanel.this.parent.repaint();
            }
        });
        contextMenu.add(defaults);
        contextMenu.add(new JPopupMenu.Separator());
        JMenuItem jumboView = new JMenuItem("Jumbo view");
        jumboView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path;
                Point pos = null;
                for (MouseListener listener : toComponent.getMouseListeners()) {
                    if (!(listener instanceof PopupListener)) continue;
                    pos = ((PopupListener)listener).getLastPos();
                    break;
                }
                if (!((path = toComponent.getTree().getPathForRow(toComponent.getTree().getClosestRowForLocation(pos.x, pos.y))).getLastPathComponent() instanceof Plot)) {
                    return;
                }
                Plot plot = (Plot)path.getLastPathComponent();
                final JumboFrame jumboFrame = new JumboFrame(ParPanel.this.appState, plot.parId, ParPanel.this);
                jumboFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ((ParPanel)ParPanel.this).appState.updates.unregister(jumboFrame);
                    }
                });
                ((ParPanel)ParPanel.this).appState.updates.register(jumboFrame);
            }
        });
        contextMenu.add(jumboView);
        toComponent.addMouseListener(new PopupListener(contextMenu));
    }

    private class DragHandler
    extends TransferHandler_ {
        private JTreeTable table;

        DragHandler(JTreeTable table) {
            this.table = table;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return false;
        }

        @Override
        public Transferable createTransferable(JComponent c2) {
            int row = this.table.getSelectedRow();
            Object value = this.table.getModel().getValueAt(row, 0);
            if (!(value instanceof GraphPlot)) {
                return null;
            }
            final GraphPlot plot = (GraphPlot)value;
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{PLOT_FLAVOR};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(PLOT_FLAVOR);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return plot;
                }
            };
        }

        @Override
        public int getSourceActions(JComponent c2) {
            if (this.table == c2) {
                return 0x40000000;
            }
            return super.getSourceActions(c2);
        }
    }

    private class PlotTreeTableModel
    extends AbstractTreeTableModel {
        final String[] cNames;
        final Class<?>[] cTypes;
        final boolean[] isEditable;

        PlotTreeTableModel() {
            super(new Object());
            this.cNames = new String[]{"Name", "", "", "Value", "Range"};
            this.cTypes = new Class[]{TreeTableModel.class, Boolean.class, Color.class, String.class, Range.class};
            this.isEditable = new boolean[]{false, true, true, false, true};
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 4) {
                Settings.ScalingModes mode = ((ParPanel)ParPanel.this).appState.settings.scaling.get();
                return mode == Settings.ScalingModes.BASE_DIV ? "Offs / Div" : "Min\u2026Max";
            }
            return this.cNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.cTypes[column];
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            if (node instanceof String) {
                return super.isCellEditable(node, column);
            }
            return this.isEditable[column];
        }

        @Override
        public Object getValueAt(Object node, int column) {
            if (node instanceof Plot) {
                Plot plot = (Plot)node;
                switch (ParPanel.this.colValues[column]) {
                    case LABEL: {
                        return plot;
                    }
                    case ACTIVE: {
                        return plot.isActive();
                    }
                    case COLOR: {
                        return plot.getColor();
                    }
                    case VALUE: {
                        return ParPanel.this.appState.sampleLabel(plot.parId, ParPanel.this.appState.getCursor().getMillis());
                    }
                    case RANGE: {
                        Range<Double> range = plot.getRange();
                        if (range == null) {
                            return "";
                        }
                        return plot.getRangeText();
                    }
                }
            }
            if (node instanceof String) {
                if (column == 0) {
                    return node;
                }
                return null;
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, Object node, int column) {
            if (node instanceof Plot) {
                Plot plot = (Plot)node;
                switch (ParPanel.this.colValues[column]) {
                    case LABEL: {
                        break;
                    }
                    case ACTIVE: {
                        plot.setActive((Boolean)value);
                        break;
                    }
                    case COLOR: {
                        plot.setColor((Color)value);
                        break;
                    }
                    case VALUE: {
                        break;
                    }
                    case RANGE: {
                        ((GraphPlot)plot).setClippingRange((Range)value);
                    }
                }
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof String) {
                String parId = (String)Iterables.get(ParPanel.this.panelState.getGroups().get((Object)((String)parent)), index);
                return ParPanel.this.panelState.getPlots().get(parId);
            }
            if (parent == this.root) {
                return Iterables.get(ParPanel.this.panelState.getGroups().keySet(), index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof String) {
                return ((AbstractCollection)ParPanel.this.panelState.getGroups().get((Object)((String)parent))).size();
            }
            if (parent == this.root) {
                return ((AbstractCollection)((Object)ParPanel.this.panelState.getGroups().keySet())).size();
            }
            return 0;
        }
    }

    static enum Cols {
        LABEL,
        ACTIVE,
        COLOR,
        VALUE,
        RANGE;

    }
}

