/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.AbstractState;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Colors;
import ch.bruker.jac.servicegui.JacServiceGui;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.PlotPanel;
import ch.bruker.jac.servicegui.graphical.StatePlot;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class PanelState
extends AbstractState {
    public final AppState app;
    private final File USER_GRAPH_COLORS_FILE = new File(JacServiceGui.USER_HOME, "jac_servicegui/user_graph_colors.config");
    private final HashMap<String, Color> userColors;
    private HashMap<String, Plot> plots;
    private Set<String> activePlotsButNotPresentInCurrentHeader = new TreeSet<String>();
    private ImmutableMultimap<String, String> groups;
    private boolean drawCursor;
    private PlotPanel.Ordinate left;
    private PlotPanel.Ordinate right;

    PanelState(AppState appState) {
        super("Panel");
        this.app = appState;
        this.plots = new HashMap();
        this.groups = ImmutableMultimap.of();
        this.drawCursor = true;
        this.userColors = (HashMap)this.app.settings.colors.getObject();
        if (this.userColors.isEmpty() && this.USER_GRAPH_COLORS_FILE.exists()) {
            this.migrateUserColors();
        }
    }

    private void migrateUserColors() {
        ImmutableSet<Integer> legacyPalette = ImmutableSet.copyOf(new Integer[]{0, 0xFF0000, 65280, 255, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0x993366, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 0x800080, 52479, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x333399, 0x333333});
        SGUtils.log("Migrating user defined colors.\n", new Object[0]);
        try {
            FileInputStream stream = new FileInputStream(this.USER_GRAPH_COLORS_FILE);
            TreeMap legacyColors = (TreeMap)new ObjectInputStream(stream).readObject();
            for (Map.Entry entry : legacyColors.entrySet()) {
                int asIntWithoutAlpha;
                Descriptor descriptor = this.app.getYoungestDescriptor((String)entry.getKey());
                if (descriptor == null || legacyPalette.contains(asIntWithoutAlpha = ((Color)entry.getValue()).getRGB() & 0xFFFFFF)) continue;
                this.userColors.put((String)entry.getKey(), (Color)entry.getValue());
            }
            this.storeColors();
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        SGUtils.log("Could not load user defined colors.", new Object[0]);
    }

    @Subscribe
    public void handleUserLevelUpdate(JacPublicDefinitions.UserLevel userLevel) {
        this.handleHeaderUpdate(this.app.cursorHeader);
    }

    @Subscribe
    public void handleHeaderUpdate(Header header) {
        Plot plot;
        String plotId;
        ImmutableMultimap.Builder builder = ((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().orderKeysBy(header.getGuiGroupOrder())).orderValuesBy(header.getGuiParOrder());
        for (Map.Entry<String, Descriptor> entry : header.descriptors.entrySet()) {
            if (entry.getValue() == null || entry.getValue().eventLogged) continue;
            plotId = entry.getKey();
            if (this.app.getUserLevel().equals((Object)JacPublicDefinitions.UserLevel.USER) && this.app.system.visiblePars != null && !this.app.system.visiblePars.isEmpty() && !this.app.system.visiblePars.contains(entry.getValue().id)) continue;
            ((ImmutableListMultimap.Builder)builder).put(entry.getValue().guiGroupLabel, plotId);
            if (this.plots.containsKey(plotId)) continue;
            plot = entry.getValue().createPlot(this);
            this.plots.put(plotId, plot);
            if (this.activePlotsButNotPresentInCurrentHeader.contains(plotId)) {
                plot.setActive(true);
                this.activePlotsButNotPresentInCurrentHeader.remove(plotId);
            }
            this.app.setParVisibility(plotId, plot.isActive());
        }
        ImmutableMultimap newOrder = ((ImmutableListMultimap.Builder)builder).build();
        Iterator<String> it = this.plots.keySet().iterator();
        while (it.hasNext()) {
            plotId = it.next();
            if (plotId == null || newOrder.containsValue(plotId)) continue;
            plot = this.plots.get(plotId);
            if (plot != null && plot.isActive()) {
                this.activePlotsButNotPresentInCurrentHeader.add(plotId);
                plot.setActive(false);
            }
            it.remove();
        }
        if (((ImmutableSet)newOrder.keySet()).asList().equals(((ImmutableSet)this.groups.keySet()).asList()) && this.groups.equals(newOrder) && !newOrder.isEmpty()) {
            return;
        }
        this.groups = newOrder;
        this.updates.post(new Trigger("panelRebuild"));
    }

    Map<String, Plot> getPlots() {
        return ImmutableMap.copyOf(this.plots);
    }

    HashSet<Plot> getActivePlots() {
        HashSet<Plot> active = new HashSet<Plot>();
        for (Plot plot : this.plots.values()) {
            if (plot == null || !plot.isActive()) continue;
            active.add(plot);
        }
        return active;
    }

    List<Plot> getActivePlotsSorted() {
        LinkedList<Plot> active = new LinkedList<Plot>();
        for (Plot plot : this.plots.values()) {
            if (plot == null || !plot.isActive()) continue;
            active.add(plot);
        }
        Collections.sort(active, new PlotOrder());
        return active;
    }

    HashSet<GraphPlot> getGraphPlots() {
        HashSet<GraphPlot> graphPlots = new HashSet<GraphPlot>();
        for (Plot plot : this.plots.values()) {
            if (!(plot instanceof GraphPlot)) continue;
            graphPlots.add((GraphPlot)plot);
        }
        return graphPlots;
    }

    private void storeColors() {
        this.app.settings.colors.set(this.userColors);
    }

    @Subscribe
    public void handleTriggers(Trigger event) {
        if (event.is("resetColors")) {
            this.userColors.clear();
            this.storeColors();
        }
    }

    public ImmutableMultimap<String, String> getGroups() {
        return this.groups;
    }

    public boolean getDrawCursor() {
        return this.drawCursor;
    }

    public void setDrawCursor(boolean drawCursor) {
        this.drawCursor = drawCursor;
    }

    public Color getColor(Plot plot) {
        Descriptor descriptor;
        float saturation = 0.8f;
        float luma = 0.7f;
        Color c2 = this.userColors.get(plot.parId);
        if (c2 == null && (descriptor = this.app.getYoungestDescriptor(plot.parId)) != null && descriptor.color != null) {
            c2 = descriptor.color;
        }
        if (c2 == null) {
            c2 = plot.isActive() ? Colors.getHashColor(0.8f, 0.7f, plot.parId) : new Color(0, 0, 0, 0);
        }
        return c2;
    }

    public void setColor(Plot plot, Color newColor) {
        this.userColors.put(plot.parId, newColor);
        this.storeColors();
    }

    public int getStatePlotIdx(StatePlot statePlot) {
        int idx = 0;
        for (String parId : this.groups.values()) {
            if (parId.equals(statePlot.parId)) {
                return idx;
            }
            if (!this.plots.get(parId).isActive() || !(this.plots.get(parId) instanceof StatePlot)) continue;
            ++idx;
        }
        return idx;
    }

    class PlotOrder
    implements Comparator<Plot> {
        final ImmutableList<String> order;

        public PlotOrder() {
            Collection groupsOrder = PanelState.this.groups.values();
            this.order = ((ImmutableCollection)groupsOrder).asList();
        }

        @Override
        public int compare(Plot p1, Plot p2) {
            return Integer.valueOf(this.order.indexOf(p1.parId)).compareTo(this.order.indexOf(p2.parId));
        }
    }
}

