/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.graphical.ParPanel;
import ch.bruker.jac.servicegui.graphical.PlotPanel;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class OrdinateDropTargetListener
implements DropTargetListener {
    private PlotPanel pane;
    private boolean feedbackFlavor = false;

    OrdinateDropTargetListener(PlotPanel pane) {
        this.pane = pane;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.feedbackFlavor = dtde.getCurrentDataFlavors()[0].equals(ParPanel.PLOT_FLAVOR);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.handleDrag(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.handleDrag(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.pane.leftOrdinate.highlight = false;
        this.pane.rightOrdinate.highlight = false;
        this.pane.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    private void handleDrag(DropTargetDragEvent evt) {
        int dropAction = evt.getDropAction();
        this.pane.leftOrdinate.highlight = false;
        this.pane.rightOrdinate.highlight = false;
        PlotPanel.Ordinate ordinate = this.pane.getOrdinateAt(evt.getLocation());
        if (this.feedbackFlavor) {
            evt.acceptDrag(dropAction);
            ordinate.highlight = true;
        }
        this.pane.repaint();
    }
}

