/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.graphical.Transform;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;

class LinearTransform
extends Transform {
    private final double scale;
    private final double off;

    LinearTransform(double a2, double a_, double z, double z_) {
        super(a2, a_, z, z_);
        this.scale = (a_ - z_) / (a2 - z);
        this.off = a_ - a2 * this.scale;
    }

    @Override
    public double map(double val) {
        return val * this.scale + this.off;
    }

    @Override
    public double unmap(double val) {
        return (val - this.off) / this.scale;
    }

    @Override
    public Shape mapX(Shape path) {
        AffineTransform at = new AffineTransform();
        at.translate(0.0, this.off);
        at.scale(1.0, this.scale);
        return new Path2D.Float(path, at);
    }
}

