/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.joda.time.DateTime;

public class JumboFrame
extends JFrame {
    private final AppState appState;
    private final String parId;
    private final FullSizeLabel valueLabel;

    public JumboFrame(AppState appState, String parId, Component parent) {
        this.appState = appState;
        this.parId = parId;
        this.setDefaultCloseOperation(2);
        Descriptor descriptor = appState.getDescriptor(parId);
        if (descriptor != null) {
            this.setTitle(descriptor.name);
        }
        this.setIconImages(SGUtils.PROGRAM_ICONS);
        this.setBounds(100, 100, 672, 567);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(contentPane);
        this.valueLabel = new FullSizeLabel("");
        contentPane.add((Component)this.valueLabel, "Center");
        this.setExtendedState(this.getExtendedState() | 6);
        this.setLocationRelativeTo(parent);
        this.handleCursorUpdate(appState.getCursor());
        this.setVisible(true);
    }

    @Subscribe
    public void handleCursorUpdate(DateTime cursor) {
        this.update(cursor);
    }

    @Subscribe
    public void handleCacheUpdate(CacheUpdate update) {
        DateTime cursor = this.appState.getCursor();
        if (update.span.contains(cursor)) {
            this.update(cursor);
        }
    }

    private void update(DateTime cursor) {
        this.valueLabel.setText(this.appState.sampleLabel(this.parId, cursor.getMillis()));
        this.valueLabel.adaptLabelFont(this.valueLabel);
    }

    public class FullSizeLabel
    extends JLabel {
        public static final int MIN_FONT_SIZE = 3;
        public static final int MAX_FONT_SIZE = 4000;
        Graphics graphics;

        public FullSizeLabel(String text) {
            super(text);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    FullSizeLabel.this.adaptLabelFont(FullSizeLabel.this);
                }
            });
        }

        public void adaptLabelFont(JLabel label) {
            int check;
            if (this.graphics == null) {
                return;
            }
            Rectangle r = label.getBounds();
            Font font = label.getFont();
            int above = 4000;
            int below = 3;
            while (true) {
                check = below + (above - below) / 2;
                Dimension d = this.getTextSize(label, font.deriveFont(font.getStyle(), check));
                if (d.getWidth() > r.getWidth() || d.getHeight() > r.getHeight()) {
                    if (check == above) break;
                    above = check;
                    continue;
                }
                if (check == below) break;
                below = check;
            }
            this.setFont(font.deriveFont(font.getStyle(), check));
            this.repaint();
        }

        private Dimension getTextSize(JLabel label, Font font) {
            Dimension size = new Dimension();
            this.graphics.setFont(font);
            FontMetrics fm = this.graphics.getFontMetrics(font);
            size.width = fm.stringWidth(label.getText());
            size.height = fm.getHeight();
            return size;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.graphics = graphics;
        }
    }
}

