/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GlobalPanel;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.Manifest;
import ch.bruker.jac.servicegui.Tab;
import ch.bruker.jac.servicegui.TransferHandler_;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.OrdinateDropTargetListener;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.ParPanel;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.PlotPanel;
import ch.bruker.jac.servicegui.systems.Settings;
import ch.bruker.jac.servicegui.text.TextLogPanel;
import ch.bruker.jac.servicegui.text.TextLogState;
import ch.bruker.util.IconButton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Date;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormatter;

public class GraphTab
extends Tab {
    static final int NR_OF_TICKS = 11;
    private final AppState appState;
    private final PanelState panelState;
    private final ParPanel parPanel;
    private final PlotPanel plotPanel;

    public GraphTab(final AppState appState, TextLogState textLogState) {
        this.appState = appState;
        this.panelState = new PanelState(appState);
        appState.updates.register(this.panelState);
        this.plotPanel = new PlotPanel(this, appState, this.panelState);
        appState.updates.register(this.plotPanel);
        this.plotPanel.setTransferHandler(new TransferHandler_(){

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                Point location;
                GraphPlot plot;
                try {
                    plot = (GraphPlot)support.getTransferable().getTransferData(ParPanel.PLOT_FLAVOR);
                    location = support.getDropLocation().getDropPoint();
                }
                catch (ClassCastException e) {
                    return false;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                if (!appState.settings.showAxes.getBoolean()) {
                    appState.settings.showAxes.set(true);
                }
                plot.setActive(true);
                PlotPanel.Ordinate ordinate = GraphTab.this.plotPanel.getOrdinateAt(location);
                if (ordinate == null) {
                    return false;
                }
                ordinate.setPlot(plot);
                ordinate.highlight = false;
                return true;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(ParPanel.PLOT_FLAVOR);
            }
        });
        appState.wrapTransferHandler(this.plotPanel);
        OrdinateDropTargetListener listener = new OrdinateDropTargetListener(this.plotPanel);
        try {
            this.plotPanel.getDropTarget().addDropTargetListener(listener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        IconButton autoZoomButton = new IconButton("Auto-Scale: Fit all displayed graphs into panel", "AutoZoom.png");
        autoZoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GraphTab.this.autoScale();
            }
        });
        IconButton normalZoomButton = new IconButton("Normal Scale: Apply to each displayed graph its individually defined scaling", "NormalZoom.png");
        normalZoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GraphTab.this.normalScale();
            }
        });
        IconButton allButton = new IconButton("All", "all.png");
        allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                appState.setScopeFull();
            }
        });
        final GlobalPanel nav = new GlobalPanel(appState, autoZoomButton, normalZoomButton, new JSeparator(1), new ZoomButton("1 Hour", "Hour.png", Period.hours(1)), new ZoomButton("1 Day", "Day.png", Period.days(1)), new ZoomButton("14 Days", "Week.png", Period.days(14)), new ZoomButton("3 Months", "3Months.png", Period.weeks(12)), new JSeparator(1), allButton);
        appState.updates.register(nav);
        this.parPanel = new ParPanel(this, this.panelState);
        this.panelState.updates.register(this.parPanel);
        appState.updates.register(this.parPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)nav, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
        JComponent timeLine = this.plotPanel;
        if (Settings.textLogInTimeLine.getBoolean()) {
            TextLogPanel textLog = new TextLogPanel(textLogState);
            textLogState.registerUpdates(textLog);
            JSplitPane timeLinePanel = new JSplitPane(0, this.plotPanel, textLog);
            timeLinePanel.setResizeWeight(1.0);
            timeLinePanel.setDividerLocation(0.9);
            timeLinePanel.setResizeWeight(0.8);
            timeLine = timeLinePanel;
        }
        JSplitPane parsAndTimeline = new JSplitPane(1, this.parPanel, timeLine);
        parsAndTimeline.setDividerLocation(400);
        parsAndTimeline.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                nav.setExtrasInset((Integer)evt.getNewValue());
            }
        });
        this.add((Component)parsAndTimeline, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
    }

    public PanelState getState() {
        return this.panelState;
    }

    void autoScale() {
        for (GraphPlot plot : this.panelState.getGraphPlots()) {
            plot.setClipping();
        }
        this.plotPanel.repaint();
        this.parPanel.rearrange(false);
    }

    void normalScale() {
        for (GraphPlot plot : this.panelState.getGraphPlots()) {
            plot.resetClipping();
        }
        this.plotPanel.repaint();
        this.parPanel.rearrange(false);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int LEGEND_LINE_HEIGHT = 20;
        int MARGIN = 25;
        int MIN_PAGE_BORDERS = 35;
        DateTimeFormatter dateFormat = this.appState.zonedDateTimeFormat();
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double xTrans = pageFormat.getImageableX();
        double yTrans = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        if (xTrans < 35.0 && yTrans < 35.0) {
            pageWidth = pageWidth + 2.0 * xTrans - 70.0;
            pageHeight = pageHeight + 2.0 * yTrans - 70.0;
            xTrans = 35.0;
            yTrans = 35.0;
        }
        g2d.translate(xTrans, yTrans);
        int legendHeight = this.panelState.getActivePlots().size() * 20 + 150;
        double xScale = pageWidth / (double)this.plotPanel.getWidth();
        double yScale = pageHeight / (double)(this.plotPanel.getHeight() + legendHeight);
        double minScale = Math.min(xScale, yScale);
        int graphicWidth = (int)((double)this.plotPanel.getWidth() * minScale);
        int graphicHeight = (int)((double)this.plotPanel.getHeight() * minScale);
        Shape originalClip = g2d.getClip();
        AffineTransform originalTransform = g2d.getTransform();
        g2d.scale(minScale, minScale);
        this.plotPanel.setDoubleBuffered(false);
        this.panelState.setDrawCursor(false);
        this.plotPanel.paint(g2d);
        this.plotPanel.setDoubleBuffered(true);
        this.panelState.setDrawCursor(true);
        g2d.setTransform(originalTransform);
        g2d.setClip(originalClip);
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke());
        g2d.drawRect(0, 0, graphicWidth, graphicHeight);
        int offset = graphicHeight + 25 + g2d.getFontMetrics().getHeight();
        FontMetrics fm = g2d.getFontMetrics();
        int LEGEND_BOX_SIZE = fm.getAscent() - fm.getDescent();
        String startTime = dateFormat.print(this.appState.getScope().getStart());
        String endTime = dateFormat.print(this.appState.getScope().getEnd());
        g2d.drawString("Data range:   " + startTime + " \u2026" + endTime, 0, offset);
        g2d.drawString("Legend", 0, offset += 25);
        offset += 25;
        for (Plot plot : this.panelState.getPlots().values()) {
            if (!plot.isActive()) continue;
            g2d.setColor(plot.getColor());
            g2d.fillRect(0, offset - LEGEND_BOX_SIZE, LEGEND_BOX_SIZE, LEGEND_BOX_SIZE);
            g2d.setColor(Color.black);
            String name = this.appState.getDescriptor((String)plot.parId).name;
            g2d.drawString(name, 2 * LEGEND_BOX_SIZE, offset);
            String rangeText = plot.getRangeText();
            int alignRight = (int)fm.getStringBounds(rangeText, g2d).getWidth();
            g2d.drawString(rangeText, graphicWidth - alignRight, offset);
            offset += 20;
        }
        String printedBy = "Printed by JAC service tool " + Manifest.versionString();
        g2d.setFont(g2d.getFont().deriveFont(2, 8.0f));
        g2d.setColor(Color.gray);
        g2d.drawString(printedBy + "    " + new Date(), 0, (int)pageHeight);
        return 0;
    }

    private class ZoomButton
    extends IconButton {
        ZoomButton(String label, String icon, final Period duration) {
            super(label, icon);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GraphTab.this.appState.isMode(GuiMode.TRACKING)) {
                        GraphTab.this.appState.setScopeOnCursor(0.95, duration.toStandardDuration());
                    } else {
                        GraphTab.this.appState.setScope(duration.toStandardDuration());
                    }
                    GraphTab.this.plotPanel.repaint();
                    ((GraphTab)GraphTab.this).appState.updates.post(new Trigger("reorderQueue"));
                }
            });
        }
    }
}

