/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.ContinuousSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.cache.FixedDescriptor;
import ch.bruker.jac.servicegui.data.cache.FloatDescriptor;
import ch.bruker.jac.servicegui.data.cache.NumericDescriptor;
import ch.bruker.jac.servicegui.graphical.LinearTransform;
import ch.bruker.jac.servicegui.graphical.LogTransform;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.PlotPanel;
import ch.bruker.jac.servicegui.graphical.ShapeBuffer;
import ch.bruker.jac.servicegui.graphical.Transform;
import ch.bruker.jac.servicegui.systems.Settings;
import com.google.common.collect.Range;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GraphPlot
extends Plot {
    private static final int SUBSAMPLING = 2;
    boolean updateClipping = false;
    private Range<Double> clippingRange = Range.all();
    private Range<Double> valueRange;
    private Range<Double> guiRange;
    private Range<Double> descriptorRange;
    private final float resolution;
    final Scaling scaling;
    protected Transform transform;

    public GraphPlot(FixedDescriptor descriptor, PanelState state) {
        super(descriptor, state);
        this.scaling = Scaling.LINEAR;
        this.guiRange = Range.closed(descriptor.guiMin, descriptor.guiMax);
        this.descriptorRange = Range.closed(descriptor.min, descriptor.max);
        this.resolution = descriptor.specifiedResolution;
        this.valueRange = this.guiRange;
    }

    public GraphPlot(FloatDescriptor descriptor, PanelState state) {
        super(descriptor, state);
        this.scaling = Scaling.LOGARITHMIC;
        double min = descriptor.guiMin;
        if (min <= 0.0) {
            min = 0.1f;
        }
        this.guiRange = Range.closed(min, descriptor.guiMax);
        this.descriptorRange = Range.closed(descriptor.min, descriptor.max);
        this.resolution = Float.MIN_NORMAL;
        this.valueRange = this.guiRange;
    }

    @Override
    public Range<Double> getRange() {
        Range<Double> range = this.guiRange;
        if (this.clippingRange.hasLowerBound()) {
            range = this.clippingRange;
        }
        if (range.upperEndpoint() - range.lowerEndpoint() == 0.0) {
            if (this.scaling.equals((Object)Scaling.LOGARITHMIC)) {
                return Range.closed(range.upperEndpoint() / 10.0, range.upperEndpoint() * 10.0);
            }
            double val = range.lowerEndpoint();
            range = Range.closed(val - (double)(5.0f * this.resolution), val + (double)(5.0f * this.resolution));
        }
        return range;
    }

    @Override
    ShapeBuffer render(PlotPanel target) {
        Range<Double> clippingRange_;
        ShapeBuffer buffer = new ShapeBuffer(target, this.state.app);
        boolean draw_outliers = this.state.app.settings.shadeOutliers.getBoolean();
        int msPerPixel = (int)(this.state.app.getScope().toDurationMillis() / (long)target.getWidth());
        Duration overscan = new Duration((long)msPerPixel * 200L);
        Interval renderScope = new Interval((ReadableInstant)this.state.app.getScope().getStart().minus(overscan), (ReadableInstant)this.state.app.getScope().getEnd().plus(overscan));
        Path2D.Double valPath = new Path2D.Double();
        Path2D.Double peakPath = new Path2D.Double();
        Path2D.Double tempPath = new Path2D.Double();
        double valueMax = Double.NEGATIVE_INFINITY;
        double valueMin = Double.POSITIVE_INFINITY;
        int pxl = -200;
        int count = (target.getWidth() + 400) / 2;
        ArrayList<Sample> samples = this.state.app.cachedSamples(this.parId, renderScope, count);
        boolean cut = true;
        for (Sample s : samples) {
            if (s.isVoid()) {
                pxl += 2;
                continue;
            }
            if (s.isAbsent()) {
                pxl += 2;
                cut = true;
                continue;
            }
            ContinuousSample sample = (ContinuousSample)s;
            if (Double.isInfinite(sample.avg)) {
                pxl += 2;
                cut = true;
                continue;
            }
            double avg = this.limit(sample.avg, this.descriptorRange);
            double min = this.limit(sample.min, this.descriptorRange);
            double max = this.limit(sample.max, this.descriptorRange);
            if (cut) {
                valPath.moveTo(pxl, avg);
                if (draw_outliers) {
                    peakPath.append(GraphPlot.reversePath(tempPath), true);
                    tempPath = new Path2D.Double();
                    peakPath.moveTo(pxl, min);
                    tempPath.moveTo(pxl, max);
                }
                cut = false;
            } else {
                valPath.lineTo(pxl, avg);
                if (draw_outliers) {
                    peakPath.lineTo(pxl, min);
                    tempPath.lineTo(pxl, max);
                }
            }
            if (pxl > 0 && pxl < target.getWidth()) {
                valueMin = Math.min(valueMin, min);
                valueMax = Math.max(valueMax, max);
            }
            pxl += 2;
        }
        if (pxl == -200) {
            return buffer;
        }
        if (valueMin > valueMax) {
            return buffer;
        }
        this.valueRange = Range.closed(valueMin, valueMax);
        if (this.updateClipping && !(clippingRange_ = this.prettyRange(this.valueRange)).equals(this.clippingRange)) {
            this.clippingRange = clippingRange_;
            this.state.app.updates.post(new Trigger("panelRefresh"));
        }
        Range<Double> effRange = this.getRange();
        Range<Double> targetRange = Range.closed(8.0, (double)target.getHeight() - 30.0);
        this.transform = this.scaling == Scaling.LINEAR ? new LinearTransform(effRange.lowerEndpoint(), targetRange.upperEndpoint(), effRange.upperEndpoint(), targetRange.lowerEndpoint()) : new LogTransform(effRange.lowerEndpoint(), targetRange.upperEndpoint(), effRange.upperEndpoint(), targetRange.lowerEndpoint());
        buffer.stroke.add(this.transform.mapX(valPath));
        boolean showRaw = msPerPixel < 400;
        int r = (int)Math.sqrt(400.0 / (double)msPerPixel);
        int l = (int)Math.sqrt(800.0 / (double)msPerPixel);
        if (showRaw) {
            pxl = -200;
            Path2D.Double rawSamples = new Path2D.Double();
            for (Sample s : samples) {
                if (s.isValid() && !Double.isInfinite(((ContinuousSample)s).avg)) {
                    ContinuousSample sample = (ContinuousSample)s;
                    int y = (int)this.transform.map(sample.avg);
                    if (sample.isFlagged()) {
                        int pxl_ = pxl + 2;
                        rawSamples.append(new Line2D.Float(pxl_ - l, (float)y - (float)l, pxl_ + l, y + l).getPathIterator(null), false);
                        rawSamples.append(new Line2D.Float(pxl_ - l, (float)y + (float)l, pxl_ + l, y - l).getPathIterator(null), false);
                    } else {
                        rawSamples.append(new Ellipse2D.Float(pxl - r, (float)y - (float)r, 2 * r, 2 * r).getPathIterator(null), false);
                    }
                    rawSamples.moveTo(pxl, sample.avg);
                }
                pxl += 2;
            }
            buffer.knockoutStroke.add(rawSamples);
        }
        if (draw_outliers) {
            peakPath.append(GraphPlot.reversePath(tempPath), true);
            peakPath.closePath();
            buffer.fillLight.add(this.transform.mapX(peakPath));
        }
        return buffer;
    }

    private double limit(double v, Range<Double> range) {
        if (v < range.lowerEndpoint()) {
            v = range.lowerEndpoint();
        }
        if (v > range.upperEndpoint()) {
            v = range.upperEndpoint();
        }
        return v;
    }

    private boolean isOffDiv() {
        return this.state.app.settings.scaling.get() == Settings.ScalingModes.BASE_DIV;
    }

    double getDiv() {
        Range<Double> range = this.getRange();
        if (this.scaling == Scaling.LINEAR) {
            return (range.upperEndpoint() - range.lowerEndpoint()) / 10.0;
        }
        return Math.exp(Math.log(range.upperEndpoint() / range.lowerEndpoint()) / 10.0);
    }

    @Override
    public String getRangeText() {
        Range<Double> range = this.getRange();
        NumericDescriptor d = (NumericDescriptor)this.state.app.getDescriptor(this.parId);
        if (d == null) {
            return "-d?-";
        }
        String lower = d.format(range.lowerEndpoint());
        if (range.lowerEndpoint() == 0.0) {
            lower = "0";
        }
        StringBuilder text = new StringBuilder();
        if (this.updateClipping) {
            text.append("<html><em>");
        }
        double div = this.getDiv();
        if (this.scaling == Scaling.LINEAR) {
            if (this.isOffDiv()) {
                text.append(lower).append(" / ").append(d.formatWithUnit(div).trim());
            } else {
                text.append(lower).append("\u2026").append(d.formatWithUnit(range.upperEndpoint()));
            }
        } else if (this.isOffDiv()) {
            text.append(d.formatWithUnit(range.lowerEndpoint()));
            text.append(String.format(" / %.2f\u00d7", div));
        } else {
            text.append(lower).append("\u2026").append(d.formatWithUnit(range.upperEndpoint()));
        }
        if (this.updateClipping) {
            text.append("</em></html>");
        }
        return text.toString();
    }

    @Override
    public Range<Double> getClippingRange() {
        return this.clippingRange;
    }

    public void setClippingRange(Range<Double> clippingRange) {
        this.clippingRange = clippingRange;
    }

    public String getUnit() {
        Descriptor d = this.state.app.getDescriptor(this.parId);
        if (d != null) {
            return d.unit;
        }
        return "";
    }

    public void setClipping() {
        this.clippingRange = this.prettyRange(this.valueRange);
        this.buffer.invalidate();
    }

    public void setAutoUpdateClipping(boolean autoUpdate) {
        this.updateClipping = autoUpdate;
        this.buffer.invalidate();
    }

    public void resetClipping() {
        this.clippingRange = Range.all();
        this.buffer.invalidate();
    }

    private Range<Double> prettyRange(Range<Double> range) {
        if (!this.state.app.settings.roundAxisRange.getBoolean()) {
            return range;
        }
        double span = range.upperEndpoint() - range.lowerEndpoint();
        if (this.scaling.equals((Object)Scaling.LOGARITHMIC)) {
            if (span == 0.0) {
                return Range.closed(range.upperEndpoint() / 10.0, range.upperEndpoint() * 10.0);
            }
            return range;
        }
        if (span <= 0.0) {
            double newLower;
            double newUpper = range.lowerEndpoint() + (double)(4.0f * this.resolution);
            if (newUpper - (newLower = range.lowerEndpoint() - (double)(4.0f * this.resolution)) > 0.0) {
                return this.prettyRange(Range.closed(newLower, newUpper));
            }
            return Range.closed(range.upperEndpoint(), range.upperEndpoint());
        }
        double discriminator = (Math.log10(span) + 10.0) % 1.0;
        double factor = 10.0;
        if (discriminator < Math.log10(2.0)) {
            factor = 2.0;
        } else if (discriminator < Math.log10(2.5)) {
            factor = 2.5;
        } else if (discriminator < Math.log10(5.0)) {
            factor = 5.0;
        }
        double prettySpan = factor * Math.pow(10.0, Math.ceil(Math.log10(span / factor)));
        double lower = Math.floor(range.lowerEndpoint() / (prettySpan / 10.0)) * prettySpan / 10.0;
        double resultingSpan = span + range.lowerEndpoint() - lower;
        if (resultingSpan > prettySpan) {
            return this.prettyRange(Range.closed(lower, range.upperEndpoint()));
        }
        return Range.closed(lower, lower + prettySpan);
    }

    static enum Scaling {
        LINEAR,
        LOGARITHMIC;

    }
}

