/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.io;

import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.data.io.CachingDir;
import ch.bruker.jac.servicegui.data.io.Dir;
import ch.bruker.jac.servicegui.data.io.SourceProperties;
import ch.bruker.jac.servicegui.systems.Settings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public abstract class Source {
    public final Dir archives;
    public final Dir current;
    public final Dir sysMsg;
    public final ApiTalker api;
    public final Jac origin;
    public final File localCache;
    protected final SourceProperties systemProperties;

    protected Source(SourceProperties systemProperties, ApiTalker api, Jac system, String sourceType) {
        String cachePath = Settings.workingPath.getString() + "/caches/" + system.getFsCompatibleLabel() + "/" + sourceType;
        File cache = new File(cachePath);
        if (!cache.isDirectory()) {
            try {
                cache.getCanonicalFile().mkdirs();
            }
            catch (IOException e) {
                cache = null;
            }
        }
        this.localCache = cache;
        this.systemProperties = systemProperties;
        this.archives = systemProperties.archivesCachingDir ? new CachingDir(systemProperties.archivesPath).bind(this) : new Dir(systemProperties.archivesPath).bind(this);
        this.current = new Dir(systemProperties.liveLogPath).bind(this);
        this.sysMsg = new Dir(systemProperties.sysMsgPath).bind(this);
        this.api = api;
        this.origin = system;
    }

    abstract InputStream stream(String var1) throws IOException;

    public abstract void release();

    abstract Collection<String> ls(String var1);

    abstract boolean isDirectory(String var1);

    abstract long getFileSize(String var1) throws IOException;

    public abstract boolean reconnect() throws SourceTerminationException;

    public void destroy() {
    }

    public class SourceTerminationException
    extends RuntimeException {
    }
}

