/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.io;

import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.data.InvalidSourceException;
import ch.bruker.jac.servicegui.data.io.SftpJumpHostSource;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.data.io.SourceProperties;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SftpSource
extends Source {
    private final String host;
    private final int sshPort;
    private final int webPort;
    private Session session;
    ReentrantLock lock = new ReentrantLock(true);
    IOException lockNotReleased;
    ThreadLocal<InputStream> stream = new ThreadLocal();
    ThreadLocal<ChannelSftp> channel = new ThreadLocal<ChannelSftp>(){

        @Override
        public ChannelSftp get() {
            if (super.get() == null || !((ChannelSftp)super.get()).isConnected()) {
                try {
                    if (SftpSource.this.session == null || !SftpSource.this.session.isConnected()) {
                        SftpSource.this.session = new JSch().getSession(SftpSource.this.systemProperties.u, SftpSource.this.host, SftpSource.this.sshPort);
                        SftpSource.this.session.setPassword(SftpSource.this.systemProperties.p);
                        SftpSource.this.session.setConfig("StrictHostKeyChecking", "no");
                        SftpSource.this.session.connect(0);
                        SftpSource.this.session.setServerAliveInterval(1000);
                    }
                    final ChannelSftp sftp = (ChannelSftp)SftpSource.this.session.openChannel("sftp");
                    sftp.connect(0);
                    this.set(sftp);
                    Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            SGUtils.err("SFTP-consuming thread ended: " + e.getMessage(), new Object[0]);
                            e.printStackTrace();
                            sftp.disconnect();
                        }
                    });
                }
                catch (JSchException e) {
                    if (SftpSource.this.session != null) {
                        SftpSource.this.session.disconnect();
                    }
                    SGUtils.err("Cannot connect channel: %s\n&s", e.getCause(), e.getMessage());
                    throw new RuntimeException("Cannot connect channel (" + e.getMessage() + ").");
                }
            }
            return (ChannelSftp)super.get();
        }
    };

    SftpSource(SourceProperties systemProperties, String host, int webPort, ApiTalker api, Jac origin) throws IOException {
        super(systemProperties, api, origin, "sftp");
        this.host = host;
        this.webPort = webPort;
        int n = this.sshPort = webPort >= 20000 ? webPort + 20 : 22;
        if (!this.current.ls().contains("time_refs.bin")) {
            throw new InvalidSourceException("No time references found");
        }
    }

    public static Source create(SourceProperties sourceProperties, String host, int webPort, String webProxyPath, String localAddress) throws IOException {
        ApiTalker api = null;
        Jac instance = null;
        if (sourceProperties.isJac()) {
            api = new ApiTalker(host, webPort, webProxyPath);
            instance = Jac.fromBis(api.getBis());
        } else {
            instance = sourceProperties.getInstance();
        }
        if (webProxyPath.isEmpty() && localAddress.isEmpty()) {
            return new SftpSource(sourceProperties, host, webPort, api, instance);
        }
        return new SftpJumpHostSource(sourceProperties, host, webPort, localAddress, webProxyPath, api, instance);
    }

    public String toString() {
        return this.origin + " - " + this.host + ":" + this.webPort;
    }

    @Override
    InputStream stream(String path) throws IOException {
        if (path.endsWith("Current.bin")) {
            try {
                if (!this.lock.tryLock(10L, TimeUnit.SECONDS)) {
                    throw this.lockNotReleased;
                }
                this.lockNotReleased = new IOException("Current data lock was not released, lock held by: " + Thread.currentThread().getName());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            InputStream in;
            if (this.stream.get() != null) {
                try {
                    this.stream.get().close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if ((in = this.channel.get().get(path)) == null) {
                throw new IOException("The SFTP-Channel returned an invalid null-stream");
            }
            this.stream.set(in);
            return in;
        }
        catch (SftpException e) {
            SGUtils.err("Could not open SFTP-Stream", new Object[0]);
            throw new IOException("Could not open sftp stream: " + path);
        }
    }

    public List<String> ls(String path) {
        LinkedList<String> filenames = new LinkedList<String>();
        try {
            for (ChannelSftp.LsEntry file : this.channel.get().ls(path)) {
                filenames.add(file.getFilename());
            }
        }
        catch (SftpException e) {
            return Collections.emptyList();
        }
        return filenames;
    }

    @Override
    boolean isDirectory(String path) {
        try {
            return this.channel.get().stat(path).isDir();
        }
        catch (SftpException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    long getFileSize(String filename) throws IOException {
        try {
            ChannelSftp channelSftp = this.channel.get();
            SftpATTRS stat = channelSftp.stat(filename);
            return stat.getSize();
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    @Override
    public boolean reconnect() {
        ChannelSftp channelSftp;
        this.destroy();
        this.channel.set(null);
        try {
            channelSftp = this.channel.get();
        }
        catch (RuntimeException ignore) {
            return false;
        }
        if (channelSftp == null) {
            return false;
        }
        try {
            this.api.connect();
            this.api.resetBlacklist();
            if (!this.origin.equals(Jac.fromBis(this.api.getBis()))) {
                this.channel.remove();
                SGUtils.log("Different BIS on reconnected system. Closing connection and entering standalone mode.", new Object[0]);
                throw new Source.SourceTerminationException(this);
            }
        }
        catch (ApiTalker.RemoteException e) {
            return false;
        }
        return true;
    }

    @Override
    public void release() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }
}

