/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.io;

import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.data.InvalidSourceException;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.data.io.SourceProperties;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SftpJumpHostSource
extends Source {
    private final String host;
    private final int sshPort;
    private final int webPort;
    private int assinged_port;
    private final String localAddress;
    private final String webProxyPath;
    private Session session;
    private Session session2;
    ReentrantLock lock = new ReentrantLock(true);
    IOException lockNotReleased;
    ThreadLocal<InputStream> stream = new ThreadLocal();
    ThreadLocal<ChannelSftp> channel = new ThreadLocal<ChannelSftp>(){

        @Override
        public ChannelSftp get() {
            if (!(SftpJumpHostSource.this.session != null && SftpJumpHostSource.this.session.isConnected() && SftpJumpHostSource.this.session2 != null && SftpJumpHostSource.this.session2.isConnected() && super.get() != null && ((ChannelSftp)super.get()).isConnected())) {
                JSch jsch = new JSch();
                try {
                    if (SftpJumpHostSource.this.session == null || !SftpJumpHostSource.this.session.isConnected()) {
                        SftpJumpHostSource.this.session = jsch.getSession("bruker", SftpJumpHostSource.this.host, SftpJumpHostSource.this.sshPort);
                        SftpJumpHostSource.this.session.setPassword("bruker");
                        SftpJumpHostSource.this.session.setConfig("StrictHostKeyChecking", "no");
                        SftpJumpHostSource.this.session.connect(0);
                        SftpJumpHostSource.this.session.setServerAliveInterval(1000);
                        SftpJumpHostSource.this.assinged_port = SftpJumpHostSource.this.session.setPortForwardingL(0, SftpJumpHostSource.this.localAddress, 22);
                        SGUtils.log("SFTP port forwarding: localhost:" + SftpJumpHostSource.this.assinged_port + " -> " + SftpJumpHostSource.this.host + ":" + 22, new Object[0]);
                        if (SftpJumpHostSource.this.session2 != null) {
                            SftpJumpHostSource.this.session2.disconnect();
                            SftpJumpHostSource.this.session2 = null;
                        }
                    }
                    if (SftpJumpHostSource.this.session2 == null || !SftpJumpHostSource.this.session2.isConnected()) {
                        SftpJumpHostSource.this.session2 = jsch.getSession("bruker", "127.0.0.1", SftpJumpHostSource.this.assinged_port);
                        SftpJumpHostSource.this.session2.setHostKeyAlias(SftpJumpHostSource.this.localAddress);
                        SftpJumpHostSource.this.session2.setPassword("bruker");
                        SftpJumpHostSource.this.session2.setConfig("StrictHostKeyChecking", "no");
                        SftpJumpHostSource.this.session2.connect(0);
                        SftpJumpHostSource.this.session2.setServerAliveInterval(1000);
                        SGUtils.log("SFTP port forwarding: localhost:" + SftpJumpHostSource.this.assinged_port + " -> " + SftpJumpHostSource.this.host + ":" + 22 + " -> " + SftpJumpHostSource.this.localAddress + ":" + 22, new Object[0]);
                    }
                    final ChannelSftp sftp = (ChannelSftp)SftpJumpHostSource.this.session2.openChannel("sftp");
                    sftp.connect(0);
                    this.set(sftp);
                    Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            SGUtils.err("SFTP-consuming thread ended: " + e.getMessage(), new Object[0]);
                            e.printStackTrace();
                            sftp.disconnect();
                        }
                    });
                }
                catch (JSchException e) {
                    if (SftpJumpHostSource.this.session2 != null) {
                        SftpJumpHostSource.this.session2.disconnect();
                    }
                    if (SftpJumpHostSource.this.session != null) {
                        SftpJumpHostSource.this.session.disconnect();
                    }
                    SGUtils.err("Cannot connect channel: %s\n&s", e.getCause(), e.getMessage());
                    throw new RuntimeException("Cannot connect channel (" + e.getMessage() + ").");
                }
            }
            return (ChannelSftp)super.get();
        }
    };

    SftpJumpHostSource(SourceProperties sourceProperties, String host, int webPort, String localAddress, String webProxyPath, ApiTalker api, Jac origin) throws IOException {
        super(sourceProperties, api, origin, "sftp");
        this.host = host;
        this.webPort = webPort;
        this.localAddress = localAddress;
        this.webProxyPath = webProxyPath;
        int n = this.sshPort = webPort >= 20000 ? webPort + 20 : 22;
        if (!this.current.ls().contains("time_refs.bin")) {
            throw new InvalidSourceException("No time references found");
        }
    }

    public String toString() {
        return this.origin + " - " + this.host + ":" + this.webPort + this.webProxyPath + " (" + this.localAddress + ")";
    }

    @Override
    InputStream stream(String path) throws IOException {
        if (path.endsWith("Current.bin")) {
            try {
                if (!this.lock.tryLock(10L, TimeUnit.SECONDS)) {
                    throw this.lockNotReleased;
                }
                this.lockNotReleased = new IOException("Current data lock was not released, lock held by: " + Thread.currentThread().getName());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            InputStream in;
            if (this.stream.get() != null) {
                try {
                    this.stream.get().close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if ((in = this.channel.get().get(path)) == null) {
                throw new IOException("The SFTP-Channel returned an invalid null-stream");
            }
            this.stream.set(in);
            return in;
        }
        catch (SftpException e) {
            SGUtils.err("Could not open SFTP-Stream", new Object[0]);
            throw new IOException("Could not open sftp stream: " + path);
        }
    }

    public List<String> ls(String path) {
        LinkedList<String> filenames = new LinkedList<String>();
        try {
            for (ChannelSftp.LsEntry file : this.channel.get().ls(path)) {
                filenames.add(file.getFilename());
            }
        }
        catch (SftpException e) {
            return Collections.emptyList();
        }
        return filenames;
    }

    @Override
    boolean isDirectory(String path) {
        try {
            return this.channel.get().stat(path).isDir();
        }
        catch (SftpException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    long getFileSize(String filename) throws IOException {
        try {
            ChannelSftp channelSftp = this.channel.get();
            SftpATTRS stat = channelSftp.stat(filename);
            return stat.getSize();
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.session2 != null) {
            this.session2.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    @Override
    public boolean reconnect() {
        ChannelSftp channelSftp;
        this.destroy();
        this.channel.set(null);
        try {
            channelSftp = this.channel.get();
        }
        catch (RuntimeException ignore) {
            return false;
        }
        if (channelSftp == null) {
            return false;
        }
        try {
            this.api.connect();
            this.api.resetBlacklist();
            if (!this.origin.equals(Jac.fromBis(this.api.getBis()))) {
                this.channel.remove();
                SGUtils.log("Different BIS on reconnected system. Closing connection and entering standalone mode.", new Object[0]);
                throw new Source.SourceTerminationException(this);
            }
        }
        catch (ApiTalker.RemoteException e) {
            return false;
        }
        return true;
    }

    @Override
    public void release() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }
}

