/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.io;

import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.InvalidSourceException;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.data.io.SourceProperties;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.joda.time.format.ISODateTimeFormat;

public class FileSource
extends Source {
    private final ZipFile zip;
    private final String binName;

    public static FileSource create(File logFile) throws IOException {
        try {
            ZipFile zip = new ZipFile(logFile);
            String anyFile = zip.entries().nextElement().getName();
            String root = anyFile.substring(0, anyFile.indexOf(47));
            return new FileSource(zip, logFile.getName(), root);
        }
        catch (ZipException e) {
            throw new InvalidSourceException("File does not contain Log data.");
        }
    }

    private FileSource(ZipFile zip, String binName, String root) throws IOException {
        super(SourceProperties.LOG_ZIP_FILE(root), null, FileSource.jacFromBinNameOrBinContent(binName, zip), FileSource.getTypeLabel(new File(zip.getName())));
        this.binName = binName;
        this.zip = zip;
        if (this.archives.ls().isEmpty()) {
            throw new InvalidSourceException("No archives found");
        }
        if (!this.current.ls().contains("time_refs.bin")) {
            throw new InvalidSourceException("No time references found");
        }
        if (!this.sysMsg.ls().contains("SystemMessages.log")) {
            SGUtils.log("Log does not include system messages.", new Object[0]);
        }
    }

    private static Jac jacFromBinNameOrBinContent(String binName, ZipFile binContent) {
        try {
            return Jac.fromBinName(binName);
        }
        catch (IllegalArgumentException ignore) {
            SGUtils.log("Could not guess system type from filename. Reading from zipped headers\u2026", new Object[0]);
            try {
                return Jac.fromBinContent(binContent);
            }
            catch (IOException e) {
                throw new InvalidSourceException("Could not determine system type");
            }
        }
    }

    public String toString() {
        return this.origin + " - " + this.zip.getName();
    }

    protected static String getTypeLabel(File file) {
        long millis = file.lastModified();
        return "log_" + ISODateTimeFormat.basicDateTimeNoMillis().print(millis);
    }

    @Override
    InputStream stream(String path) throws IOException {
        ZipEntry entry = this.zip.getEntry(path);
        if (entry == null) {
            throw new RuntimeException("No file '" + path + "' in zip-archives.");
        }
        return this.zip.getInputStream(entry);
    }

    public List<String> ls(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry node = enumeration.nextElement();
            String name = node.getName();
            if (!name.startsWith(path)) continue;
            int endIndex = (name = name.substring(path.length() + 1)).indexOf(47);
            if (endIndex <= 0) {
                endIndex = name.length();
            }
            list.add(name.substring(0, endIndex));
        }
        return ImmutableList.copyOf(list);
    }

    @Override
    public boolean isDirectory(String path) {
        ZipEntry entry = this.zip.getEntry(path);
        if (entry == null) {
            throw new RuntimeException("No directory '" + path + "' in zip-archives.");
        }
        return entry.isDirectory();
    }

    @Override
    public long getFileSize(String filename) {
        ZipEntry entry = this.zip.getEntry(filename);
        if (entry == null) {
            throw new RuntimeException("No directory '" + filename + "' in zip-archives.");
        }
        long size = entry.getSize();
        if (size == -1L) {
            throw new UnsupportedOperationException();
        }
        return size;
    }

    @Override
    public boolean reconnect() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        CRC32 checksum = new CRC32();
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(this.zip.getName()));
            int read = 0;
            byte[] buffer = new byte[1024];
            while ((read = bis.read(buffer)) != -1) {
                checksum.update(buffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (int)checksum.getValue();
    }

    @Override
    public void release() {
    }
}

