/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.io;

import ch.bruker.jac.servicegui.data.io.Source;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Dir {
    private Source source;
    final String prefix;

    Dir(String path) {
        this.prefix = path;
    }

    Dir bind(Source source) {
        this.source = source;
        return this;
    }

    public InputStream open(String filename) throws IOException {
        return this.source.stream(Dir.join(this.prefix, filename));
    }

    public InputStream openZip(String zipFile, String filename) throws IOException {
        ZipEntry file;
        ZipInputStream fileStream = new ZipInputStream(this.open(zipFile));
        do {
            if ((file = fileStream.getNextEntry()) != null) continue;
            throw new FileNotFoundException("No file '" + filename + "' in zip-archives.");
        } while (!file.getName().equals(filename));
        return fileStream;
    }

    public Collection<String> ls() {
        return this.source.ls(this.prefix);
    }

    public long getSize(String path) throws IOException {
        return this.source.getFileSize(Dir.join(this.prefix, path));
    }

    public Collection<String> ls(String subdir) {
        return this.source.ls(Dir.join(this.prefix, subdir));
    }

    public boolean isDirectory(String path) {
        return this.source.isDirectory(Dir.join(this.prefix, path));
    }

    public void invalidateAll() {
    }

    public void invalidate(String file) {
    }

    private static String join(String ... pathSegments) {
        StringBuilder path = new StringBuilder();
        for (String segment : pathSegments) {
            path.append(segment);
            if (segment.endsWith("/")) continue;
            path.append("/");
        }
        return path.substring(0, path.length() - 1);
    }

    public void release() {
        this.source.release();
    }
}

