/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.io;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.io.Dir;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.util.FileDumpInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class CachingDir
extends Dir {
    private File cacheDir;
    private Set<File> blacklist = new HashSet<File>();

    CachingDir(String path) {
        super(path);
    }

    @Override
    Dir bind(Source source) {
        this.cacheDir = source.localCache;
        if (!this.cacheDir.isDirectory()) {
            SGUtils.log("Invalid cache directory! Fall back to non-caching source.", new Object[0]);
            return new Dir(this.prefix).bind(source);
        }
        return super.bind(source);
    }

    @Override
    public InputStream open(String filename) throws IOException {
        File cached = new File(this.cacheDir + "/" + filename);
        if (this.blacklist.contains(cached) && cached.delete()) {
            this.blacklist.remove(cached);
        }
        if (cached.exists() && !this.blacklist.contains(cached)) {
            try {
                return new FileInputStream(cached);
            }
            catch (FileNotFoundException ignore) {
                // empty catch block
            }
        }
        InputStream remote = null;
        try {
            remote = super.open(filename);
            return new FileDumpInputStream(remote, cached);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void invalidate(String filename) {
        File file = new File(this.cacheDir + "/" + filename);
        if (!file.delete()) {
            this.blacklist.add(file);
        }
    }

    @Override
    public void invalidateAll() {
        for (String filename : this.ls()) {
            this.invalidate(filename);
        }
    }
}

