/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.data.ContinuousSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import com.google.common.base.Objects;

public abstract class NumericDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    public static final String IS_FLOAT_TAG = "floating_point";
    public final double min;
    public final double max;
    public final String format;
    public final double guiMin;
    public final double guiMax;

    public NumericDescriptor(FailFastHashMap<String, String> xmlTags, byte byteSize) throws IllegalArgumentException {
        super(xmlTags, byteSize);
        double tmp;
        this.format = xmlTags.get("format");
        double min = Double.parseDouble(xmlTags.get("min_value"));
        double max = Double.parseDouble(xmlTags.get("max_value"));
        double guiMin = Double.parseDouble(xmlTags.get("gui_default_min"));
        double guiMax = Double.parseDouble(xmlTags.get("gui_default_max"));
        if (min > max) {
            SGUtils.log("Warning: Parameter '%s' has invalid range limits. Swap and continue\u2026", this.name);
            tmp = max;
            max = min;
            min = tmp;
        }
        this.min = min;
        this.max = max;
        if (guiMin > guiMax) {
            SGUtils.log("Warning: Parameter '%s' has invalid gui-range limits. Swap and continue\u2026", this.name);
            tmp = guiMax;
            guiMax = guiMin;
            guiMin = tmp;
        }
        this.guiMin = guiMin;
        this.guiMax = guiMax;
    }

    @Override
    public String getLabel(Sample s) {
        ContinuousSample sample = (ContinuousSample)s;
        String ret = this.formatWithUnit(sample.avg);
        return ret;
    }

    @Override
    public String getRepr(Sample s) {
        if (!s.isValid()) {
            return "";
        }
        ContinuousSample sample = (ContinuousSample)s;
        return this.format(sample.avg);
    }

    public abstract String format(double var1);

    public String formatWithUnit(double val) {
        return this.format(val).trim() + " " + this.unit;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.unit, this.format, this.guiMin, this.guiMax);
    }
}

