/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.ContinuousSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.ByteContainer;
import ch.bruker.jac.servicegui.data.cache.Container;
import java.util.Arrays;

public abstract class NumContainer
extends ByteContainer {
    private static final long serialVersionUID = 1L;
    byte[] mins;
    byte[] maxs;
    final boolean isRaw;

    @Override
    int makeRoomFor(int n) {
        if (!this.isRaw) {
            throw new IllegalStateException("DS-Containers should not grow.");
        }
        int additionalSize = super.makeRoomFor(n);
        this.mins = this.vals;
        this.maxs = this.vals;
        return additionalSize;
    }

    NumContainer(int bitSize, int initialSize, boolean isRaw) {
        super(bitSize, initialSize);
        this.isRaw = isRaw;
        if (isRaw) {
            this.mins = this.vals;
            this.maxs = this.vals;
        } else {
            this.mins = new byte[initialSize * this.byteSize];
            this.maxs = new byte[initialSize * this.byteSize];
        }
    }

    abstract double getDouble(byte[] var1, int var2);

    abstract void putDouble(byte[] var1, int var2, double var3);

    @Override
    public double val(int index) {
        return this.getDouble(this.vals, index);
    }

    public double min(int index) {
        return this.getDouble(this.mins, index);
    }

    public double max(int index) {
        return this.getDouble(this.maxs, index);
    }

    @Override
    public int fit() {
        if (this.position == this.byteSize * this.vals.length) {
            return this.vals.length / this.byteSize;
        }
        this.vals = Arrays.copyOf(this.vals, this.byteSize * this.position);
        if (this.isRaw) {
            this.maxs = this.vals;
            this.mins = this.vals;
        } else {
            this.maxs = Arrays.copyOf(this.maxs, this.byteSize * this.position);
            this.mins = Arrays.copyOf(this.mins, this.byteSize * this.position);
        }
        return this.vals.length / this.byteSize;
    }

    @Override
    public void appendVoid(int size) {
        this.makeRoomFor(this.position + size);
        for (int i = 0; i < size; ++i) {
            ++this.position;
            this.putDouble(this.vals, this.position, Double.NaN);
            this.putDouble(this.maxs, this.position, Double.NaN);
            this.putDouble(this.mins, this.position, Double.NaN);
        }
    }

    @Override
    public void appendDownsampled(Container rawSource, int offset, int factor) {
        double max;
        double min;
        double sum;
        if (rawSource.bitSize == 0) {
            this.position += (rawSource.position + offset) / factor;
            return;
        }
        NumContainer source = (NumContainer)rawSource;
        if (this.isRaw) {
            throw new IllegalStateException();
        }
        int n = 0;
        if (offset > 0 && offset < factor) {
            n = factor;
            sum = (double)n * this.val(this.position);
            min = this.min(this.position);
            max = this.max(this.position);
        } else {
            sum = 0.0;
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
        }
        if (offset >= factor) {
            int nulls = offset / factor;
            this.position += nulls;
            offset += -nulls;
        }
        int shift = Math.max(offset, 0);
        for (int idx = Math.max(-offset, 0); idx < source.position; ++idx) {
            if (this.getCapacity() <= this.position) {
                return;
            }
            if (!Double.isNaN(source.val(idx))) {
                sum += source.val(idx);
                ++n;
            }
            min = Math.min(min, source.min(idx));
            max = Math.max(max, source.max(idx));
            int phase = (idx + 1 + shift) % factor;
            if (phase != 0) continue;
            this.putDouble(this.vals, this.position, 1.0 * sum / (double)n);
            this.putDouble(this.mins, this.position, min);
            this.putDouble(this.maxs, this.position, max);
            ++this.position;
            n = 0;
            sum = 0.0;
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
        }
        if (this.position < this.getCapacity()) {
            this.putDouble(this.vals, this.position, 1.0 * sum / (double)n);
            this.putDouble(this.mins, this.position, min);
            this.putDouble(this.maxs, this.position, max);
        }
    }

    void putVal(double val) {
        if (!this.isRaw) {
            throw new IllegalStateException();
        }
        this.putDouble(this.vals, this.position, val);
        ++this.position;
    }

    @Override
    public Sample getSample(int startIdx, int len) {
        NumContainer.checkStartIdx(startIdx);
        if (len == 0) {
            return Sample.VOID;
        }
        double sum = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int skipped = 0;
        for (int i = 0; i < len; ++i) {
            int idx = startIdx + i;
            if (idx >= this.position) {
                skipped += len - i;
                break;
            }
            if (Double.isNaN(this.val(idx)) || Double.isNaN(this.min(idx)) || Double.isNaN(this.max(idx))) {
                ++skipped;
                continue;
            }
            sum += this.val(idx);
            min = Math.min(min, this.min(idx));
            max = Math.max(max, this.max(idx));
        }
        if ((len -= skipped) == 0) {
            return Sample.ABSENT;
        }
        return new ContinuousSample(sum / (double)len, min, max, len);
    }
}

