/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Container;
import java.io.DataInputStream;

public class NullContainer
extends Container {
    private static final long serialVersionUID = 1L;

    public NullContainer(int size) {
        this.position = size;
        this.bitSize = 0;
        this.byteSize = 0;
    }

    @Override
    public int appendStream(DataInputStream in, boolean isAbsolute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendDownsampled(Container source, int offset, int factor) {
        this.appendVoid((source.getLength() + offset) / factor);
    }

    @Override
    public void appendVoid(int gapSize) {
        this.position += gapSize;
    }

    @Override
    public double val(int index) {
        return Double.NaN;
    }

    @Override
    public int fit() {
        return this.position;
    }

    @Override
    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    public Sample getSample(int startIdx, int len) {
        NullContainer.checkStartIdx(startIdx);
        return Sample.ABSENT;
    }
}

