/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.DoubleFloatContainer;
import ch.bruker.jac.servicegui.data.cache.NumericDescriptor;
import ch.bruker.jac.servicegui.data.cache.SingleFloatContainer;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;

public class FloatDescriptor
extends NumericDescriptor {
    private static final long serialVersionUID = 1L;
    private final boolean doublePrecision;

    public FloatDescriptor(FailFastHashMap<String, String> xmlTags) throws IllegalArgumentException {
        super(xmlTags, (byte)(xmlTags.get("floating_point").equals("double") ? 8 : 4));
        this.doublePrecision = xmlTags.get("floating_point").equals("double");
        if (this.min <= 0.0) {
            SGUtils.log("Warning: Parameter '%s' has an invalid lower bound of %f.", this.name, this.min);
        }
        if (this.guiMin <= 0.0) {
            SGUtils.log("Warning: Parameter '%s' has an invalid lower bound (GUI) of %f.", this.name, this.guiMin);
        }
    }

    @Override
    public String format(double val) {
        if (Double.isNaN(val)) {
            return " - ";
        }
        try {
            return String.format("%" + this.format, val);
        }
        catch (UnknownFormatConversionException ignore) {
        }
        catch (IllegalFormatException ignore) {
            // empty catch block
        }
        try {
            return String.format("%" + this.format + "f", val);
        }
        catch (UnknownFormatConversionException ignore) {
        }
        catch (IllegalFormatException illegalFormatException) {
            // empty catch block
        }
        return String.valueOf(val);
    }

    @Override
    public Container createContainer(int rows, boolean isRaw) {
        if (this.doublePrecision) {
            return new DoubleFloatContainer(rows, isRaw);
        }
        return new SingleFloatContainer(rows, isRaw);
    }

    @Override
    public Plot createPlot(PanelState state) {
        GraphPlot logarithmicPlot = new GraphPlot(this, state);
        state.app.updates.register(logarithmicPlot);
        return logarithmicPlot;
    }
}

