/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.FixedContainer;
import ch.bruker.jac.servicegui.data.cache.NumericDescriptor;
import ch.bruker.jac.servicegui.graphical.GraphPlot;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import com.google.common.base.Objects;
import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;
import java.util.regex.Pattern;

public class FixedDescriptor
extends NumericDescriptor {
    private static final long serialVersionUID = 2L;
    private final byte bitLength;
    public final float specifiedResolution;
    private final float stepSize;
    private static final Pattern FORMAT_STRING_HEURISTIC = Pattern.compile("\\D$");

    public FixedDescriptor(FailFastHashMap<String, String> xmlTags, String version) {
        super(xmlTags, Byte.parseByte(xmlTags.get("byte_size")));
        float versionNumber = 0.0f;
        try {
            versionNumber = Float.parseFloat(version);
        }
        catch (NumberFormatException ignore) {
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        this.bitLength = xmlTags.containsKey("bit_resolution") ? Byte.parseByte(xmlTags.get("bit_resolution")) : (byte)(this.byteSize * 8);
        this.specifiedResolution = Float.parseFloat(xmlTags.get("step_size"));
        if ((double)versionNumber < 1.2) {
            this.stepSize = (float)((this.max - this.min) / (double)((1L << this.bitLength) - 3L));
            return;
        }
        this.stepSize = (float)((this.max - this.min) / (double)((1L << this.bitLength) - 4L));
    }

    @Override
    public Container createContainer(int rows, boolean isRaw) {
        return new FixedContainer(this.bitLength, rows, isRaw, this.min, this.stepSize);
    }

    @Override
    public String format(double val) {
        if (Double.isNaN(val)) {
            return " - ";
        }
        if (FORMAT_STRING_HEURISTIC.matcher(this.format).matches()) {
            try {
                return String.format("%" + this.format, val) + " ";
            }
            catch (UnknownFormatConversionException ignore) {
            }
            catch (IllegalFormatException ignore) {
                // empty catch block
            }
        }
        boolean integerMode = this.specifiedResolution % 1.0f == 0.0f && !this.format.contains(".");
        try {
            if (integerMode) {
                return String.format("%" + this.format + "d ", Math.round(val));
            }
            return String.format("%" + this.format + "f ", val);
        }
        catch (UnknownFormatConversionException ignore) {
        }
        catch (IllegalFormatException ignore) {
            // empty catch block
        }
        return String.valueOf(val);
    }

    @Override
    public Plot createPlot(PanelState state) {
        GraphPlot graphPlot = new GraphPlot(this, state);
        state.app.updates.register(graphPlot);
        return graphPlot;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.min, this.max, this.bitLength, Float.valueOf(this.specifiedResolution), Float.valueOf(this.stepSize));
    }

    public static FixedDescriptor mock(String id, String name, int order, float min, float max) {
        FailFastHashMap<String, String> map = new FailFastHashMap<String, String>();
        map.put("id", id);
        map.put("name", name);
        map.put("position_in_byte_sequence", "-1");
        map.put("gui_group", "Meta");
        map.put("gui_order", String.valueOf(order));
        map.put("is_default_selected_on_gui", "true");
        map.put("is_logged_event_based", "false");
        map.put("byte_size", "1");
        map.put("bit_resolution", "8");
        map.put("step_size", "1");
        map.put("min_value", String.valueOf(min));
        map.put("max_value", String.valueOf(max));
        map.put("gui_default_min", String.valueOf(min));
        map.put("gui_default_max", String.valueOf(max));
        map.put("format", "");
        return new FixedDescriptor(map, null);
    }
}

