/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.cache.NumContainer;

public class FixedContainer
extends NumContainer {
    private static final long serialVersionUID = 1L;
    private static final int NOT_A_NUMBER = 0;
    private static final int NEGATIVE_INFINITY = 1;
    private final double min;
    private final double stepSize;

    FixedContainer(int bitSize, int initialSize, boolean isRaw, double min, double stepSize) {
        super(bitSize, initialSize, isRaw);
        this.min = min;
        this.stepSize = stepSize;
    }

    @Override
    double getDouble(byte[] bytes, int index) {
        long val = super.getBytes(bytes, index);
        if (val == 0L) {
            return Double.NaN;
        }
        if (val == 1L) {
            return Double.NEGATIVE_INFINITY;
        }
        if (val == (1L << this.bitSize) - 1L) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)(val - 2L) * this.stepSize + this.min;
    }

    @Override
    void putDouble(byte[] bytes, int index, double dVal) {
        long val = 0L;
        if (Double.isNaN(dVal)) {
            val = 0L;
        } else if (dVal <= -1.7976931348623157E308) {
            val = 1L;
        } else if (dVal >= Double.MAX_VALUE) {
            val = (1L << this.bitSize) - 1L;
        } else {
            val = Math.round((dVal - this.min) / this.stepSize);
            val += 2L;
        }
        super.putBytes(bytes, index, val);
    }
}

