/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.data.DiscreteSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.cache.EnumContainer;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.StatePlot;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;

public class EnumDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private final HashMap<Integer, String> labels = new HashMap();
    public final boolean signedStates;

    public EnumDescriptor(FailFastHashMap<String, String> xmlTags) {
        super(xmlTags, (byte)1);
        int minKey = Integer.MAX_VALUE;
        int maxKey = Integer.MIN_VALUE;
        for (String tag : xmlTags.keySet()) {
            if (!tag.startsWith("entry")) continue;
            String label = xmlTags.get(tag);
            String[] split = tag.split("#");
            if (split.length != 2) {
                throw new RuntimeException("Invalid entry tag: Bad length");
            }
            int state = Integer.parseInt(split[1]);
            minKey = Math.min(state, minKey);
            maxKey = Math.max(state, maxKey);
            this.labels.put(state, label);
        }
        boolean bl = this.signedStates = minKey < 0;
        if (maxKey > 255 || this.signedStates && maxKey > 127) {
            SGUtils.err("Invalid state range in parameter %s: must not exceed the range of 8 bit, either signed or unsigned.", this.id);
        }
        if (this.signedStates && this.labels.containsKey(-128)) {
            SGUtils.err("%x is a protected state an should not be used for signed enums.", (byte)-128);
        }
        if (this.signedStates && this.labels.containsKey(-128) || !this.signedStates && this.labels.containsKey(-1)) {
            SGUtils.err("%x is a protected state an should not be used for unsigned enums.", (byte)-1);
        }
    }

    @Override
    public Container createContainer(int rows, boolean isRaw) {
        return new EnumContainer(rows, this.signedStates);
    }

    @Override
    public String getLabel(Sample s) {
        DiscreteSample sample = (DiscreteSample)s;
        String label = this.labels.get(sample.state);
        if (label == null) {
            return "";
        }
        return label;
    }

    @Override
    public Plot createPlot(PanelState state) {
        StatePlot statePlot = new StatePlot(this, state);
        state.app.updates.register(statePlot);
        return statePlot;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.labels);
    }

    public static EnumDescriptor mock(String id, String name, int order) {
        FailFastHashMap<String, String> map = new FailFastHashMap<String, String>();
        map.put("id", id);
        map.put("name", name);
        map.put("position_in_byte_sequence", "-1");
        map.put("gui_group", "Meta");
        map.put("gui_order", String.valueOf(order));
        map.put("is_default_selected_on_gui", "true");
        map.put("is_logged_event_based", "false");
        return new EnumDescriptor(map);
    }

    public ImmutableMap<Integer, String> getLabels() {
        return ImmutableMap.copyOf(this.labels);
    }
}

