/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.DiscreteSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.ByteContainer;
import ch.bruker.jac.servicegui.data.cache.Container;
import java.util.BitSet;

public class EnumContainer
extends ByteContainer {
    private static final long serialVersionUID = 1L;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    public static final byte UNDEFINED_SIGNED = -128;
    public static final byte UNDEFINED_UNSIGNED = -1;
    private final boolean signedStates;
    private final byte undefinedValue;
    private BitSet glitch;

    EnumContainer(int initialSize, boolean signedStates) {
        super(8, initialSize);
        this.signedStates = signedStates;
        this.undefinedValue = (byte)(signedStates ? -128 : -1);
        this.glitch = new BitSet(initialSize);
    }

    @Override
    public void appendDownsampled(Container source, int offset, int factor) {
        int state;
        boolean multiple;
        if (offset >= 0 && offset < factor) {
            multiple = this.glitch.get(this.position);
            state = (int)this.getBytes(this.vals, this.position);
        } else {
            multiple = false;
            state = (int)source.val(0);
        }
        if (offset > 0) {
            int nulls = offset / factor;
            this.appendVoid(nulls);
            offset += -nulls;
        }
        int shift = Math.max(offset, 0);
        for (int idx = Math.max(-offset, 0); idx < source.position; ++idx) {
            int phase;
            if (this.getCapacity() <= this.position) {
                return;
            }
            if ((double)state != source.val(idx)) {
                multiple = true;
            }
            if ((phase = (idx + 1 + shift) % factor) != 0) continue;
            this.putBytes(this.vals, this.position, state);
            this.glitch.set(this.position, multiple);
            ++this.position;
            multiple = false;
            state = (int)source.val(idx);
        }
        if (this.position < this.getCapacity()) {
            this.putBytes(this.vals, this.position, state);
            this.glitch.set(this.position, multiple);
        }
    }

    @Override
    public void appendVoid(int size) {
        this.makeRoomFor(this.position + size);
        for (int i = 0; i < size; ++i) {
            ++this.position;
            this.vals[this.position] = this.undefinedValue;
        }
    }

    @Override
    public double val(int index) {
        if (this.glitch.get(index)) {
            return Double.NaN;
        }
        return this.getBytes(this.vals, index);
    }

    @Override
    public Sample getSample(int startIdx, int len) {
        EnumContainer.checkStartIdx(startIdx);
        if (len == 0) {
            return Sample.VOID;
        }
        int transitions = 0;
        int state = (int)this.getBytes(this.vals, Math.min(Math.max(0, startIdx - 1), this.position - 1));
        int skipped = 0;
        for (int i = 0; i < len; ++i) {
            int idx = startIdx + i;
            if (idx >= this.position) {
                skipped += len - i;
                break;
            }
            byte state_ = (byte)this.getBytes(this.vals, idx);
            if (state_ == this.undefinedValue) {
                ++skipped;
            }
            if (state_ != state) {
                ++transitions;
                state = (byte)this.getBytes(this.vals, idx);
            }
            if (!this.glitch.get(idx)) continue;
            transitions += 2;
        }
        if ((len -= skipped) == 0) {
            return Sample.ABSENT;
        }
        if (!this.signedStates && state < 0) {
            state += 256;
        }
        return new DiscreteSample(state, transitions > 1, len);
    }
}

