/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.cache.NumContainer;

public class DoubleFloatContainer
extends NumContainer {
    private static final long serialVersionUID = 1L;

    DoubleFloatContainer(int initialSize, boolean isRaw) {
        super(64, initialSize, isRaw);
        for (int idx = 0; idx < initialSize; ++idx) {
            this.putDouble(this.vals, idx, Double.NaN);
            if (isRaw) continue;
            this.putDouble(this.mins, idx, Double.NaN);
            this.putDouble(this.maxs, idx, Double.NaN);
        }
    }

    @Override
    int makeRoomFor(int n) {
        int additionalSize = super.makeRoomFor(n);
        if (additionalSize > 0) {
            for (int idx = this.vals.length / this.byteSize - additionalSize + 1; idx < this.vals.length / this.byteSize; ++idx) {
                this.putDouble(this.vals, idx, Double.NaN);
                if (this.isRaw) continue;
                this.putDouble(this.mins, idx, Double.NaN);
                this.putDouble(this.maxs, idx, Double.NaN);
            }
        }
        return additionalSize;
    }

    @Override
    double getDouble(byte[] bytes, int index) {
        return Double.longBitsToDouble(super.getBytes(bytes, index));
    }

    @Override
    void putDouble(byte[] bytes, int index, double dval) {
        super.putBytes(bytes, index, Double.doubleToLongBits(dval));
    }
}

