/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import com.google.common.base.Objects;
import java.awt.Color;
import java.io.Serializable;

public abstract class Descriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String id;
    public final String name;
    public final String unit;
    public final int offset;
    public final String guiGroupLabel;
    public final String guiGroupNr;
    public final short guiOrder;
    public final boolean defaultSelected;
    public final boolean eventLogged;
    public final byte byteSize;
    public final Color color;

    Descriptor(FailFastHashMap<String, String> xmlTags, byte byteSize) throws IllegalArgumentException {
        this.id = xmlTags.get("id");
        this.name = xmlTags.get("name");
        this.unit = xmlTags.containsKey("unit") ? xmlTags.get("unit") : "";
        this.offset = Integer.parseInt(xmlTags.get("position_in_byte_sequence"));
        this.guiGroupLabel = xmlTags.get("gui_group");
        this.guiGroupNr = xmlTags.containsKey("gui_group_nr") ? xmlTags.get("gui_group_nr") : "";
        this.guiOrder = Short.parseShort(xmlTags.get("gui_order"));
        this.defaultSelected = xmlTags.containsKey("is_default_selected_on_gui") ? xmlTags.get("is_default_selected_on_gui").equals("true") : false;
        this.eventLogged = xmlTags.containsKey("is_logged_event_based") ? xmlTags.get("is_logged_event_based").equals("true") : false;
        this.color = xmlTags.containsKey("gui_color") ? Color.decode("0x" + xmlTags.get("gui_color")) : null;
        this.byteSize = byteSize;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.offset, this.guiGroupLabel, this.guiOrder, this.defaultSelected, this.eventLogged, this.color);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.hashCode() == this.hashCode();
    }

    public abstract Container createContainer(int var1, boolean var2);

    public abstract String getLabel(Sample var1);

    public String getRepr(Sample s) {
        if (!s.isValid()) {
            return "";
        }
        return this.getLabel(s);
    }

    public abstract Plot createPlot(PanelState var1);
}

