/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.cache.Container;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

abstract class ByteContainer
extends Container {
    private static final long serialVersionUID = 1L;
    private final int padding;
    byte[] vals;

    ByteContainer(int bitSize, int initialSize) {
        int byteSize;
        this.byteSize = byteSize = (int)Math.ceil((double)bitSize / 8.0);
        this.bitSize = bitSize;
        this.padding = 8 * byteSize - bitSize;
        this.vals = new byte[byteSize * initialSize];
    }

    long getBytes(byte[] bytes, int index) {
        long val = 0L;
        for (int i = 0; i < this.byteSize; ++i) {
            val <<= 8;
            val |= (long)(0xFF & bytes[index * this.byteSize + i]);
        }
        return val;
    }

    void putBytes(byte[] bytes, int index, long val) {
        for (int i = this.byteSize - 1; i >= 0; --i) {
            bytes[this.byteSize * index + i] = (byte)(val & 0xFFL);
            val >>>= 8;
        }
    }

    @Override
    public int fit() {
        if (this.position != this.byteSize * this.vals.length) {
            this.vals = Arrays.copyOf(this.vals, this.byteSize * this.position);
        }
        return this.vals.length / this.byteSize;
    }

    @Override
    public int getWeight() {
        return this.vals.length * this.byteSize;
    }

    @Override
    public int getCapacity() {
        return this.vals.length / this.byteSize;
    }

    int makeRoomFor(int n) {
        if (this.vals.length <= this.byteSize * n) {
            int newSize = n * 2 * this.byteSize;
            this.vals = Arrays.copyOf(this.vals, newSize);
            return n;
        }
        return 0;
    }

    @Override
    public int appendStream(DataInputStream in, boolean isAbsolute) throws IOException {
        int i;
        int val = 0;
        for (i = 0; i < this.byteSize; ++i) {
            val <<= 8;
            val |= 0xFF & in.readByte();
        }
        val >>>= this.padding;
        this.makeRoomFor(this.position + 1);
        for (i = this.byteSize - 1; i >= 0; --i) {
            this.vals[this.byteSize * this.position + i] = (byte)(val & 0xFF);
            val >>>= 8;
            if (isAbsolute) continue;
            if (this.position == 0) {
                throw new IllegalArgumentException("First entry in container must be absolute!");
            }
            int n = this.byteSize * this.position + i;
            this.vals[n] = (byte)(this.vals[n] ^ this.vals[this.byteSize * (this.position - 1) + i]);
        }
        ++this.position;
        return this.byteSize;
    }
}

