/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.data.DiscreteSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.BitContainer;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.StatePlot;
import com.google.common.base.Objects;

public class BooleanDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private byte bitMask;
    public final String labelTrue;
    public final String labelFalse;

    public BooleanDescriptor(FailFastHashMap<String, String> xmlTags) {
        super(xmlTags, (byte)1);
        String labelTrue = null;
        String labelFalse = null;
        try {
            this.bitMask = Short.decode(xmlTags.get("bit_mask")).byteValue();
            labelFalse = xmlTags.get("entry_0");
            labelTrue = xmlTags.get("entry_1");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Incomplete header XML");
        }
        this.labelFalse = labelFalse;
        this.labelTrue = labelTrue;
    }

    @Override
    public Container createContainer(int size, boolean isRaw) {
        return new BitContainer(size, this.bitMask);
    }

    @Override
    public String getLabel(Sample s) {
        DiscreteSample sample = (DiscreteSample)s;
        if (sample.glitch) {
            return "<transitional>";
        }
        return sample.state == 0 ? this.labelFalse : this.labelTrue;
    }

    @Override
    public Plot createPlot(PanelState state) {
        StatePlot statePlot = new StatePlot(this, state);
        state.app.updates.register(statePlot);
        return statePlot;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.bitMask, this.labelTrue, this.labelFalse);
    }
}

