/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data.cache;

import ch.bruker.jac.servicegui.data.DiscreteSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Container;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.BitSet;

class BitContainer
extends Container {
    private static final long serialVersionUID = 1L;
    private final byte bitmask;
    private BitSet states;
    private BitSet glitch;

    BitContainer(int size, byte bitmask) {
        this.states = new BitSet(size);
        this.glitch = new BitSet(size);
        this.bitmask = bitmask;
        this.byteSize = 0;
        this.bitSize = 1;
    }

    @Override
    public double val(int index) {
        if (this.glitch.get(index)) {
            return Double.NaN;
        }
        return this.states.get(index) ? 1.0 : 0.0;
    }

    @Override
    public int fit() {
        return this.position;
    }

    @Override
    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getWeight() {
        return this.states.size() * 2 / 8;
    }

    @Override
    public int appendStream(DataInputStream in, boolean isAbsolute) throws IOException {
        boolean bit;
        in.mark(1);
        byte bits = in.readByte();
        in.reset();
        boolean bl = bit = (bits & this.bitmask) != 0;
        if (isAbsolute) {
            this.states.set(this.position, bit);
        } else {
            if (this.position == 0) {
                throw new IllegalArgumentException("First entry in container must be absolute!");
            }
            this.states.set(this.position, bit ^ this.states.get(this.position - 1));
        }
        ++this.position;
        return this.byteSize;
    }

    @Override
    public void appendDownsampled(Container source, int offset, int factor) {
        boolean state;
        boolean multiple;
        if (offset >= 0 && offset < factor) {
            multiple = this.glitch.get(this.position);
            state = this.states.get(this.position);
        } else {
            multiple = false;
            state = this.states.get(this.position);
        }
        if (offset > 0) {
            int nulls = offset / factor;
            this.position += nulls;
            offset += -nulls;
        }
        int shift = Math.max(offset, 0);
        for (int idx = Math.max(-offset, 0); idx < source.position; ++idx) {
            int phase;
            if (this.getCapacity() <= this.position) {
                return;
            }
            if (state != (source.val(idx) == 1.0)) {
                multiple = true;
            }
            if ((phase = (idx + 1 + shift) % factor) != 0) continue;
            this.states.set(this.position, state);
            this.glitch.set(this.position, multiple);
            ++this.position;
            multiple = false;
            state = source.val(idx) == 1.0;
        }
        if (this.position < this.getCapacity()) {
            this.states.set(this.position, state);
            this.glitch.set(this.position, multiple);
        }
    }

    @Override
    public void appendVoid(int gapSize) {
        this.position += gapSize;
    }

    @Override
    public Sample getSample(int startIdx, int len) {
        BitContainer.checkStartIdx(startIdx);
        int transitions = 0;
        boolean state = this.states.get(Math.max(0, startIdx - 1));
        if (len == 0) {
            return Sample.VOID;
        }
        int skipped = 0;
        for (int i = 0; i < len; ++i) {
            int idx = startIdx + i;
            if (idx >= this.position) {
                skipped += len - i;
                break;
            }
            if (this.states.get(idx) != state) {
                ++transitions;
                state = this.states.get(idx);
            }
            if (!this.glitch.get(idx)) continue;
            transitions += 2;
        }
        if ((len -= skipped) == 0) {
            return Sample.ABSENT;
        }
        return new DiscreteSample(state ? 1 : 0, transitions > 1, len);
    }
}

