/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.ContainerFactory;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.LoadMethodDispatcher;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

abstract class TimeTile
implements Comparable<TimeTile>,
LoadMethodDispatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int DT_UNKNOWN = 0;
    public final Range<HwClock> span;
    HashSet<CacheTimeTile> children;
    public static transient boolean READING_OBJECT = false;
    private int dt;

    TimeTile(int dt, Range<HwClock> span) {
        this.span = span;
        this.dt = dt;
        this.children = new HashSet();
    }

    public int indexOf(HwClock hwClock) {
        int idx = (hwClock.ts - this.span.lowerEndpoint().ts) / this.getDt();
        if (idx < 0 || this.span.hasUpperBound() && idx > this.length()) {
            SGUtils.log("Timestamp %s out of range %s", hwClock, this);
        }
        return idx;
    }

    public int length() {
        return (this.span.upperEndpoint().ts - this.span.lowerEndpoint().ts + this.getDt()) / this.getDt();
    }

    @Override
    public int compareTo(TimeTile other) {
        if (this.span == null) {
            if (other.span == null) {
                return this.getDt() - other.getDt();
            }
            return -1;
        }
        if (other.span == null) {
            return 1;
        }
        return ComparisonChain.start().compare(this.getDt(), other.getDt()).compare(this.span.lowerEndpoint(), other.span.lowerEndpoint()).result();
    }

    public int hashCode() {
        return Objects.hashCode(this.span);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeTile)) {
            return false;
        }
        if (READING_OBJECT) {
            if (this.span == null || ((TimeTile)obj).span == null) {
                return false;
            }
        } else {
            if (this.span == null) {
                SGUtils.err("Comparison with null-y TimeTile:" + this, new Object[0]);
            }
            if (((TimeTile)obj).span == null) {
                SGUtils.err("Comparison with null-y TimeTile:" + obj, new Object[0]);
            }
        }
        return this.span.equals(((TimeTile)obj).span);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Range", this.span).add("dt", this.getDt()).toString();
    }

    public abstract Descriptor mergedDescriptor(ContainerFactory var1, String var2);

    public boolean covered() {
        if (this.children.isEmpty()) {
            return false;
        }
        Range<HwClock> cachedSpan = this.children.iterator().next().span;
        for (CacheTimeTile tt : this.children) {
            cachedSpan = cachedSpan.span(tt.span);
        }
        return cachedSpan.encloses(this.span);
    }

    public abstract Range<HwClock> backedSpan();

    int getDt() {
        return this.dt;
    }

    void setDt(int dt) {
        this.dt = dt;
    }

    protected boolean isDtMissing() {
        return this.dt == 0;
    }

    public void cleanUp() {
        Iterator<CacheTimeTile> itt = this.children.iterator();
        TimeTile tile = null;
        while (itt.hasNext()) {
            TimeTile tt = itt.next();
            if (tile == null) {
                tile = tt;
                continue;
            }
            if (tt == null || tt == tile || !tile.equals(tt)) continue;
            System.out.println("Removing twice existing TimeTile child " + tt);
            itt.remove();
        }
    }

    public static class ResolutionPriority
    implements Comparator<TimeTile> {
        final double dt;

        public ResolutionPriority(double dt) {
            this.dt = dt;
        }

        @Override
        public int compare(TimeTile left, TimeTile right) {
            if (left.getDt() == right.getDt()) {
                return left.span.lowerEndpoint().ts - right.span.lowerEndpoint().ts;
            }
            if ((double)left.getDt() <= this.dt && (double)right.getDt() <= this.dt) {
                return left.getDt() - right.getDt();
            }
            return right.getDt() - left.getDt();
        }
    }

    static class DistancePriority
    implements Comparator<TimeTile> {
        private int ts;

        DistancePriority(HwClock reference) {
            this.ts = reference.ts;
        }

        private static int minDistance(int ts, Range<HwClock> range) {
            int distToLower = range.hasLowerBound() ? range.lowerEndpoint().ts - ts : Integer.MAX_VALUE;
            int distToUpper = range.hasUpperBound() ? range.upperEndpoint().ts - ts : Integer.MAX_VALUE;
            return Math.min(Math.abs(distToLower), Math.abs(distToUpper));
        }

        @Override
        public int compare(TimeTile left, TimeTile right) {
            return DistancePriority.minDistance(this.ts, left.span) - DistancePriority.minDistance(this.ts, right.span);
        }
    }
}

