/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.HwClock;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStatsAccumulator;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.base.BaseDateTime;

public class TimeMapping {
    private static final double DEFAULT_SLOPE = 1000.0;
    private PairedStatsAccumulator stats;
    LinearTransformation clkToMillis;
    LinearTransformation millisToClk;
    Origin origin;
    DateTimeZone timeZone;
    public Map<HwClock, DateTime> anchors = new TreeMap<HwClock, DateTime>();

    private TimeMapping() {
    }

    public static TimeMapping empty() {
        TimeMapping tm = new TimeMapping();
        tm.origin = Origin.TBD;
        tm.stats = new PairedStatsAccumulator();
        return tm;
    }

    static TimeMapping singular(HwClock hwClock, DateTimeZone timeZone) {
        TimeMapping tm = new TimeMapping();
        tm.origin = Origin.SINGULAR;
        tm.timeZone = timeZone;
        tm.millisToClk = LinearTransformation.horizontal(hwClock.ts);
        tm.clkToMillis = tm.millisToClk.inverse();
        return tm;
    }

    void addTimeAnchor(HwClock hwClock, long millis, DateTimeZone tz) {
        this.timeZone = tz;
        this.stats.add(hwClock.ts, millis);
        this.anchors.put(hwClock, new DateTime(millis));
    }

    public void fit() {
        LinearTransformation mapping = null;
        if (this.stats.count() == 0L) {
            this.origin = Origin.TBD;
        } else if (this.stats.count() == 1L || this.stats.xStats().populationVariance() == 0.0) {
            this.origin = Origin.SINGLE;
            mapping = LinearTransformation.mapping(this.stats.xStats().mean(), this.stats.yStats().mean()).withSlope(1000.0);
        } else {
            this.origin = Origin.REGRESSION;
            mapping = this.stats.leastSquaresFit();
            if (this.stats.xStats().populationVariance() > 0.0 && this.stats.pearsonsCorrelationCoefficient() < 0.99 || mapping.slope() < 900.0 || mapping.slope() > 1100.0) {
                SGUtils.err("Spurious correlation: %s", mapping.slope());
                BaseDateTime dateTime_ = null;
                HwClock hwClock_ = null;
                for (Map.Entry<HwClock, DateTime> anchor : this.anchors.entrySet()) {
                    DateTime dateTime = anchor.getValue();
                    HwClock hwClock = anchor.getKey();
                    if (dateTime_ != null) {
                        long dt = (dateTime.getMillis() - dateTime_.getMillis()) / 1000L;
                        System.err.printf("+%,12d  /  +%,12d", hwClock.ts - hwClock_.ts, dt);
                    }
                    String s = SGUtils.DATE_TIME_FORMATTER.print(dateTime);
                    System.err.printf("%n%15d -> %-30s", hwClock.ts, s);
                    dateTime_ = dateTime;
                    hwClock_ = hwClock;
                }
                mapping = LinearTransformation.mapping(this.stats.xStats().mean(), this.stats.yStats().mean()).withSlope(1000.0);
            }
        }
        this.clkToMillis = mapping;
        if (mapping != null) {
            this.millisToClk = mapping.inverse();
        }
    }

    void inheritFit(TimeMapping from) {
        if (!this.origin.equals((Object)Origin.TBD)) {
            throw new IllegalArgumentException();
        }
        this.clkToMillis = from.clkToMillis;
        this.millisToClk = this.clkToMillis.inverse();
        this.timeZone = from.getDateTimeZone();
        this.origin = Origin.INHERITED;
    }

    public HwClock map(long millis) {
        if (this.origin.equals((Object)Origin.TBD)) {
            throw new IllegalStateException();
        }
        return new HwClock((int)Math.floor(this.millisToClk.transform(millis)));
    }

    public DateTime map(HwClock hwClock) {
        if (this.origin.equals((Object)Origin.TBD)) {
            throw new IllegalStateException();
        }
        return new DateTime((long)Math.ceil(this.clkToMillis.transform(hwClock.ts)), this.timeZone);
    }

    public DateTimeZone getDateTimeZone() {
        return this.timeZone;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.clkToMillis.transform(0.0), this.clkToMillis.slope(), this.origin});
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mapping", (Object)this.origin).toString();
    }

    public static enum Origin {
        REGRESSION,
        SINGLE,
        MANUAL,
        INHERITED,
        TBD,
        SINGULAR;

    }
}

