/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.data.CurrentLog;
import ch.bruker.jac.servicegui.data.EventData;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.PrunedLog;
import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.data.TimeLine;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class TimeMap
implements Serializable {
    private static final long serialVersionUID = 6L;
    private transient TimeLine timeLine;
    public final MultiAxis<String> errorMessages = new MultiAxis();
    public final MultiAxis<String> systemInfo = new MultiAxis();
    public final Axis<EventData> eventData = new Axis();
    public final Axis<Log> logs = new Axis<Log>(){
        private static final long serialVersionUID = 1L;

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            for (Tag tag : this.all()) {
                if (tag.getValue() instanceof CurrentLog) continue;
                Tag<PrunedLog> prunedLog = new Tag<PrunedLog>(tag.hwClock, tag.dateTime, new PrunedLog((Log)tag.getValue()));
                this.hwClockMap.put(tag.hwClock, prunedLog);
                this.dateTimeMap.put(tag.dateTime, prunedLog);
            }
        }
    };

    public void bindTimeLine(TimeLine timeLine) {
        this.timeLine = timeLine;
    }

    public void clear() {
        this.errorMessages.clear();
        this.systemInfo.clear();
        this.eventData.clear();
        this.logs.clear();
    }

    public synchronized void lock() throws InterruptedException, IOException {
        boolean failed = false;
        if (this.errorMessages.lock.tryLock(2L, TimeUnit.SECONDS) && this.systemInfo.lock.tryLock(2L, TimeUnit.SECONDS)) {
            return;
        }
        throw new IOException("Cannot lock timemap. Aborting...");
    }

    public synchronized void unlock() {
        this.errorMessages.lock.unlock();
        this.systemInfo.lock.unlock();
    }

    public void verifyTagMappings() {
        Duration tol = Duration.standardSeconds(2L);
        if (!(this.logs.checkMapping(tol) && this.eventData.checkMapping(tol) && this.systemInfo.checkMapping(tol) && this.errorMessages.checkMapping(tol))) {
            this.logs.fixMapping();
            this.eventData.fixMapping();
            this.systemInfo.fixMapping();
            this.errorMessages.fixMapping();
        }
    }

    public class MultiAxis<V extends Comparable<V>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TreeMultimap<HwClock, Tag<V>> hwClockMap = TreeMultimap.create();
        private final TreeMultimap<DateTime, Tag<V>> dateTimeMap = TreeMultimap.create();
        final Lock lock = new ReentrantLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void put(HwClock hwClock, V value) {
            DateTime dateTime = TimeMap.this.timeLine.toDateTime(hwClock);
            Tag<V> tag = new Tag<V>(hwClock, dateTime, value);
            this.lock.lock();
            try {
                this.hwClockMap.put((Object)hwClock, tag);
                this.dateTimeMap.put((Object)dateTime, tag);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void put(DateTime dateTime, V value) {
            HwClock hwClock = TimeMap.this.timeLine.toHwClock(dateTime);
            Tag<V> tag = new Tag<V>(hwClock, dateTime, value);
            this.lock.lock();
            try {
                this.hwClockMap.put((Object)hwClock, tag);
                this.dateTimeMap.put((Object)dateTime, tag);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void putAll(Multimap<HwClock, V> map) {
            this.lock.lock();
            try {
                for (Map.Entry<HwClock, Collection<V>> entry : map.asMap().entrySet()) {
                    HwClock hwClock = entry.getKey();
                    DateTime dateTime = TimeMap.this.timeLine.toDateTime(hwClock);
                    for (Comparable payload : entry.getValue()) {
                        Tag<Comparable> tag = new Tag<Comparable>(hwClock, dateTime, payload);
                        this.hwClockMap.put((Object)hwClock, tag);
                        this.dateTimeMap.put((Object)dateTime, tag);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void putAll(Map<HwClock, V> map) {
            this.lock.lock();
            try {
                for (Map.Entry<HwClock, V> entry : map.entrySet()) {
                    HwClock hwClock = entry.getKey();
                    DateTime dateTime = TimeMap.this.timeLine.toDateTime(hwClock);
                    Tag<V> tag = new Tag<V>(hwClock, dateTime, entry.getValue());
                    this.hwClockMap.put((Object)hwClock, tag);
                    this.dateTimeMap.put((Object)dateTime, tag);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public ImmutableList<Tag<V>> get(HwClock key) {
            return ImmutableList.copyOf(this.hwClockMap.get((Object)key));
        }

        public ImmutableList<Tag<V>> get(DateTime key) {
            return ImmutableList.copyOf(this.dateTimeMap.get((Object)key));
        }

        public Collection<Tag<V>> getLower(HwClock key) {
            return ImmutableList.copyOf((Collection)this.hwClockMap.asMap().floorEntry(key).getValue());
        }

        public Collection<Tag<V>> getLower(DateTime key) {
            if (this.dateTimeMap.isEmpty()) {
                return null;
            }
            Map.Entry entry = this.dateTimeMap.asMap().floorEntry(key);
            if (entry == null) {
                return null;
            }
            return ImmutableList.copyOf((Collection)entry.getValue());
        }

        public Collection<Tag<V>> get(Range<HwClock> range) {
            if (range.equals(Range.all())) {
                return this.hwClockMap.values();
            }
            return this.flatten(this.hwClockMap.asMap().subMap(range.lowerEndpoint(), true, range.upperEndpoint(), true).values());
        }

        public Set<Tag<V>> get(Interval range) {
            return this.flatten(this.dateTimeMap.asMap().subMap(range.getStart(), range.getEnd()).values());
        }

        public synchronized Tag<V> remove(V value) {
            Tag tag = null;
            for (Tag entry : this.hwClockMap.values()) {
                if (!((Comparable)entry.getValue()).equals(value)) continue;
                tag = entry;
                break;
            }
            if (tag == null) {
                throw new IllegalArgumentException("Value not present!");
            }
            this.dateTimeMap.remove(tag.dateTime, tag.getValue());
            this.hwClockMap.remove(tag.hwClock, tag.getValue());
            return tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> Set<T> flatten(Collection<Collection<T>> nested) {
            this.lock.lock();
            try {
                LinkedHashSet<T> out = new LinkedHashSet<T>();
                for (Collection<T> inner : nested) {
                    out.addAll(inner);
                }
                ImmutableSet immutableSet = ImmutableSet.copyOf(out);
                return immutableSet;
            }
            finally {
                this.lock.unlock();
            }
        }

        synchronized void clear() {
            this.hwClockMap.clear();
            this.dateTimeMap.clear();
        }

        public int size() {
            return this.dateTimeMap.size();
        }

        public boolean checkMapping(Duration tolerance) {
            boolean mapping_ok = true;
            for (Map.Entry e : this.dateTimeMap.entries()) {
                Tag tag = (Tag)e.getValue();
                DateTime dateTime_ = TimeMap.this.timeLine.toDateTime(tag.hwClock);
                Duration dt = new Duration(tag.dateTime, dateTime_);
                if (!dt.isLongerThan(tolerance)) continue;
                mapping_ok = false;
                break;
            }
            return mapping_ok;
        }

        public synchronized void fixMapping() {
            HashMultimap content = HashMultimap.create();
            for (Map.Entry e : this.hwClockMap.entries()) {
                content.put(e.getKey(), ((Tag)e.getValue()).getValue());
            }
            this.clear();
            this.putAll(content);
        }
    }

    public class Axis<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        NavigableMap<HwClock, Tag<V>> hwClockMap = new ConcurrentSkipListMap<HwClock, Tag<V>>();
        NavigableMap<DateTime, Tag<V>> dateTimeMap = new ConcurrentSkipListMap<DateTime, Tag<V>>();

        Tag<V> createTag(HwClock hwClock, DateTime dateTime, V value) {
            return new Tag<V>(hwClock, dateTime, value);
        }

        public void put(HwClock hwClock, V value) {
            DateTime dateTime = TimeMap.this.timeLine.toDateTime(hwClock);
            Tag<V> tag = this.createTag(hwClock, dateTime, value);
            Tag<V> previous = this.hwClockMap.put(hwClock, tag);
            if (previous != null) {
                this.dateTimeMap.remove(previous.dateTime);
            }
            this.dateTimeMap.put(dateTime, tag);
        }

        void put(DateTime dateTime, V value) {
            HwClock hwClock = TimeMap.this.timeLine.toHwClock(dateTime);
            Tag<V> tag = this.createTag(hwClock, dateTime, value);
            Tag<V> previous = this.dateTimeMap.put(dateTime, tag);
            if (previous != null) {
                this.hwClockMap.remove(previous.hwClock);
            }
            this.hwClockMap.put(hwClock, tag);
        }

        void putAll(Map<HwClock, V> data) {
            for (Map.Entry<HwClock, V> d : data.entrySet()) {
                this.put(d.getKey(), d.getValue());
            }
        }

        void putDefault(V value) {
            HwClock hwClock = new HwClock(Integer.MIN_VALUE);
            DateTime dateTime = new DateTime(0L);
            Tag<V> tag = this.createTag(hwClock, dateTime, value);
            this.hwClockMap.put(hwClock, tag);
            this.dateTimeMap.put(dateTime, tag);
        }

        public Tag<V> get(HwClock key) {
            return (Tag)this.hwClockMap.get(key);
        }

        public Tag<V> get(DateTime key) {
            return (Tag)this.dateTimeMap.get(key);
        }

        public Tag<V> getLower(HwClock key) {
            Map.Entry<HwClock, Tag<V>> entry = this.hwClockMap.floorEntry(key);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public Tag<V> getLower(DateTime key) {
            Map.Entry<DateTime, Tag<V>> entry = this.dateTimeMap.floorEntry(key);
            if (entry == null) {
                return null;
            }
            return this.dateTimeMap.floorEntry(key).getValue();
        }

        public Tag<V> getUpper(HwClock key) {
            Map.Entry<HwClock, Tag<V>> entry = this.hwClockMap.ceilingEntry(key);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public Tag<V> getUpper(DateTime key) {
            Map.Entry<DateTime, Tag<V>> entry = this.dateTimeMap.ceilingEntry(key);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public Collection<Tag<V>> get(Range<HwClock> range) {
            if (range.equals(Range.all())) {
                return this.hwClockMap.values();
            }
            if (!range.hasUpperBound()) {
                return this.hwClockMap.tailMap(range.lowerEndpoint()).values();
            }
            if (!range.hasLowerBound()) {
                return this.hwClockMap.headMap(range.upperEndpoint()).values();
            }
            return this.hwClockMap.subMap(range.lowerEndpoint(), range.upperEndpoint()).values();
        }

        public Collection<Tag<V>> get(Interval range) {
            return this.dateTimeMap.subMap(range.getStart(), range.getEnd()).values();
        }

        synchronized void clear() {
            this.hwClockMap.clear();
            this.dateTimeMap.clear();
        }

        public Tag<V> getLast() {
            return this.dateTimeMap.lastEntry().getValue();
        }

        public Tag<V> getFirst() {
            return this.dateTimeMap.firstEntry().getValue();
        }

        public Tag<V> remove(HwClock hwClock) {
            Tag removed = (Tag)this.hwClockMap.remove(hwClock);
            if (removed == null) {
                throw new IllegalArgumentException("No mapping at " + hwClock);
            }
            this.dateTimeMap.remove(removed.dateTime);
            return removed;
        }

        public Tag<V> remove(V value) {
            HwClock key = null;
            for (Map.Entry entry : this.hwClockMap.descendingMap().entrySet()) {
                if (!((Tag)entry.getValue()).getValue().equals(value)) continue;
                key = (HwClock)entry.getKey();
            }
            if (key == null) {
                throw new IllegalArgumentException("Value not present!");
            }
            return this.remove((V)key);
        }

        public Collection<Tag<V>> all() {
            return this.dateTimeMap.values();
        }

        public boolean checkMapping(Duration tolerance) {
            boolean mapping_ok = true;
            for (Map.Entry e : this.dateTimeMap.entrySet()) {
                Tag tag = (Tag)e.getValue();
                DateTime dateTime_ = TimeMap.this.timeLine.toDateTime(tag.hwClock);
                Duration dt = new Duration(tag.dateTime, dateTime_);
                if (!dt.isLongerThan(tolerance)) continue;
                mapping_ok = false;
                break;
            }
            return mapping_ok;
        }

        public void fixMapping() {
            HashMap content = new HashMap();
            for (Map.Entry e : this.hwClockMap.entrySet()) {
                content.put(e.getKey(), ((Tag)e.getValue()).getValue());
            }
            this.clear();
            this.putAll(content);
        }
    }
}

