/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Colors;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.ArchiveLog;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.CurrentLog;
import ch.bruker.jac.servicegui.data.Demuxer;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.InvalidSourceException;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.TimeMapping;
import ch.bruker.jac.servicegui.data.TimeTile;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.util.JOptionPaneTB;
import ch.bruker.util.PlotFrame;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class TimeLine {
    static final int DS_FACTOR = 10;
    static final int DS_FIRST_LAYER_DT = 60;
    private static final int DS_TIME_TILE_LENGTH = 10000;
    public final RangeMap<HwClock, TimeMapping> clkMap;
    public final RangeMap<DateTime, TimeMapping> millisMap;
    final Set<TimeTile> timeTiles = Collections.newSetFromMap(new ConcurrentHashMap());
    private FileTimeTile current = null;
    private DateTime edge;
    private final TreeRangeSet<DateTime> timeRefsCoverage;
    public final Range<HwClock> cacheCoverage;
    final TreeRangeSet<HwClock> fileCoverage;
    private final RangeMap<DateTime, CoverageState> coverageMap;
    private final RangeSet<DateTime> uncoveredSet;
    private final Source source;
    private final AppState appState;
    private static final Header TIMEREFS_HEADER = new Header(new Pool<Descriptor>(), new HashMap<String, Descriptor>(), new LinkedList<String>(), 48, 0);

    public TimeLine(Source source, AppState appState) throws InvalidSourceException {
        this.clkMap = TreeRangeMap.create();
        this.millisMap = TreeRangeMap.create();
        this.appState = appState;
        this.source = source;
        this.fileCoverage = TreeRangeSet.create();
        this.timeRefsCoverage = TreeRangeSet.create();
        this.cacheCoverage = Range.lessThan(new HwClock(0));
        this.coverageMap = TreeRangeMap.create();
        this.uncoveredSet = TreeRangeSet.create();
    }

    public void readTimeRefs() {
        Demuxer timeRefs = null;
        try {
            InputStream in = this.source.current.open("time_refs.bin");
            timeRefs = new Demuxer(TIMEREFS_HEADER, in);
            timeRefs.run();
        }
        catch (IOException e) {
            throw new InvalidSourceException("Could not load time references.");
        }
        TreeRangeMap<HwClock, TimeMapping> timeMappings = timeRefs.getTimeMappings();
        if (timeMappings.asMapOfRanges().isEmpty()) {
            if (this.source.api != null) {
                throw new InvalidSourceException("Empty time references.");
            }
            timeMappings.put(Range.atLeast(new HwClock(0)), TimeMapping.empty());
        }
        TreeMap<HwClock, TimeMapping> upcoming = new TreeMap<HwClock, TimeMapping>();
        for (Map.Entry<Range<HwClock>, TimeMapping> entry : timeMappings.asMapOfRanges().entrySet()) {
            TimeMapping timeMapping = entry.getValue();
            if (timeMapping.getOrigin().equals((Object)TimeMapping.Origin.TBD)) continue;
            upcoming.put(entry.getKey().lowerEndpoint(), timeMapping);
        }
        if (upcoming.isEmpty()) {
            if (!this.appState.noTimeServer) {
                this.warnNoTimeAnchors();
            }
            DateTime dateTime = DateTime.now(DateTimeZone.UTC);
            TimeMapping fake = timeMappings.asMapOfRanges().values().iterator().next();
            HwClock now = null;
            if (this.source.api == null) {
                now = this.estimateCurrentHwClock();
            } else {
                try {
                    now = this.source.api.getJacHwClock();
                }
                catch (ApiTalker.RemoteException e) {
                    SGUtils.err("No time mappings in log, and JAC doesn't respond. Aborting.", new Object[0]);
                    e.printStackTrace();
                    throw new IllegalStateException();
                }
            }
            fake.addTimeAnchor(now, dateTime.getMillis(), dateTime.getZone());
            fake.origin = TimeMapping.Origin.MANUAL;
            fake.fit();
        }
        TimeMapping previous = null;
        for (Map.Entry<Range<HwClock>, TimeMapping> entry : timeMappings.asMapOfRanges().entrySet()) {
            Range<HwClock> span = entry.getKey();
            TimeMapping timeMapping = entry.getValue();
            if (timeMapping.getOrigin().equals((Object)TimeMapping.Origin.TBD)) {
                Map.Entry next = upcoming.higherEntry(span.lowerEndpoint());
                if (next != null) {
                    timeMapping.inheritFit((TimeMapping)next.getValue());
                } else if (previous != null) {
                    timeMapping.inheritFit(previous);
                }
            }
            previous = timeMapping;
        }
        this.clkMap.clear();
        for (Map.Entry<Range<HwClock>, TimeMapping> entry : timeMappings.asMapOfRanges().entrySet()) {
            this.clkMap.put(entry.getKey(), entry.getValue());
        }
        this.clkMapToMillisMap();
    }

    HwClock estimateCurrentHwClock() {
        HwClock currentTimeHwClock = new HwClock(0);
        ImmutableSortedSet<String> ls = ImmutableSortedSet.copyOf(this.source.archives.ls());
        for (String filename : ls) {
            if (!ArchiveLog.DATA_ARCHIVE.matcher(filename).matches()) continue;
            ArchiveLog log = new ArchiveLog(filename);
            if (((HwClock)log.span.upperEndpoint()).ts <= currentTimeHwClock.ts) continue;
            currentTimeHwClock = (HwClock)log.span.upperEndpoint();
        }
        return currentTimeHwClock;
    }

    void clear() {
        this.timeTiles.clear();
        this.fileCoverage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<HwClock, Log> readLogFiles(Pool pool) {
        FileTimeTile tt;
        Serializable fileSpan;
        this.fileCoverage.clear();
        if (this.current != null) {
            this.timeTiles.remove(this.current);
        }
        HashMap<HwClock, Log> added = new HashMap<HwClock, Log>();
        ArchiveLog log_ = null;
        boolean clkMapDirty = false;
        ImmutableSortedSet<String> ls = ImmutableSortedSet.copyOf(this.source.archives.ls());
        for (String filename : ls) {
            if (!ArchiveLog.DATA_ARCHIVE.matcher(filename).matches()) continue;
            ArchiveLog log = new ArchiveLog(filename);
            if (log_ != null && log_.span.isConnected(log.span)) {
                SGUtils.log("Colliding log file [%s]: %s already covered by %s", filename, log.span, log_.span);
                continue;
            }
            log_ = log;
            fileSpan = null;
            try {
                fileSpan = this.toDateTime(log.span);
            }
            catch (IllegalArgumentException x) {
                SGUtils.log("%s: %s", filename, x.getMessage());
                throw x;
            }
            if (!this.timeRefsCoverage.encloses((Range<DateTime>)fileSpan)) {
                TimeMapping fakey = TimeMapping.empty();
                TimeMapping closest = this.clkMap.get((HwClock)log.span.lowerEndpoint());
                if (closest == null) {
                    for (Map.Entry<Range<HwClock>, TimeMapping> entry : this.clkMap.asMapOfRanges().entrySet()) {
                        if (entry.getKey().lowerEndpoint().ts < ((HwClock)log.span.lowerEndpoint()).ts) continue;
                        closest = entry.getValue();
                        break;
                    }
                }
                fakey.inheritFit(closest);
                fakey.origin = TimeMapping.Origin.MANUAL;
                this.clkMap.put(log.span, fakey);
                SGUtils.log("Logfile unknown to time reference: %s.", log.span);
                clkMapDirty = true;
            }
            tt = new FileTimeTile(log.span);
            this.timeTiles.add(tt);
            this.fileCoverage.add(tt.span);
            added.put((HwClock)log.span.lowerEndpoint(), log);
        }
        if (clkMapDirty) {
            this.clkMapToMillisMap();
        }
        this.generateCacheTimeTiles();
        if (this.source.current.ls().contains("Current.xml")) {
            CurrentLog log = new CurrentLog();
            try {
                Range<HwClock> span;
                HwClock start = null;
                Demuxer demuxer = log.getDemuxer(this.source, pool);
                start = demuxer.run();
                if (start == null || demuxer.getSamplePeriod() == -1) {
                    SGUtils.err("No data in Current-log. Continuing without...", new Object[0]);
                    this.bumpEdge(this.fileCoverage.span().upperEndpoint());
                    fileSpan = added;
                    return fileSpan;
                }
                this.bumpEdge(demuxer.getEdge());
                log.reset(this.source, pool);
                log.span = span = Range.atLeast(start);
                tt = new FileTimeTile(span);
                this.timeTiles.add(tt);
                this.fileCoverage.add(tt.span);
                this.current = tt;
                added.put(start, log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                log.release(this.source);
            }
        } else {
            this.bumpEdge(this.fileCoverage.span().upperEndpoint());
        }
        return added;
    }

    private void warnNoTimeAnchors() {
        String msg = "<html>The data from " + this.appState.system.name + " contains no timing information yet.<br/>" + "Therefore, the current and preceding uptimes will be concatenated.<br/>";
        String title = "Missing timing information";
        JOptionPaneTB.showConfirmDialog(this.appState.getRootFrame(), msg, "Missing timing information", 2, SGUtils.PROGRAM_ICONS);
    }

    public static Interval m(Range<DateTime> span) {
        DateTime lower = span.hasLowerBound() ? span.lowerEndpoint() : new DateTime(0L);
        DateTime upper = span.hasUpperBound() ? span.upperEndpoint() : new DateTime();
        return new Interval((ReadableInstant)lower, (ReadableInstant)upper);
    }

    public static Range<DateTime> m(Interval span) {
        return Range.closed(span.getStart(), span.getEnd());
    }

    public static Range<DateTime> pad(Range<DateTime> range, long millis) {
        long start = range.lowerEndpoint().getMillis() - millis;
        long end = range.upperEndpoint().getMillis() + millis;
        return Range.closed(new DateTime(start), new DateTime(end));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clkMapToMillisMap() {
        RangeMap<DateTime, TimeMapping> rangeMap = this.millisMap;
        synchronized (rangeMap) {
            this.millisMap.clear();
            HwClock shutdownClk = null;
            DateTime shutdown = null;
            for (Map.Entry<Range<HwClock>, TimeMapping> entry : this.clkMap.asMapOfRanges().entrySet()) {
                Range<DateTime> downtime;
                TimeMapping m = entry.getValue();
                Range<HwClock> clkRange = entry.getKey();
                DateTime startup = m.map(clkRange.lowerEndpoint());
                if (shutdown == null) {
                    downtime = Range.lessThan(startup);
                } else if (startup.isBefore(shutdown)) {
                    downtime = Range.closedOpen(shutdown, shutdown);
                    Period shift = new Duration(startup, shutdown).toPeriod();
                    SGUtils.log("Negative downtime: %s until %s, aka. -%s", shutdown, startup, SGUtils.PERIOD_FORMATTER.print(shift));
                } else {
                    downtime = Range.closedOpen(shutdown, startup);
                }
                this.millisMap.put(downtime, TimeMapping.singular(clkRange.lowerEndpoint(), m.getDateTimeZone()));
                if (clkRange.hasUpperBound()) {
                    shutdownClk = clkRange.upperEndpoint();
                    shutdown = m.map(shutdownClk);
                    this.millisMap.put(Range.closedOpen(startup, shutdown), m);
                    continue;
                }
                this.millisMap.put(Range.atLeast(startup), m);
            }
            this.timeRefsCoverage.clear();
            for (Map.Entry<Range<Comparable<HwClock>>, TimeMapping> entry : this.millisMap.asMapOfRanges().entrySet()) {
                if (entry.getValue().getOrigin().equals((Object)TimeMapping.Origin.SINGULAR)) continue;
                this.timeRefsCoverage.add(entry.getKey());
            }
        }
    }

    public DateTime toDateTime(HwClock hwClock) {
        TimeMapping timeMapping = this.clkMap.get(hwClock);
        if (timeMapping == null) {
            Iterator<TimeMapping> it = this.clkMap.subRangeMap(Range.atMost(hwClock)).asMapOfRanges().values().iterator();
            if (!it.hasNext()) {
                it = this.clkMap.subRangeMap(Range.atLeast(hwClock)).asMapOfRanges().values().iterator();
            }
            timeMapping = it.next();
        }
        return timeMapping.map(hwClock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HwClock toHwClock(long millis) {
        RangeMap<DateTime, TimeMapping> rangeMap = this.millisMap;
        synchronized (rangeMap) {
            TimeMapping timeMapping = this.millisMap.get(new DateTime(millis));
            return timeMapping.map(millis);
        }
    }

    HwClock toHwClock(ReadableInstant instant) {
        return this.toHwClock(instant.getMillis());
    }

    Range<HwClock> toHwClock(Interval interval) {
        HwClock lower = this.toHwClock(interval.getStartMillis());
        HwClock upper = this.toHwClock(interval.getEndMillis());
        if (lower.ts > upper.ts) {
            System.err.println("Error in time map!");
            RangeMap<DateTime, TimeMapping> map = this.millisMap.subRangeMap(TimeLine.m(interval));
            double end_ = 0.0;
            for (Map.Entry<Range<DateTime>, TimeMapping> entry : map.asMapOfRanges().entrySet()) {
                Range<DateTime> range = entry.getKey();
                double start = entry.getValue().millisToClk.transform(range.lowerEndpoint().getMillis());
                double end = entry.getValue().millisToClk.transform(range.upperEndpoint().getMillis());
                System.err.printf("\t%s => %9.0f..%9.0f gap=%-6.0f   d=%-6.0f\n", range, start, end, start - end_, end - start);
                end_ = end;
            }
            System.err.println();
        }
        return Range.closed(lower, upper);
    }

    Interval toInterval(Range<HwClock> tsRange) {
        DateTime start = this.toDateTime(tsRange.lowerEndpoint());
        if (!tsRange.hasUpperBound()) {
            if (start.isAfter(this.appState.getTimeLineEnd())) {
                return new Interval((ReadableInstant)start, Duration.ZERO);
            }
            return new Interval((ReadableInstant)start, (ReadableInstant)this.appState.getTimeLineEnd());
        }
        return new Interval((ReadableInstant)start, (ReadableInstant)this.toDateTime(tsRange.upperEndpoint()));
    }

    Range<DateTime> toDateTime(Range<HwClock> range) {
        if (!range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.all();
        }
        if (!range.hasLowerBound()) {
            return Range.upTo(this.toDateTime(range.upperEndpoint()), range.upperBoundType());
        }
        if (!range.hasUpperBound()) {
            return Range.downTo(this.toDateTime(range.lowerEndpoint()), range.lowerBoundType());
        }
        return Range.range(this.toDateTime(range.lowerEndpoint()), range.lowerBoundType(), this.toDateTime(range.upperEndpoint()), range.upperBoundType());
    }

    private RangeSet<DateTime> toDateTime(RangeSet<HwClock> rangeSet) {
        TreeRangeSet<DateTime> set = TreeRangeSet.create();
        for (Range<HwClock> range : rangeSet.asRanges()) {
            set.add(this.toDateTime(range));
        }
        return set;
    }

    public Range<HwClock> toHwClock(Range<DateTime> range) {
        if (!range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.all();
        }
        if (!range.hasLowerBound()) {
            return Range.upTo(this.toHwClock(range.upperEndpoint()), range.upperBoundType());
        }
        if (!range.hasUpperBound()) {
            return Range.downTo(this.toHwClock(range.lowerEndpoint()), range.lowerBoundType());
        }
        return Range.range(this.toHwClock(range.lowerEndpoint()), range.lowerBoundType(), this.toHwClock(range.upperEndpoint()), range.upperBoundType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCoverage() {
        if (this.fileCoverage == null) {
            throw new IllegalStateException("fileCoverage must not be null!");
        }
        TreeRangeMap<Object, CoverageState> coverageMap_ = TreeRangeMap.create();
        TreeRangeSet<DateTime> systemWasUp = TreeRangeSet.create();
        systemWasUp.addAll(this.toDateTime(this.fileCoverage));
        systemWasUp.addAll(this.timeRefsCoverage.subRangeSet(Range.lessThan(this.getEdge())));
        coverageMap_.put(Range.all(), CoverageState.NOT_INCLUDED);
        coverageMap_.put(this.toDateTime(this.cacheCoverage), CoverageState.DOWNSAMPLED);
        for (Range<DateTime> range : this.toDateTime(this.fileCoverage).asRanges()) {
            coverageMap_.put(range, CoverageState.RAW_FILES);
        }
        for (Range<DateTime> range : systemWasUp.complement().asRanges()) {
            coverageMap_.remove(range);
        }
        Object object = this.coverageMap;
        synchronized (object) {
            this.coverageMap.clear();
            this.coverageMap.putAll(coverageMap_);
        }
        object = this.uncoveredSet;
        synchronized (object) {
            this.uncoveredSet.clear();
            for (Map.Entry<Range<DateTime>, CoverageState> entry : this.coverageMap.asMapOfRanges().entrySet()) {
                if (entry.getValue() != CoverageState.RAW_FILES && entry.getValue() != CoverageState.DOWNSAMPLED) continue;
                this.uncoveredSet.add(entry.getKey());
            }
        }
    }

    private void generateCacheTimeTiles() {
        if (this.fileCoverage.isEmpty()) {
            return;
        }
        HwClock right = this.fileCoverage.span().upperEndpoint();
        TimeTileIterator<TimeTile> parentLayer = this.fileTimeTiles();
        for (int dt = 60; dt <= 86400; dt *= 10) {
            int len = dt * 10000;
            right = right.lower(len);
            int ts = 0;
            while (ts + len <= right.ts) {
                HwClock left = new HwClock(ts);
                Range<HwClock> ttSpan = Range.closedOpen(left, new HwClock(ts + len));
                ImmutableSortedSet<TimeTile> parents = parentLayer.fork().in(ttSpan).sorted();
                Optional<CacheTimeTile> optional = this.cacheTimeTiles().withDt(dt).at(left).first();
                CacheTimeTile cacheTimeTile = optional.or(new CacheTimeTile(dt, ttSpan, parents));
                for (TimeTile parent : parents) {
                    parent.children.add(cacheTimeTile);
                }
                if (!optional.isPresent()) {
                    this.timeTiles.add(cacheTimeTile);
                    this.cacheCoverage.span(cacheTimeTile.span);
                }
                ts += len;
            }
            parentLayer = this.timeTiles().withDt(dt);
        }
    }

    TimeTileIterator<TimeTile> timeTiles() {
        return new TimeTileIterator<TimeTile>(TimeTile.class);
    }

    TimeTileIterator<FileTimeTile> fileTimeTiles() {
        return new TimeTileIterator<FileTimeTile>(FileTimeTile.class);
    }

    TimeTileIterator<CacheTimeTile> cacheTimeTiles() {
        return new TimeTileIterator<CacheTimeTile>(CacheTimeTile.class);
    }

    public FileTimeTile getCurrent() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTimeZone getSourceTimeZone() {
        RangeMap<DateTime, TimeMapping> rangeMap = this.millisMap;
        synchronized (rangeMap) {
            return this.millisMap.asDescendingMapOfRanges().values().iterator().next().timeZone;
        }
    }

    public DateTime getEdge() {
        if (this.edge == null) {
            return DateTime.now();
        }
        return this.edge;
    }

    public TreeRangeSet<HwClock> getFileCoverage() {
        return this.fileCoverage;
    }

    public void plot(Frame owner) {
        PlotFrame plot = new PlotFrame(owner, "Time mapping", "HwClock", "");
        AxisRenderer axisRenderer = plot.getAxisRenderer("y");
        axisRenderer.setTickLabelFormat(SimpleDateFormat.getDateTimeInstance());
        axisRenderer.setTickLabelRotation(75.0);
        plot.setMargins(20, 80, 60, 60);
        RangeMap<DateTime, TimeMapping> map = this.millisMap.subRangeMap(Range.atLeast(DateTime.now().minusDays(3)));
        for (Map.Entry<Range<DateTime>, TimeMapping> entry : map.asMapOfRanges().entrySet()) {
            Interval uptime;
            try {
                uptime = TimeLine.m(entry.getKey());
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                continue;
            }
            for (Map.Entry<HwClock, DateTime> anchor : entry.getValue().anchors.entrySet()) {
                plot.add(anchor.getKey().ts, anchor.getValue().getMillis());
            }
            plot.strokeWidth = 0;
            plot.markerSize = 2;
            plot.markerColor = Colors.getHashColor(1.0f, 0.5f, uptime);
            plot.draw();
            long y = uptime.getStartMillis();
            if (y == 0L) continue;
            plot.add(entry.getValue().map((long)uptime.getStartMillis()).ts, y);
            plot.add(entry.getValue().map((long)uptime.getEndMillis()).ts, uptime.getEndMillis());
            plot.markerSize = 0;
            plot.strokeColor = plot.markerColor;
            plot.strokeWidth = 1;
            plot.draw();
        }
        plot.finish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeMap<DateTime, CoverageState> getCoverage() {
        RangeMap<DateTime, CoverageState> rangeMap = this.coverageMap;
        synchronized (rangeMap) {
            if (this.edge == null) {
                return ImmutableRangeMap.copyOf(this.coverageMap.subRangeMap(Range.atMost(DateTime.now())));
            }
            return ImmutableRangeMap.copyOf(this.coverageMap.subRangeMap(Range.atMost(this.edge)));
        }
    }

    public RangeSet<DateTime> getUncoveredSet() {
        if (this.edge == null) {
            return this.uncoveredSet.subRangeSet(Range.atMost(DateTime.now())).complement();
        }
        return this.uncoveredSet.subRangeSet(Range.atMost(this.edge)).complement();
    }

    public void bumpEdge(HwClock edgeTs) {
        if (this.edge == null || this.toDateTime(edgeTs).isAfter(this.edge)) {
            this.edge = this.toDateTime(edgeTs);
        }
    }

    public static enum CoverageState {
        RAW_FILES,
        DOWNSAMPLED,
        NOT_INCLUDED;

    }

    class TimeTileIterator<T extends TimeTile>
    implements Iterable<T> {
        private FluentIterable<T> head;

        private TimeTileIterator(Class clazz) {
            this.head = FluentIterable.from(TimeLine.this.timeTiles).filter(clazz);
        }

        private TimeTileIterator(Collection<T> collection) {
            this.head = FluentIterable.from(collection);
        }

        public TimeTileIterator<T> at(final HwClock instant) {
            this.head = this.head.filter(new Predicate<TimeTile>(){

                @Override
                public boolean apply(TimeTile timeTile) {
                    return timeTile.span.contains(instant);
                }
            });
            return this;
        }

        public TimeTileIterator<T> at(ReadableInstant instant) {
            if (TimeLine.this.millisMap.get((DateTime)instant).getOrigin() == TimeMapping.Origin.SINGULAR) {
                this.head = this.head.limit(0);
                return this;
            }
            return this.at(TimeLine.this.toHwClock(instant));
        }

        public TimeTileIterator<T> at(long millis) {
            return this.at(TimeLine.this.toHwClock(millis));
        }

        public TimeTileIterator<T> in(final Range<HwClock> interval) {
            this.head = this.head.filter(new Predicate<TimeTile>(){

                @Override
                public boolean apply(TimeTile timeTile) {
                    return interval.isConnected(timeTile.span) && !interval.intersection(timeTile.span).isEmpty();
                }
            });
            return this;
        }

        public TimeTileIterator<T> in(Interval interval) {
            return this.in(TimeLine.this.toHwClock(interval));
        }

        TimeTileIterator<T> fork() {
            ImmutableSet<T> set = this.head.toSet();
            this.head = FluentIterable.from(set);
            return new TimeTileIterator<T>(set);
        }

        TimeTileIterator<T> withDt(final int dt) {
            this.head = this.head.filter(new Predicate<TimeTile>(){

                @Override
                public boolean apply(TimeTile timeTile) {
                    return timeTile.getDt() == dt;
                }
            });
            return this;
        }

        ImmutableSortedSet<T> sorted() {
            return this.sortedBy(Ordering.natural());
        }

        ImmutableSortedSet<T> sortedBy(Comparator<T> comparator) {
            return this.head.toSortedSet(comparator);
        }

        public Optional<T> first() {
            return this.head.first();
        }

        @Override
        public Iterator<T> iterator() {
            return this.head.iterator();
        }

        public Optional<T> last() {
            return this.head.last();
        }
    }
}

