/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.data.CheckBoxTitledBorder;
import ch.bruker.jac.servicegui.data.DataStore;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.util.AbortableProgressTask;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class SaveDialog
extends JDialog {
    DataStore dataStore;
    private AppState appState;
    final Jac jac;
    private final ExecutorService statWorker = Executors.newSingleThreadExecutor();
    private Future<?> pending;
    private final JCheckBox fullBox;
    private JLabel fullDuration;
    private JDateChooser fullFrom;
    private JDateChooser fullUntil;
    private final JCheckBox lightBox;
    private JLabel lightDuration;
    private JDateChooser lightFrom;
    private JDateChooser lightUntil;
    private JRadioButton radioAll;
    private JRadioButton radioPlotted;
    private JLabel sizeLabel;
    private static final PeriodFormatter FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix(" days").toFormatter();
    private final JButton go;

    public SaveDialog(final AppState appState, DataStore dataStore, Jac origin) {
        super(appState.getRootFrame());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.appState = appState;
        this.dataStore = dataStore;
        this.jac = origin;
        this.setResizable(false);
        this.setTitle("Save Log");
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 0};
        layout.rowHeights = new int[]{0, 0, 0, 0, 0};
        layout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(layout);
        JLabel intro = new JLabel("Writes this system's data to a .bin-file, containing:");
        GridBagConstraints _intro = new GridBagConstraints();
        _intro.fill = 2;
        _intro.insets = new Insets(15, 15, 5, 15);
        _intro.gridx = 0;
        _intro.gridy = 0;
        this.getContentPane().add((Component)intro, _intro);
        final JPanel panelFull = new JPanel();
        CheckBoxTitledBorder checkBoxBorder = new CheckBoxTitledBorder("Full recorded data");
        this.fullBox = checkBoxBorder.getBox();
        panelFull.setBorder(checkBoxBorder);
        GridBagConstraints _panelFull = new GridBagConstraints();
        _panelFull.fill = 1;
        _panelFull.insets = new Insets(10, 10, 10, 10);
        _panelFull.gridx = 0;
        _panelFull.gridy = 1;
        this.getContentPane().add((Component)panelFull, _panelFull);
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWidths = new int[]{120, 0, 30, 90, 0};
        gbl.rowHeights = new int[]{0, 0, 0, 0};
        gbl.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelFull.setLayout(gbl);
        JLabel label = new JLabel("Include all parameters at full resolution for:");
        GridBagConstraints _label = new GridBagConstraints();
        _label.anchor = 17;
        _label.gridwidth = 4;
        _label.insets = new Insets(5, 15, 0, 0);
        _label.gridx = 0;
        _label.gridy = 0;
        panelFull.add((Component)label, _label);
        this.fullFrom = new JDateChooser();
        GridBagConstraints _fullFrom = new GridBagConstraints();
        _fullFrom.insets = new Insets(10, 15, 10, 5);
        _fullFrom.fill = 1;
        _fullFrom.gridx = 0;
        _fullFrom.gridy = 1;
        panelFull.add((Component)this.fullFrom, _fullFrom);
        label = new JLabel("\u2026");
        _label = new GridBagConstraints();
        _label.fill = 3;
        _label.insets = new Insets(10, 0, 10, 5);
        _label.gridx = 1;
        _label.gridy = 1;
        panelFull.add((Component)label, _label);
        this.fullUntil = new JDateChooser();
        GridBagConstraints _fullUntil = new GridBagConstraints();
        _fullUntil.gridwidth = 2;
        _fullUntil.fill = 2;
        _fullUntil.insets = new Insets(10, 0, 10, 15);
        _fullUntil.gridx = 2;
        _fullUntil.gridy = 1;
        panelFull.add((Component)this.fullUntil, _fullUntil);
        JPanel panel = new JPanel();
        GridBagConstraints _panel = new GridBagConstraints();
        _panel.gridwidth = 3;
        _panel.insets = new Insets(0, 13, 10, 5);
        _panel.fill = 2;
        _panel.gridx = 0;
        _panel.gridy = 2;
        panelFull.add((Component)panel, _panel);
        panel.setLayout(new FlowLayout(0, 2, 0));
        DurationButton btn1 = new DurationButton("1d", Period.hours(24), this.fullFrom, this.fullUntil);
        panel.add(btn1);
        DurationButton btn10 = new DurationButton("10d", Period.days(10), this.fullFrom, this.fullUntil);
        panel.add(btn10);
        DurationButton btnm = new DurationButton("30d", Period.days(30), this.fullFrom, this.fullUntil);
        panel.add(btnm);
        this.fullDuration = new JLabel();
        this.fullDuration.setHorizontalAlignment(4);
        GridBagConstraints _fullDuration = new GridBagConstraints();
        _fullDuration.fill = 1;
        _fullDuration.insets = new Insets(0, 0, 10, 15);
        _fullDuration.gridx = 3;
        _fullDuration.gridy = 2;
        panelFull.add((Component)this.fullDuration, _fullDuration);
        this.fullBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SaveDialog.nestedSetEnabled(panelFull, e.getStateChange() == 1);
                SaveDialog.this.checkAnyBoxSelected();
            }
        });
        final JPanel panelLight = new JPanel();
        checkBoxBorder = new CheckBoxTitledBorder("Low resolution data");
        panelLight.setBorder(checkBoxBorder);
        this.lightBox = checkBoxBorder.getBox();
        GridBagConstraints _panelLight = new GridBagConstraints();
        _panelLight.insets = new Insets(10, 10, 10, 10);
        _panelLight.fill = 1;
        _panelLight.gridx = 0;
        _panelLight.gridy = 2;
        this.getContentPane().add((Component)panelLight, _panelLight);
        gbl = new GridBagLayout();
        gbl.columnWidths = new int[]{120, 0, 30, 90, 0};
        gbl.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelLight.setLayout(gbl);
        label = new JLabel("Include one sample per minute for:");
        _label = new GridBagConstraints();
        _label.anchor = 17;
        _label.gridwidth = 4;
        _label.insets = new Insets(5, 15, 5, 0);
        _label.gridx = 0;
        _label.gridy = 0;
        panelLight.add((Component)label, _label);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioAll = new JRadioButton("All parameters");
        this.radioAll.setFocusPainted(false);
        buttonGroup.add(this.radioAll);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 15, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panelLight.add((Component)this.radioAll, gbc);
        this.radioPlotted = new JRadioButton("Plotted/selected parameters only");
        this.radioPlotted.setFocusPainted(false);
        buttonGroup.add(this.radioPlotted);
        this.radioPlotted.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 15, 5, 0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        panelLight.add((Component)this.radioPlotted, gbc);
        this.lightFrom = new JDateChooser();
        GridBagConstraints _lightFrom = new GridBagConstraints();
        _lightFrom.insets = new Insets(10, 15, 10, 5);
        _lightFrom.fill = 1;
        _lightFrom.gridx = 0;
        _lightFrom.gridy = 3;
        panelLight.add((Component)this.lightFrom, _lightFrom);
        JLabel label2 = new JLabel("\u2026");
        GridBagConstraints _label2 = new GridBagConstraints();
        _label2.fill = 3;
        _label2.insets = new Insets(10, 0, 10, 5);
        _label2.gridx = 1;
        _label2.gridy = 3;
        panelLight.add((Component)label2, _label2);
        this.lightUntil = new JDateChooser();
        GridBagConstraints _lightUntil = new GridBagConstraints();
        _lightUntil.gridwidth = 2;
        _lightUntil.insets = new Insets(10, 0, 10, 15);
        _lightUntil.fill = 2;
        _lightUntil.gridx = 2;
        _lightUntil.gridy = 3;
        panelLight.add((Component)this.lightUntil, _lightUntil);
        JPanel panel2 = new JPanel();
        GridBagConstraints _panel2 = new GridBagConstraints();
        _panel2.gridwidth = 3;
        _panel2.insets = new Insets(0, 13, 15, 5);
        _panel2.fill = 2;
        _panel2.gridx = 0;
        _panel2.gridy = 4;
        panelLight.add((Component)panel2, _panel2);
        panel2.setLayout(new FlowLayout(0, 2, 0));
        DurationButton btn3m = new DurationButton("90d", Period.days(90), this.lightFrom, this.lightUntil);
        panel2.add(btn3m);
        DurationButton btnYear = new DurationButton("1yr", Period.years(1), this.lightFrom, this.lightUntil);
        panel2.add(btnYear);
        JButton btnAll = new JButton("all");
        btnAll.setFocusable(false);
        btnAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveDialog.this.lightUntil.setDate(appState.getTimeLineEnd().toDate());
                SaveDialog.this.lightFrom.setDate(appState.getTimeLine().toDateTime(new HwClock(0)).toDate());
                SaveDialog.this.updateLabels();
            }
        });
        panel2.add(btnAll);
        this.lightDuration = new JLabel();
        this.lightDuration.setHorizontalAlignment(4);
        GridBagConstraints _lightDuration = new GridBagConstraints();
        _lightDuration.insets = new Insets(0, 0, 15, 15);
        _lightDuration.fill = 1;
        _lightDuration.gridx = 3;
        _lightDuration.gridy = 4;
        panelLight.add((Component)this.lightDuration, _lightDuration);
        this.lightBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SaveDialog.nestedSetEnabled(panelLight, e.getStateChange() == 1);
                SaveDialog.this.checkAnyBoxSelected();
            }
        });
        SaveDialog.nestedSetEnabled(panelLight, false);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1, 15, 10));
        GridBagConstraints _buttonPane = new GridBagConstraints();
        _buttonPane.anchor = 12;
        _buttonPane.gridx = 0;
        _buttonPane.gridy = 3;
        this.getContentPane().add((Component)buttonPane, _buttonPane);
        this.go = new JButton("Save Log\u2026");
        this.go.setFocusPainted(false);
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveDialog.this.callExport(SaveDialog.this);
            }
        });
        this.sizeLabel = new JLabel();
        buttonPane.add(this.sizeLabel);
        buttonPane.add(this.go);
        this.getRootPane().setDefaultButton(this.go);
        this.fullBox.setSelected(true);
        DateTime start = appState.getTimeLine().toDateTime(new HwClock(0));
        DateTime end = appState.getTimeLineEnd();
        this.fullUntil.setDate(end.toDate());
        this.fullUntil.setMaxSelectableDate(end.toDate());
        this.fullFrom.setDate(end.minusDays(10).toDate());
        this.fullFrom.setMinSelectableDate(start.toDate());
        this.lightUntil.setDate(end.toDate());
        this.lightUntil.setMaxSelectableDate(end.toDate());
        this.lightFrom.setDate(end.minusMonths(3).toDate());
        this.lightFrom.setMinSelectableDate(start.toDate());
        this.updateLabels();
        this.fullFrom.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaveDialog.this.fullUntil.setMinSelectableDate((Date)evt.getNewValue());
                SaveDialog.this.updateLabels();
            }
        });
        this.fullUntil.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaveDialog.this.fullFrom.setMaxSelectableDate((Date)evt.getNewValue());
                SaveDialog.this.updateLabels();
            }
        });
        this.lightFrom.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaveDialog.this.lightUntil.setMinSelectableDate((Date)evt.getNewValue());
                SaveDialog.this.updateLabels();
            }
        });
        this.lightUntil.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaveDialog.this.lightFrom.setMaxSelectableDate((Date)evt.getNewValue());
                SaveDialog.this.updateLabels();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void checkAnyBoxSelected() {
        this.go.setEnabled(this.fullBox.isSelected() || this.lightBox.isSelected());
    }

    private void callExport(final Component parent) {
        long MS_PER_DAY = Period.days(1).toStandardDuration().getMillis();
        final Interval full = this.fullBox.isSelected() ? new Interval(this.fullFrom.getDate().getTime(), this.fullUntil.getDate().getTime() + MS_PER_DAY) : null;
        final Interval light = this.lightBox.isSelected() ? new Interval(this.lightFrom.getDate().getTime(), this.lightUntil.getDate().getTime() + MS_PER_DAY) : null;
        final HashSet<String> pars = new HashSet<String>();
        if (this.radioAll.isSelected()) {
            pars.add("");
        } else if (this.radioPlotted.isSelected()) {
            pars.addAll(this.appState.getActivePars());
        }
        String span = "";
        DateTimeFormatter f = DateTimeFormat.forPattern("yyyyMMdd");
        if (full != null) {
            span = "_" + f.print(full.getStart()) + "_" + f.print(full.getEnd());
        } else if (light != null) {
            span = "_" + f.print(light.getStart()) + "_" + f.print(light.getEnd());
        }
        final JFileChooser chooser = new JFileChooser();
        String targetName = this.jac.type.getFsName() + "_" + this.jac.productId + "_" + this.jac.serialNumber + span;
        chooser.setSelectedFile(new File(targetName + "_Log.bin"));
        int option = chooser.showSaveDialog(this.getParent());
        if (option != 0) {
            return;
        }
        if (chooser.getSelectedFile().exists()) {
            String msg = "'" + chooser.getSelectedFile().getName() + "' already exists. Overwrite?";
            int response = JOptionPane.showOptionDialog(this.getParent(), msg, "Overwrite existing?", 0, 3, null, new String[]{"Overwrite", "Cancel"}, "Cancel");
            if (response == 1) {
                return;
            }
        }
        AbortableProgressTask<Void> task = new AbortableProgressTask<Void>(this.appState.getRootFrame()){

            @Override
            public Void work() {
                SaveDialog.this.dataStore.export(parent, pars, full, light, chooser.getSelectedFile());
                return null;
            }

            @Override
            public void done(Void result) {
            }

            @Override
            public void aborted() {
                chooser.getSelectedFile().delete();
            }
        };
        task.start("Export.");
        this.dispose();
    }

    private void updateLabels() {
        final Interval full = new Interval(this.fullFrom.getDate().getTime(), this.fullUntil.getDate().getTime());
        final Interval light = new Interval(this.lightFrom.getDate().getTime(), this.lightUntil.getDate().getTime());
        this.fullDuration.setText(FORMATTER.print(full.toPeriod(PeriodType.days())));
        this.lightDuration.setText(FORMATTER.print(light.toPeriod(PeriodType.days())));
        this.sizeLabel.setText(" ");
        if (this.pending != null && !this.pending.isDone()) {
            this.pending.cancel(true);
        }
        final HashSet<String> pars = new HashSet<String>();
        if (this.radioAll.isSelected()) {
            pars.add("");
        } else if (this.radioPlotted.isSelected()) {
            pars.addAll(this.appState.getActivePars());
        }
        this.pending = this.statWorker.submit(new Runnable(){

            @Override
            public void run() {
                float kbytes = 0.0f;
                try {
                    kbytes = SaveDialog.this.dataStore.exportSize(pars, full, light) / 1024L;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                String sizeStr = kbytes > 1024.0f ? String.format("%.1f MB", Float.valueOf(kbytes / 1024.0f)) : String.format("%.0f KB", Float.valueOf(kbytes));
                SaveDialog.this.sizeLabel.setText("<html>Estimated size: " + sizeStr + "</html>");
            }
        });
    }

    private static void nestedSetEnabled(Component component, boolean on) {
        component.setEnabled(on);
        if (component instanceof JPanel) {
            for (Component child : ((JPanel)component).getComponents()) {
                SaveDialog.nestedSetEnabled(child, on);
            }
        }
    }

    private class DurationButton
    extends JButton {
        DurationButton(String label, final Period period, final JDateChooser from, final JDateChooser until) {
            super(label);
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    from.setDate(new DateTime(until.getDate()).minus(period).toDate());
                    SaveDialog.this.updateLabels();
                }
            });
        }
    }
}

