/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import com.google.common.io.ByteStreams;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RowCatInputStream
extends FilterInputStream {
    private final int rowLength;
    private final byte type;
    long offset = 0L;
    private long markedOffset;

    protected RowCatInputStream(InputStream in, byte type, int rowLength, int offset) {
        super(in);
        this.type = type;
        this.rowLength = rowLength;
        this.offset = offset;
    }

    @Override
    public int read() throws IOException {
        if (this.offset % (long)this.rowLength == 0L) {
            this.checkAndSkipHeader();
        }
        int data = this.in.read();
        ++this.offset;
        return data;
    }

    private void checkAndSkipHeader() throws IOException {
        if (this.offset % (long)this.rowLength != 0L) {
            throw new IllegalStateException("Currently not on row end!");
        }
        int type = super.read();
        if (type != this.type) {
            throw new IOException(String.format("Unexpected line-type byte: %d instead of %s at offset %d", type, this.type, this.offset));
        }
        ByteStreams.skipFully(this.in, 4L);
        this.offset += 5L;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int total = 0;
        while (this.offset / (long)this.rowLength < (this.offset + (long)len) / (long)this.rowLength) {
            int target = this.remaining();
            int reached = super.read(b2, off, target);
            this.offset += (long)reached;
            total += reached;
            if (reached < target) {
                return total;
            }
            off += reached;
            len += -reached;
            this.checkAndSkipHeader();
        }
        int reached = super.read(b2, off, len);
        this.offset += (long)reached;
        return total += reached;
    }

    @Override
    public long skip(long len) throws IOException {
        long total = 0L;
        while (this.offset / (long)this.rowLength < (this.offset + len) / (long)this.rowLength) {
            int target = this.remaining();
            long reached = super.skip(target);
            this.offset += reached;
            total += reached;
            if (reached < (long)target) {
                return total;
            }
            len += -reached;
            this.checkAndSkipHeader();
        }
        long reached = super.skip(len);
        this.offset += reached;
        return total += reached;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markedOffset = this.offset;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.offset = this.markedOffset;
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    private int remaining() {
        return (int)((-this.offset + 1L) % (long)this.rowLength - 1L + (long)this.rowLength);
    }

    public long skipToNextRow() throws IOException {
        int remaining = this.remaining();
        ByteStreams.skipFully(this.in, remaining);
        return this.offset + (long)remaining;
    }
}

