/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import com.google.common.base.Objects;
import com.google.common.primitives.Ints;
import java.io.Serializable;

public final class HwClock
implements Comparable<HwClock>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final int ts;

    public HwClock(int ts) {
        if (ts < 0) {
            throw new IllegalArgumentException("Negative HW timestamps cannot be valid.");
        }
        this.ts = ts;
    }

    public HwClock(long ts) {
        this(Ints.checkedCast(ts));
    }

    public HwClock(String ts) {
        this(Integer.parseInt(ts));
    }

    @Override
    public int compareTo(HwClock other) {
        if (this.ts == other.ts) {
            return 0;
        }
        return this.ts > other.ts ? 1 : -1;
    }

    public boolean equals(HwClock o) {
        return o.ts == this.ts;
    }

    public int hashCode() {
        return Objects.hashCode(this.ts);
    }

    public String toString() {
        return String.format("%,d", this.ts);
    }

    public HwClock higher(int dt) {
        return new HwClock((this.ts + dt - 1) / dt * dt);
    }

    public HwClock lower(int dt) {
        return new HwClock(this.ts / dt * dt);
    }
}

