/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CurrentLog;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.data.TimeLine;
import ch.bruker.jac.servicegui.data.TimeMap;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.systems.JacType;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;

public class Heartbeat
implements Runnable {
    private final LoadingCache<CacheKey, Container> cache;
    private final Source source;
    private final TimeLine timeLine;
    private final AppState appState;
    private final TimeMap timeMap;
    private final Pool pool;
    private CurrentLog currentLog;
    private long timeRefSize = 0L;
    private int strikes = 0;

    Heartbeat(LoadingCache<CacheKey, Container> cache, AppState appState, TimeLine timeLine, Source source, TimeMap timeMap, Pool pool) {
        this.cache = cache;
        this.source = source;
        this.timeLine = timeLine;
        this.appState = appState;
        this.timeMap = timeMap;
        this.pool = pool;
        this.currentLog = null;
        for (Tag tag : timeMap.logs.hwClockMap.descendingMap().values()) {
            if (!(tag.getValue() instanceof CurrentLog)) continue;
            this.currentLog = (CurrentLog)tag.getValue();
        }
        try {
            this.timeRefSize = source.current.getSize("time_refs.bin");
        }
        catch (IOException e) {
            SGUtils.log("Could not determine initial time_refs-size.", new Object[0]);
        }
    }

    @Override
    public void run() {
        try {
            int dataSizeDiff;
            long timeRefSize_ = this.source.current.getSize("time_refs.bin");
            boolean requireReindexing = false;
            if (this.currentLog == null) {
                SGUtils.log("No 'current'-logfile. Triggering re-indexing through log rotation\u2026", new Object[0]);
                requireReindexing = true;
            }
            if (!JacType.AV4I_BSMS.equals((Object)this.source.origin.type)) {
                try {
                    this.source.api.requireConnection();
                    this.source.api.ping();
                }
                catch (ApiTalker.RemoteException re) {
                    this.appState.setConnected(false);
                    return;
                }
                if (!this.appState.mode.isInteractive) {
                    if (!this.appState.noTimeServer) {
                        this.source.api.sendGmtTimestamp();
                    }
                    this.source.api.resetBlacklist();
                    if (this.currentLog != null) {
                        this.currentLog.reset(this.source, this.pool);
                    }
                    requireReindexing = true;
                    SGUtils.log("Api reconnected.", new Object[0]);
                }
            }
            if (timeRefSize_ > this.timeRefSize) {
                SGUtils.log("Update: Timerefs.bin", new Object[0]);
                Thread.sleep(1000L);
                this.timeLine.readTimeRefs();
                this.timeLine.updateCoverage();
                this.timeMap.verifyTagMappings();
                this.timeRefSize = timeRefSize_;
            }
            int n = dataSizeDiff = requireReindexing ? -1 : this.currentLog.dataSizeDiff(this.source);
            if (dataSizeDiff > 0) {
                FileTimeTile fileTimeTile = this.timeLine.getCurrent();
                this.cache.refresh(new CacheKey(fileTimeTile, ""));
                if (!this.appState.timeTileLoadOk()) {
                    throw new IOException("Refreshing cache failed - time tile load failed");
                }
            } else if (dataSizeDiff < 0) {
                SGUtils.log("Rotation: Current.bin", new Object[0]);
                Thread.sleep(2000L);
                try {
                    this.timeMap.logs.remove(this.currentLog);
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
                Map<HwClock, Log> map = null;
                do {
                    try {
                        map = this.timeLine.readLogFiles(this.pool);
                    }
                    catch (IllegalStateException e) {
                        SGUtils.log("No data present yet. Retrying in 2s\u2026", new Object[0]);
                        Thread.sleep(2000L);
                    }
                } while (map == null);
                this.timeMap.logs.putAll(map);
                this.timeLine.updateCoverage();
                this.currentLog = null;
                for (Tag tag : this.timeMap.logs.hwClockMap.descendingMap().values()) {
                    if (!(tag.getValue() instanceof CurrentLog)) continue;
                    this.currentLog = (CurrentLog)tag.getValue();
                    this.currentLog.reset(this.source, this.pool);
                    break;
                }
                if (this.currentLog == null) {
                    SGUtils.log("No 'current'-log present after log-rotate. Retry in 5s\u2026", new Object[0]);
                    Thread.sleep(5000L);
                } else if (requireReindexing) {
                    FileTimeTile fileTimeTile = this.timeLine.getCurrent();
                    ImmutableSet<String> params = this.appState.getPerLoggedPars(null);
                    if (params != null) {
                        for (String s : params) {
                            CacheKey key = new CacheKey(fileTimeTile, s);
                            this.cache.invalidate(key);
                        }
                    }
                }
            }
            this.appState.setConnected(true);
            return;
        }
        catch (IOException e) {
            if (!this.appState.isMode(GuiMode.LIVE_DISCONNECTED) && !this.appState.isMode(GuiMode.TRACKING_DISCONNECTED)) {
                SGUtils.log("Lost connection to %s", this.source);
            }
        }
        catch (Exception e) {
            SGUtils.log("Could not refresh live data:", new Object[0]);
            e.printStackTrace();
            ++this.strikes;
        }
        this.appState.setConnected(false);
        try {
            if (this.source.reconnect()) {
                this.strikes = 0;
                SGUtils.log("Reconnected to %s", this.source);
            }
        }
        catch (Source.SourceTerminationException ste) {
            SGUtils.log("Data source terminated. Switching to stand-alone mode\u2026", new Object[0]);
            this.appState.mode = GuiMode.STANDALONE;
            this.appState.updates.post((Object)GuiMode.STANDALONE);
            throw new RuntimeException();
        }
        catch (Exception e) {
            System.out.println("Some other exception:");
            e.printStackTrace();
        }
    }
}

