/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.collections.FailFastHashMap;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.cache.BooleanDescriptor;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.cache.EnumDescriptor;
import ch.bruker.jac.servicegui.data.cache.FixedDescriptor;
import ch.bruker.jac.servicegui.data.cache.FloatDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HeaderParser {
    static Header parse(Pool pool, InputStream in) throws IOException {
        String version = null;
        if (in == null) {
            throw new IOException("Inputstream cannot be null");
        }
        Document doc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(in);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignore) {}
        }
        Element root = doc.getDocumentElement();
        root.normalize();
        NodeList tempNodes = root.getElementsByTagName("hardware_id");
        if (tempNodes.getLength() == 0) {
            throw new RuntimeException("No tag 'hardware_id' found!");
        }
        String hardwareId = tempNodes.item(0).getTextContent();
        tempNodes = root.getElementsByTagName("version");
        if (tempNodes.getLength() > 0) {
            version = tempNodes.item(0).getTextContent();
        }
        if ((tempNodes = root.getElementsByTagName("logline_length")).getLength() == 0) {
            throw new RuntimeException("No tag 'logline_length' found!");
        }
        int rowLength = Integer.valueOf(tempNodes.item(0).getTextContent());
        tempNodes = root.getElementsByTagName("sample_rate");
        int sampleRate = tempNodes.getLength() == 0 ? 0 : Integer.valueOf(tempNodes.item(0).getTextContent());
        TreeMap<Integer, String> collectedGroups = new TreeMap<Integer, String>();
        NodeList groups = root.getElementsByTagName("gui_groups");
        for (int i = 0; i < groups.getLength(); ++i) {
            Node group = groups.item(i);
            FailFastHashMap<String, String> groupMap = HeaderParser.mapElements(group.getChildNodes());
            for (String tag : groupMap.keySet()) {
                if (!tag.startsWith("entry")) continue;
                String label = groupMap.get(tag);
                String[] split = tag.split("#");
                if (split.length != 2) {
                    throw new RuntimeException("Invalid group tag: Bad length");
                }
                int val = Integer.parseInt(split[1]);
                if (collectedGroups.containsKey(val)) {
                    throw new RuntimeException("Duplicate group index in <gui_groups>");
                }
                collectedGroups.put(val, label);
            }
        }
        HashMap<String, Descriptor> collectedDescriptors = new HashMap<String, Descriptor>();
        NodeList pars = root.getElementsByTagName("parameter");
        for (int i = 0; i < pars.getLength(); ++i) {
            Node par = pars.item(i);
            Node typeNode = par.getAttributes().getNamedItem("type");
            if (typeNode == null) {
                throw new RuntimeException("Parameter tag misses type");
            }
            String type = typeNode.getTextContent();
            FailFastHashMap<String, String> parMap = HeaderParser.mapElements(par.getChildNodes());
            Descriptor collectedDescriptor = null;
            if (type.equals("NUMERIC")) {
                collectedDescriptor = parMap.containsKey("floating_point") ? new FloatDescriptor(parMap) : new FixedDescriptor(parMap, version);
            } else if (type.equals("BOOLEAN")) {
                collectedDescriptor = new BooleanDescriptor(parMap);
            } else if (type.equals("ENUM")) {
                collectedDescriptor = new EnumDescriptor(parMap);
            } else {
                throw new RuntimeException("Unrecognized parameter type: " + type);
            }
            collectedDescriptors.put(parMap.get("id"), collectedDescriptor);
        }
        return new Header(pool, collectedDescriptors, new ArrayList<String>(collectedGroups.values()), rowLength, sampleRate);
    }

    private static FailFastHashMap<String, String> mapElements(NodeList elements) {
        FailFastHashMap<String, String> map = new FailFastHashMap<String, String>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node element = elements.item(i);
            if (element.getNodeType() != 1) continue;
            if (element.getChildNodes().getLength() == 1 && element.getChildNodes().item(0).getNodeType() == 3 || element.getChildNodes().getLength() == 0) {
                Node nr;
                String label = element.getNodeName();
                if (element.hasAttributes() && (nr = element.getAttributes().getNamedItem("nr")) != null) {
                    label = label + "#" + nr.getTextContent();
                }
                map.put(label, element.getTextContent());
                continue;
            }
            map.putAll(HeaderParser.mapElements(element.getChildNodes()));
        }
        return map;
    }
}

