/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.collections.PoolingHashMap;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Header
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final Map<String, Descriptor> descriptors;
    protected final Pool pool;
    final int rowLength;
    final int dt;
    private transient Comparator<String> guiGroupOrder;
    private transient Comparator<String> guiParOrder;
    private transient Comparator<String> parseOrder;
    private final ImmutableList<String> groupOrdering;

    public Header(Pool<Descriptor> pool, Map<String, Descriptor> descriptors, List<String> groupOrdering, int rowLength, int dt) {
        PoolingHashMap<String, Descriptor> tempDescriptors = new PoolingHashMap<String, Descriptor>(pool);
        tempDescriptors.putAll(descriptors);
        this.descriptors = Collections.unmodifiableMap(tempDescriptors);
        this.pool = pool;
        this.groupOrdering = ImmutableList.copyOf(groupOrdering);
        this.rowLength = rowLength;
        this.dt = dt;
    }

    protected Header(Header h) {
        this.descriptors = new PoolingHashMap<String, Descriptor>(h.pool);
        this.descriptors.putAll(h.descriptors);
        this.pool = h.pool;
        this.groupOrdering = h.groupOrdering;
        this.rowLength = h.rowLength;
        this.dt = h.dt;
    }

    public int hashCode() {
        return Objects.hashCode(this.descriptors, this.rowLength, this.dt, this.groupOrdering);
    }

    public boolean equals(Object obj) {
        return obj instanceof Header && obj.hashCode() == this.hashCode();
    }

    public Comparator<String> getGuiGroupOrder() {
        this.requireComparators();
        return this.guiGroupOrder;
    }

    public Comparator<String> getGuiParOrder() {
        this.requireComparators();
        return this.guiParOrder;
    }

    public Comparator<String> getParseOrder() {
        this.requireComparators();
        return this.parseOrder;
    }

    private void requireComparators() {
        if (this.guiGroupOrder == null) {
            this.guiGroupOrder = new Comparator<String>(){

                @Override
                public int compare(String leftGroup, String rightGroup) {
                    if (!Header.this.groupOrdering.contains(leftGroup)) {
                        return Header.this.groupOrdering.contains(rightGroup) ? 1 : leftGroup.compareTo(rightGroup);
                    }
                    if (!Header.this.groupOrdering.contains(rightGroup)) {
                        return -1;
                    }
                    return Header.this.groupOrdering.indexOf(leftGroup) - Header.this.groupOrdering.indexOf(rightGroup);
                }
            };
        }
        if (this.guiParOrder == null) {
            this.guiParOrder = new Comparator<String>(){

                @Override
                public int compare(String leftId, String rightId) {
                    Descriptor left = Header.this.descriptors.get(leftId);
                    Descriptor right = Header.this.descriptors.get(rightId);
                    return ComparisonChain.start().compare((Comparable<?>)((Object)left.guiGroupLabel), (Comparable<?>)((Object)right.guiGroupLabel)).compare(left.guiOrder, right.guiOrder).compare((Comparable<?>)((Object)left.name), (Comparable<?>)((Object)right.name)).result();
                }
            };
        }
        if (this.parseOrder == null) {
            this.parseOrder = new Comparator<String>(){

                @Override
                public int compare(String left, String right) {
                    int leftOffset = Header.this.descriptors.containsKey(left) ? Header.this.descriptors.get((Object)left).offset : 0;
                    int rightOffset = Header.this.descriptors.containsKey(right) ? Header.this.descriptors.get((Object)right).offset : 0;
                    return ComparisonChain.start().compare(leftOffset, rightOffset).compare((Comparable<?>)((Object)left), (Comparable<?>)((Object)right)).result();
                }
            };
        }
    }
}

