/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.TimeMap;
import ch.bruker.jac.servicegui.data.TimeTile;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.NullContainer;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Range;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GarbageCollector
implements Runnable {
    private static final boolean LOG = false;
    private static final int RETAIN_USED_TT = 10;
    private final ConcurrentLinkedQueue<FileTimeTile> fullUsages;
    private final ConcurrentLinkedQueue<FileTimeTile> partialUsages;
    private final LoadingCache<CacheKey, Container> cache;
    private final AppState appState;
    private final TimeMap timeMap;
    private boolean invalidateInactivePars = true;
    private Range<HwClock> protectedRange = null;
    FileTimeTile lastFullFtt = null;
    FileTimeTile lastPartialFtt = null;

    GarbageCollector(LoadingCache<CacheKey, Container> cache, AppState appState, TimeMap timeMap) {
        this.cache = cache;
        this.appState = appState;
        this.timeMap = timeMap;
        this.fullUsages = new ConcurrentLinkedQueue();
        this.partialUsages = new ConcurrentLinkedQueue();
    }

    @Override
    public void run() {
        try {
            int evicted = 0;
            int unprocessed = 0;
            int nulls = 0;
            int uncovered = 0;
            int statTile = 0;
            int fullUsed = 0;
            int partUsed = 0;
            while (this.fullUsages.size() > 10) {
                this.fullUsages.poll();
            }
            while (this.partialUsages.size() > 10) {
                this.partialUsages.poll();
            }
            for (Map.Entry entry : this.cache.asMap().entrySet()) {
                CacheKey key = (CacheKey)entry.getKey();
                Container container = (Container)entry.getValue();
                if (key.parId.equals("errordata")) {
                    this.cache.invalidate(key);
                }
                if (key.tt instanceof CacheTimeTile) {
                    ++statTile;
                    continue;
                }
                if (container instanceof NullContainer) {
                    ++nulls;
                    continue;
                }
                if (this.fullUsages.contains(key.tt)) {
                    ++fullUsed;
                    continue;
                }
                if (this.partialUsages.contains(key.tt)) {
                    ++partUsed;
                    continue;
                }
                if (!key.tt.covered()) {
                    ++uncovered;
                    continue;
                }
                if (container.remainingChildren.get() > 0 && (!this.invalidateInactivePars || this.appState.getActivePars().contains(key.parId))) {
                    ++unprocessed;
                    continue;
                }
                if (this.protectedRange != null && this.protectedRange.isConnected(key.tt.span)) continue;
                this.cache.invalidate(key);
                for (Map.Entry entry1 : this.cache.asMap().entrySet()) {
                    CacheKey key1 = (CacheKey)entry1.getKey();
                    if (!key1.tt.equals(key.tt) || !key1.parId.equals("")) continue;
                    this.cache.invalidate(key1);
                }
                ++evicted;
            }
        }
        catch (RuntimeException unexpected) {
            SGUtils.err("Unexpected exception in GC: %s", unexpected.getMessage());
        }
    }

    void registerUncachedFullUsage(TimeTile tt) {
        if (!tt.covered()) {
            return;
        }
        if (tt instanceof CacheTimeTile) {
            return;
        }
        FileTimeTile ftt = (FileTimeTile)tt;
        if (this.lastFullFtt == null || !ftt.equals(this.lastFullFtt)) {
            this.lastFullFtt = ftt;
            this.fullUsages.remove(ftt);
            this.fullUsages.add(ftt);
        }
    }

    void registerUncachedPartialUsage(TimeTile tt) {
        if (!tt.covered()) {
            return;
        }
        if (tt instanceof CacheTimeTile) {
            return;
        }
        FileTimeTile ftt = (FileTimeTile)tt;
        if (this.lastPartialFtt == null || !ftt.equals(this.lastPartialFtt)) {
            this.lastPartialFtt = ftt;
            this.partialUsages.remove(ftt);
            this.partialUsages.add(ftt);
        }
    }

    public void invalidateInactivePars(boolean b2) {
        this.invalidateInactivePars = b2;
    }

    public void protectInterval(Range<HwClock> interval) {
        this.protectedRange = interval;
    }
}

