/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.data.DataStore;
import ch.bruker.util.AbortableProgressTask;
import com.google.common.collect.Range;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ExportCsv
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private final SpinnerNumberModel intervalNumber;
    private final JDateChooser from;
    private final JDateChooser until;
    private final JRadioButton allPars;
    private final JToggleButton seconds;
    private boolean exactFrom = false;
    private boolean exactUntil = false;

    public ExportCsv(final AppState appState, final DataStore dataStore, final Jac jac) {
        super(appState.getRootFrame());
        this.setTitle("CSV Data Export");
        this.setResizable(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setBounds(100, 100, 300, 417);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(6);
        borderLayout.setHgap(5);
        this.getContentPane().setLayout(borderLayout);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "North");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[]{250, 0};
        gbl_contentPanel.rowHeights = new int[]{20, 50, 0, 50, 0};
        gbl_contentPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl_contentPanel);
        JLabel intro = new JLabel("<html>Export data as comma-separated values.<br>This may produce huge files. </html>");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 10, 5, 9);
        gbc.ipady = 20;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.contentPanel.add((Component)intro, gbc);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Parameter Set", 4, 2, null, new Color(0, 0, 0)));
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.contentPanel.add((Component)panel, gbc);
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{200, 0};
        layout.rowHeights = new int[]{0, 0, 0};
        layout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(layout);
        ButtonGroup parGroup = new ButtonGroup();
        GridBagConstraints gbc_ = new GridBagConstraints();
        gbc_.fill = 2;
        gbc_.insets = new Insets(10, 20, 5, 0);
        gbc_.gridx = 0;
        gbc_.gridy = 0;
        int count = appState.getActivePars().size();
        JRadioButton selectedPars = new JRadioButton("Selected only (" + count + " Parameters)");
        selectedPars.setSelected(true);
        parGroup.add(selectedPars);
        panel.add((Component)selectedPars, gbc_);
        gbc_ = new GridBagConstraints();
        gbc_.fill = 2;
        gbc_.insets = new Insets(0, 20, 10, 0);
        gbc_.gridx = 0;
        gbc_.gridy = 1;
        count = appState.getPerLoggedPars(null).size();
        this.allPars = new JRadioButton("All parameters (" + count + " Parameters)");
        parGroup.add(this.allPars);
        panel.add((Component)this.allPars, gbc_);
        panel = new JPanel();
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Time Range", 4, 2, null, new Color(0, 0, 0)));
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.contentPanel.add((Component)panel, gbc);
        layout = new GridBagLayout();
        layout.columnWidths = new int[]{120, 0, 120, 0};
        layout.rowHeights = new int[]{0, 0, 0};
        layout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(layout);
        this.from = new JDateChooser(appState.getTimeLineEnd().minus(Period.days(10)).withTime(0, 0, 0, 0).toDate());
        this.from.getDateEditor().addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!ExportCsv.this.exactFrom && evt.getNewValue() instanceof Date) {
                    DateTime dt = new DateTime(evt.getNewValue());
                    dt = dt.withTime(0, 0, 0, 0);
                    ExportCsv.this.from.setDate(dt.toDate());
                } else {
                    ExportCsv.this.exactFrom = false;
                }
            }
        });
        GridBagConstraints gbc_2 = new GridBagConstraints();
        gbc_2.fill = 2;
        gbc_2.insets = new Insets(10, 20, 10, 0);
        gbc_2.gridx = 0;
        gbc_2.gridy = 0;
        panel.add((Component)this.from, gbc_2);
        JLabel lblUntil = new JLabel("\u2026");
        GridBagConstraints gbc__ = new GridBagConstraints();
        gbc__.insets = new Insets(10, 0, 10, 0);
        gbc__.gridx = 1;
        gbc__.gridy = 0;
        panel.add((Component)lblUntil, gbc__);
        this.until = new JDateChooser(appState.getTimeLineEnd().withTime(23, 59, 59, 999).toDate());
        this.until.getDateEditor().addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!ExportCsv.this.exactUntil && evt.getNewValue() instanceof Date) {
                    DateTime dt = new DateTime(evt.getNewValue());
                    dt = dt.withTime(23, 59, 59, 999);
                    ExportCsv.this.until.setDate(dt.toDate());
                } else {
                    ExportCsv.this.exactUntil = false;
                }
            }
        });
        GridBagConstraints gbc_dateChooser = new GridBagConstraints();
        gbc_dateChooser.fill = 2;
        gbc_dateChooser.insets = new Insets(10, 0, 10, 20);
        gbc_dateChooser.gridx = 2;
        gbc_dateChooser.gridy = 0;
        panel.add((Component)this.until, gbc_dateChooser);
        JButton visibleRangeBtn = new JButton("Visible Range");
        visibleRangeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCsv.this.exactFrom = true;
                ExportCsv.this.from.setDate(appState.getScope().getStart().toDate());
                ExportCsv.this.exactUntil = true;
                ExportCsv.this.until.setDate(appState.getScope().getEnd().toDate());
            }
        });
        JButton fullRangeBtn = new JButton("Full Range");
        fullRangeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Range<DateTime> span = appState.getCoverage().span();
                ExportCsv.this.from.setDate(span.lowerEndpoint().toDate());
                ExportCsv.this.until.setDate(span.upperEndpoint().toDate());
            }
        });
        GridBagConstraints gbc___ = new GridBagConstraints();
        gbc___.fill = 2;
        gbc___.insets = new Insets(0, 20, 10, 0);
        gbc___.gridx = 0;
        gbc___.gridy = 1;
        panel.add((Component)fullRangeBtn, gbc___);
        GridBagConstraints gbc____ = new GridBagConstraints();
        gbc____.fill = 2;
        gbc____.insets = new Insets(0, 0, 10, 20);
        gbc____.gridx = 2;
        gbc____.gridy = 1;
        panel.add((Component)visibleRangeBtn, gbc____);
        panel = new JPanel();
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Sampling Interval", 4, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 10, 0, 0);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 3;
        this.contentPanel.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{86, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JSpinner spinner = new JSpinner();
        this.intervalNumber = new SpinnerNumberModel((Number)30, Integer.valueOf(1), null, (Number)1);
        spinner.setModel(this.intervalNumber);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.insets = new Insets(10, 20, 10, 5);
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        panel.add((Component)spinner, gbc2);
        JPanel flow = new JPanel();
        gbc2 = new GridBagConstraints();
        gbc2.anchor = 13;
        gbc2.insets = new Insets(10, 0, 10, 20);
        gbc2.fill = 3;
        gbc2.gridx = 1;
        gbc2.gridy = 0;
        panel.add((Component)flow, gbc2);
        flow.setLayout(new FlowLayout(1, 0, 0));
        ButtonGroup unitGroup = new ButtonGroup();
        this.seconds = new JToggleButton("seconds");
        this.seconds.setSelected(true);
        unitGroup.add(this.seconds);
        flow.add(this.seconds);
        JToggleButton days = new JToggleButton("days");
        unitGroup.add(days);
        flow.add(days);
        JPanel flow2 = new JPanel();
        flow2.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)flow2, "South");
        JButton okButton = new JButton("Export CSV");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<Object> pars = new HashSet();
                pars = ExportCsv.this.allPars.isSelected() ? appState.getPerLoggedPars(null) : appState.getActivePars();
                final Interval range = new Interval(ExportCsv.this.from.getDate().getTime(), ExportCsv.this.until.getDate().getTime());
                final Duration interval = ExportCsv.this.seconds.isSelected() ? Duration.standardSeconds(ExportCsv.this.intervalNumber.getNumber().longValue()) : Duration.standardDays(ExportCsv.this.intervalNumber.getNumber().longValue());
                final JFileChooser chooser = new JFileChooser();
                DateTimeFormatter f = DateTimeFormat.forPattern("yyyyMMdd");
                String span = "_" + f.print(range.getStart()) + "_" + f.print(range.getEnd());
                String targetName = jac.type.getFsName() + "_" + jac.productId + "_" + jac.serialNumber + span + ".csv";
                chooser.setSelectedFile(new File(targetName));
                int option = chooser.showSaveDialog(ExportCsv.this.getParent());
                if (option != 0) {
                    return;
                }
                if (chooser.getSelectedFile().exists()) {
                    String msg = "'" + chooser.getSelectedFile().getName() + "' already exists. Overwrite?";
                    int response = JOptionPane.showOptionDialog(ExportCsv.this.getParent(), msg, "Overwrite existing?", 0, 3, null, new String[]{"Overwrite", "Cancel"}, "Cancel");
                    if (response == 1) {
                        return;
                    }
                }
                final Set<Object> finalPars = pars;
                new AbortableProgressTask<Void>(appState.getRootFrame()){

                    @Override
                    public void aborted() {
                    }

                    @Override
                    public Void work() {
                        dataStore.exportCsv(finalPars, range, false, interval, chooser.getSelectedFile());
                        return null;
                    }

                    @Override
                    public void done(Void result) {
                    }
                }.start("");
                ExportCsv.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        flow2.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

