/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.EventData;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.RowCatInputStream;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.TimeMapping;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.cache.NullContainer;
import com.google.common.collect.Range;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeRangeMap;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.joda.time.DateTimeZone;

class Demuxer {
    private static final int INITIAL_CONTAINER_SIZE = 256;
    private static final int BUFFER_SIZE = 131072;
    private static boolean DEBUG_ROW_TYPES = false;
    private final Set<String> absent;
    private final Header header;
    private DataInputStream in;
    private boolean parsingComplete = false;
    private HashMap<String, Container> perContainers;
    private TreeSet<String> perLogged;
    private int perLoggedRowCount = 0;
    private TreeMap<HwClock, String> systemInfo;
    private TreeMultimap<HwClock, String> errors;
    private TreeRangeMap<HwClock, TimeMapping> timeMappings;
    private TreeSet<String> evtLogged;
    private final SortedMap<String, Container> errorContainers;
    private final HashMap<String, Container> evtContainers;
    private final List<HwClock> logEvents = new LinkedList<HwClock>();
    private final List<HwClock> errorLogEvents = new LinkedList<HwClock>();
    private int samplePeriod = -1;
    private long streamPosition = 0L;
    private HwClock firstPeriodicData;
    private HwClock lastPeriodicData;
    static byte[] buf = new byte[256];

    Demuxer(Header header, InputStream in) {
        this.header = header;
        this.in = new DataInputStream(new BufferedInputStream(in, 131072));
        this.perContainers = new HashMap();
        this.evtContainers = new HashMap();
        this.errorContainers = new TreeMap<String, Container>(header.getParseOrder());
        this.perLogged = new TreeSet<String>(header.getParseOrder());
        this.evtLogged = new TreeSet<String>(header.getParseOrder());
        for (Map.Entry<String, Descriptor> entry : header.descriptors.entrySet()) {
            Descriptor descriptor = entry.getValue();
            if (descriptor == null) continue;
            if (descriptor.eventLogged) {
                this.evtLogged.add(descriptor.id);
                this.evtContainers.put(descriptor.id, descriptor.createContainer(1, true));
                continue;
            }
            this.errorContainers.put(descriptor.id, descriptor.createContainer(1, true));
        }
        this.absent = new HashSet<String>();
        this.systemInfo = new TreeMap();
        this.errors = TreeMultimap.create();
        this.timeMappings = TreeRangeMap.create();
    }

    public void reattach(InputStream in) throws IOException {
        this.in = new DataInputStream(new BufferedInputStream(in));
        Demuxer.skipFully(in, this.streamPosition);
    }

    public Demuxer extract(String par) {
        Descriptor descriptor = this.header.descriptors.get(par);
        if (descriptor == null) {
            this.absent.add(par);
            return this;
        }
        if (descriptor.offset < 0) {
            return this;
        }
        if (!descriptor.eventLogged && !this.perLogged.contains(par)) {
            this.perContainers.put(par, descriptor.createContainer(256, true));
            this.perLogged.add(par);
        }
        return this;
    }

    public HwClock run() throws IOException {
        this.lastPeriodicData = null;
        TimeMapping timeMapping = null;
        HwClock timeMappingStart = null;
        String error = null;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                byte rowType;
                boolean isAbsolute = false;
                try {
                    rowType = this.in.readByte();
                }
                catch (EOFException ignore) {
                    break;
                }
                HwClock timestamp = new HwClock(this.in.readInt());
                int cursor = 5;
                if (DEBUG_ROW_TYPES) {
                    SGUtils.log("%x @ %s", rowType, timestamp);
                }
                switch (rowType) {
                    case 0: {
                        isAbsolute = true;
                    }
                    case 1: {
                        ++this.perLoggedRowCount;
                        for (String par : this.perLogged) {
                            Descriptor descriptor = this.header.descriptors.get(par);
                            Demuxer.skipFully(this.in, descriptor.offset - cursor);
                            cursor = descriptor.offset;
                            cursor += this.perContainers.get(par).appendStream(this.in, isAbsolute);
                        }
                        if (this.lastPeriodicData == null) {
                            this.firstPeriodicData = timestamp;
                            this.lastPeriodicData = timestamp;
                            break;
                        }
                        if (this.samplePeriod == -1) {
                            this.samplePeriod = timestamp.ts - this.lastPeriodicData.ts;
                        }
                        if (this.samplePeriod != timestamp.ts - this.lastPeriodicData.ts) {
                            // empty if block
                        }
                        this.lastPeriodicData = timestamp;
                        break;
                    }
                    case 17: {
                        if (this.evtLogged.isEmpty()) break;
                        throw new IllegalStateException("Event-based data row continuation without beginning!");
                    }
                    case 16: {
                        this.logEvents.add(timestamp);
                        RowCatInputStream wrapped = new RowCatInputStream(this.in, 17, this.header.rowLength, cursor);
                        DataInputStream double_trouble = new DataInputStream(wrapped);
                        for (String par : this.evtLogged) {
                            Descriptor descriptor = this.header.descriptors.get(par);
                            if (descriptor == null) {
                                this.evtContainers.get(par).appendVoid(1);
                                continue;
                            }
                            Demuxer.skipFully(wrapped, descriptor.offset - cursor);
                            cursor = descriptor.offset;
                            cursor += this.evtContainers.get(par).appendStream(double_trouble, true);
                        }
                        long consumed = wrapped.skipToNextRow();
                        cursor = this.header.rowLength;
                        this.streamPosition += consumed - (long)this.header.rowLength;
                        break;
                    }
                    case -21: {
                        this.errorLogEvents.add(timestamp);
                        for (String par : this.errorContainers.keySet()) {
                            Descriptor descriptor = this.header.descriptors.get(par);
                            Demuxer.skipFully(this.in, descriptor.offset - cursor);
                            cursor = descriptor.offset;
                            cursor += ((Container)this.errorContainers.get(par)).appendStream(this.in, true);
                        }
                        break;
                    }
                    case -31: {
                        if (!this.errors.containsKey(timestamp)) {
                            throw new IllegalStateException("Error line continuation without beginning.");
                        }
                        this.errors.remove(timestamp, error);
                        String error_ = error + this.readString(this.header.rowLength - cursor);
                        cursor = this.header.rowLength;
                        this.errors.put((Object)timestamp, (Object)error_);
                        error = error_;
                        break;
                    }
                    case -32: {
                        error = this.readString(this.header.rowLength - cursor);
                        cursor = this.header.rowLength;
                        this.errors.put((Object)timestamp, (Object)error);
                        break;
                    }
                    case -47: {
                        if (this.systemInfo.get(timestamp) == null) {
                            throw new IllegalStateException("System info line continuation without beginning.");
                        }
                    }
                    case -48: {
                        String info = this.readString(this.header.rowLength - cursor);
                        cursor = this.header.rowLength;
                        if (this.systemInfo.get(timestamp) != null) {
                            info = this.systemInfo.get(timestamp).concat(info);
                        }
                        this.systemInfo.put(timestamp, info);
                        break;
                    }
                    case -16: {
                        ++cursor;
                        switch (this.in.readByte()) {
                            case 2: {
                                if (timeMapping != null) {
                                    int len = timestamp.ts - timeMappingStart.ts;
                                    if (len > 0) {
                                        this.timeMappings.put(Range.closed(timeMappingStart, timestamp), timeMapping);
                                    }
                                    timeMapping.fit();
                                }
                                timeMapping = TimeMapping.empty();
                                timeMappingStart = timestamp;
                            }
                        }
                        break;
                    }
                    case -1: {
                        DateTimeZone timeZone;
                        long millis = this.in.readLong();
                        cursor += 8;
                        String id = this.readString(32).trim();
                        cursor += 32;
                        try {
                            timeZone = DateTimeZone.forTimeZone(TimeZone.getTimeZone(id));
                        }
                        catch (IllegalArgumentException iae) {
                            System.err.printf("Unknown time zone. Assuming UTC. Message: %s \n", iae.getMessage());
                            timeZone = DateTimeZone.UTC;
                        }
                        if (timeMapping == null) {
                            throw new IllegalStateException("Time reference before startup! What to do?");
                        }
                        timeMapping.addTimeAnchor(timestamp, millis, timeZone);
                        break;
                    }
                }
                Demuxer.skipFully(this.in, this.header.rowLength - cursor);
                this.streamPosition += (long)this.header.rowLength;
            }
            if (timeMapping != null) {
                this.timeMappings.put(Range.atLeast(timeMappingStart), timeMapping);
                timeMapping.fit();
            }
        }
        catch (EOFException e) {
            throw new IOException("Premature file end. " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("IOE during demuxing: " + e.getMessage());
        }
        try {
            this.in.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        for (String par : this.perLogged) {
            if (this.perContainers.get(par).fit() == this.perLoggedRowCount) continue;
            throw new RuntimeException("Inconsistent row count.");
        }
        for (String par : this.absent) {
            this.perContainers.put(par, new NullContainer(this.perLoggedRowCount));
        }
        if (this.samplePeriod == 0) {
            throw new IllegalStateException("Sample rate of 0 makes no sense.");
        }
        this.parsingComplete = true;
        return this.firstPeriodicData;
    }

    private String readString(int length) throws IOException {
        byte[] buffer = new byte[length];
        this.in.readFully(buffer);
        return new String(buffer, "UTF-8").replaceAll("\\s\\s+$", "");
    }

    public HashMap<String, Container> getContainers() {
        this.checkComplete();
        return this.perContainers;
    }

    public TreeMap<HwClock, String> getSystemInfo() {
        this.checkComplete();
        return this.systemInfo;
    }

    public TreeMultimap<HwClock, String> getErrors() {
        this.checkComplete();
        return this.errors;
    }

    public TreeRangeMap<HwClock, TimeMapping> getTimeMappings() {
        this.checkComplete();
        return this.timeMappings;
    }

    public SortedMap<HwClock, EventData> getEventData() {
        this.checkComplete();
        TreeMap<HwClock, EventData> ret = new TreeMap<HwClock, EventData>();
        int step = 1;
        if (this.logEvents.size() > 500 && this.logEvents.size() > this.perLoggedRowCount / 2 || this.logEvents.size() > 5000) {
            SGUtils.err("Anomaly in Logfile %s: Excessive number of events (%d)", this.firstPeriodicData, this.logEvents.size());
            step = this.logEvents.size() / 500;
        }
        EventData eventData_ = null;
        for (int i = 0; i < this.logEvents.size(); i += step) {
            EventData eventData = new EventData();
            for (String par : this.evtLogged) {
                Container c2 = this.evtContainers.get(par);
                Sample s = c2.getSample(i, 1);
                eventData.put(par, s);
            }
            if (eventData.equals(eventData_)) {
                eventData = eventData_;
            }
            ret.put(this.logEvents.get(i), eventData);
            eventData_ = eventData;
        }
        return ret;
    }

    public SortedMap<HwClock, EventData> getErrorData() {
        this.checkComplete();
        TreeMap<HwClock, EventData> ret = new TreeMap<HwClock, EventData>();
        try {
            for (int i = 0; i < this.errorLogEvents.size(); ++i) {
                EventData eventData = new EventData();
                for (Map.Entry<String, Container> entry : this.errorContainers.entrySet()) {
                    Sample s = entry.getValue().getSample(i, 1);
                    eventData.put(entry.getKey(), s);
                }
                ret.put(this.errorLogEvents.get(i), eventData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void checkComplete() {
        if (!this.parsingComplete) {
            throw new IllegalStateException("Demuxer has not been run yet.");
        }
    }

    int getSamplePeriod() {
        return this.samplePeriod;
    }

    HwClock getEdge() {
        return this.lastPeriodicData;
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        long skipped;
        if (n > 0L && (skipped = Demuxer.skipUpTo(in, n)) < n) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n + " bytes expected");
        }
    }

    static long skipUpTo(InputStream in, long n) throws IOException {
        int skip;
        long remaining;
        long totalSkipped;
        long skipped;
        for (totalSkipped = 0L; totalSkipped < n && ((skipped = Demuxer.skipSafely(in, remaining = n - totalSkipped)) != 0L || (skipped = (long)in.read(buf, 0, skip = (int)Math.min(remaining, (long)buf.length))) != -1L); totalSkipped += skipped) {
        }
        return totalSkipped;
    }

    private static long skipSafely(InputStream in, long n) throws IOException {
        int available = in.available();
        return available == 0 ? 0L : in.skip(Math.min((long)available, n));
    }
}

