/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.NamedThreadFactory;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.ArchiveLog;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CacheTaskConsumer;
import ch.bruker.jac.servicegui.data.CacheTaskProducer;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.CacheVisualizer;
import ch.bruker.jac.servicegui.data.ContainerFactory;
import ch.bruker.jac.servicegui.data.ContinuousSample;
import ch.bruker.jac.servicegui.data.CurrentLog;
import ch.bruker.jac.servicegui.data.DiscreteSample;
import ch.bruker.jac.servicegui.data.EventData;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.GarbageCollector;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.Heartbeat;
import ch.bruker.jac.servicegui.data.HighResTriggerTask;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.MetaPar;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.data.TimeLine;
import ch.bruker.jac.servicegui.data.TimeMap;
import ch.bruker.jac.servicegui.data.TimeServer;
import ch.bruker.jac.servicegui.data.TimeTile;
import ch.bruker.jac.servicegui.data.UsbFlashWritingAllowedTask;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.cache.EnumDescriptor;
import ch.bruker.jac.servicegui.data.cache.FixedDescriptor;
import ch.bruker.jac.servicegui.data.cache.NullContainer;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.util.AbortableProgressTask;
import ch.bruker.util.BUtil;
import ch.bruker.util.JOptionPaneTB;
import ch.bruker.util.ProgressTask;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.common.eventbus.EventBus;
import com.google.common.io.ByteStreams;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DataStore {
    private static final boolean DEBUG_TIMETILES = false;
    private static final String SYS_MSG_1 = "jac.log";
    private static final String SYS_MSG_2 = "SystemMessages.log";
    private static final String CACHE_ON_DISK_FILENAME = "digest.zip";
    private final Pool pool;
    public TimeLine timeLine;
    private final GarbageCollector garbageCollector;
    private final ContainerFactory factory;
    private final EventBus bus;
    private final ScheduledExecutorService cronjobs;
    public final CacheTaskConsumer queueConsumer;
    public final CacheTaskProducer queueProducer;
    private final Source source;
    public CacheVisualizer cacheVisualizer;
    public TimeMap timeMap;
    LoadingCache<CacheKey, Container> containerCache;
    private int forcedDt = 0;
    private final Cache<FileTimeTile, SortedMap<HwClock, EventData>> errorDataCache;
    private boolean timeTileLoadOk = true;

    public DataStore(AppState appState, Source source) {
        this(appState, source, true);
    }

    public DataStore(AppState appState, Source source, boolean loadCache) {
        this.source = source;
        this.bus = appState.updates;
        this.timeMap = new TimeMap();
        this.timeLine = new TimeLine(source, appState);
        final ScheduledExecutorService delayedAnnouncer = Executors.newSingleThreadScheduledExecutor();
        this.containerCache = CacheBuilder.newBuilder().build(new CacheLoader<CacheKey, Container>(){

            @Override
            public Container load(CacheKey key) throws Exception {
                Map<CacheKey, Container> loaded = this.loadAll((Iterable<? extends CacheKey>)Collections.singleton(key));
                if (loaded.get(key) == null) {
                    return new NullContainer(0);
                }
                return loaded.get(key);
            }

            @Override
            public Map<CacheKey, Container> loadAll(Iterable<? extends CacheKey> keys) throws Exception {
                HashMultimap ttMap = HashMultimap.create();
                HashMap<CacheKey, Container> ret = new HashMap<CacheKey, Container>();
                final LinkedList<CacheUpdate> updates = new LinkedList<CacheUpdate>();
                for (CacheKey cacheKey : keys) {
                    ttMap.put(cacheKey.tt, cacheKey.parId);
                }
                for (TimeTile timeTile : ttMap.keySet()) {
                    Set pars = ttMap.get(timeTile);
                    Map<String, Container> containers = timeTile.dispatchLoad(DataStore.this.factory, pars);
                    DataStore.this.timeTileLoadOk = true;
                    if (containers == null) {
                        SGUtils.err("Failed to load %s for %d pars.", timeTile, pars.size());
                        DataStore.this.timeTileLoadOk = false;
                        return ret;
                    }
                    if (containers.size() < pars.size()) {
                        SGUtils.log("Got a bit less when parsing %s: %d instead %d pars.", timeTile, containers.size(), pars.size());
                    }
                    for (Map.Entry<String, Container> entry : containers.entrySet()) {
                        Container container = entry.getValue();
                        CacheKey key = new CacheKey(timeTile, entry.getKey());
                        container.remainingChildren = new AtomicInteger(DataStore.this.countAbsentChildren(key));
                        ret.put(key, container);
                    }
                    Interval span = DataStore.this.timeLine.toInterval(timeTile.span);
                    if (span.toDurationMillis() == 0L) continue;
                    updates.add(new CacheUpdate(timeTile, span, pars));
                }
                delayedAnnouncer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        for (CacheUpdate u : updates) {
                            DataStore.this.bus.post(u);
                        }
                    }
                }, 100L, TimeUnit.MILLISECONDS);
                return ret;
            }
        });
        File digest = new File(source.localCache.getAbsolutePath(), CACHE_ON_DISK_FILENAME);
        if (!digest.exists()) {
            digest = this.archivedDigestAsLocalFile();
        }
        Pool pool_ = new Pool();
        if (!loadCache) {
            SGUtils.log("Starting without cache.", new Object[0]);
        } else if (digest == null || !digest.exists()) {
            SGUtils.log("No cache digest present.", new Object[0]);
        } else {
            ZipFile diskCacheZip = null;
            try {
                diskCacheZip = new ZipFile(digest);
                SGUtils.log("Loading disk cache\u2026", new Object[0]);
                try {
                    pool_ = (Pool)this.loadFromZip(diskCacheZip, "Pool.ser");
                }
                catch (Exception ignore) {
                    throw new IllegalStateException("Could not load cached descriptors");
                }
                try {
                    HashMap map = (HashMap)this.loadFromZip(diskCacheZip, "Containers.ser");
                    this.containerCache.putAll(map);
                    for (Map.Entry entry : map.entrySet()) {
                        CacheKey key = (CacheKey)entry.getKey();
                        this.timeLine.timeTiles.add(key.tt);
                        this.timeLine.cacheCoverage.span(key.tt.backedSpan());
                        if (key.tt.span != null) continue;
                        throw new IllegalStateException("Deserialized TT has null-y span: " + key.tt);
                    }
                    for (FileTimeTile tt : this.timeLine.fileTimeTiles()) {
                        this.timeLine.fileCoverage.add(tt.span);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Could not load cached data-containers");
                }
                try {
                    this.timeMap = (TimeMap)this.loadFromZip(diskCacheZip, "TimeMap.ser");
                }
                catch (Exception ignore) {
                    throw new IllegalStateException("Could not load cached time map");
                }
                SGUtils.log("Cache restored.", new Object[0]);
            }
            catch (IOException e) {
                SGUtils.log("Could not load cache digest. Continuing without.", new Object[0]);
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    SGUtils.err("Cannot load cache digest due to limited stack size. Consider increasing the JVM stack size by adding \"-Xss\u2026\" as argument!", new Object[0]);
                } else {
                    SGUtils.log("Could not restore cache: %s", e.getMessage());
                }
                SGUtils.log("The cache is flushed and re-generated.", new Object[0]);
                try {
                    diskCacheZip.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                digest.delete();
                this.containerCache.invalidateAll();
                this.timeLine.clear();
                this.timeMap.clear();
            }
        }
        this.pool = pool_;
        this.timeMap.bindTimeLine(this.timeLine);
        this.timeLine.readTimeRefs();
        for (Map.Entry<HwClock, Log> entry : this.timeLine.readLogFiles(this.pool).entrySet()) {
            HwClock hwClock = entry.getKey();
            Log log = entry.getValue();
            Tag<Log> present = this.timeMap.logs.get(hwClock);
            if (present != null) {
                log.header = present.getValue().header;
            }
            this.timeMap.logs.put(hwClock, log);
        }
        this.timeLine.updateCoverage();
        this.timeMap.verifyTagMappings();
        this.errorDataCache = CacheBuilder.newBuilder().maximumSize(5L).build();
        this.factory = new ContainerFactory(this.containerCache, this.errorDataCache, source, this.timeMap, appState, this.pool);
        this.cronjobs = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Cronjob"));
        this.queueProducer = new CacheTaskProducer(this.containerCache, appState);
        this.cronjobs.scheduleWithFixedDelay(this.queueProducer.scheduledReordering, 0L, 1L, TimeUnit.SECONDS);
        appState.updates.register(this.queueProducer);
        this.queueConsumer = new CacheTaskConsumer(this.containerCache, this.queueProducer);
        this.cronjobs.scheduleWithFixedDelay(this.queueConsumer, 0L, 100L, TimeUnit.MILLISECONDS);
        appState.updates.register(this.queueConsumer);
        this.garbageCollector = new GarbageCollector(this.containerCache, appState, this.timeMap);
        this.cronjobs.scheduleWithFixedDelay(this.garbageCollector, 1000L, 500L, TimeUnit.MILLISECONDS);
        this.cacheVisualizer = new CacheVisualizer(this, appState, this.queueProducer);
        this.cronjobs.scheduleWithFixedDelay(this.cacheVisualizer, 500L, 200L, TimeUnit.MILLISECONDS);
        boolean AVI4_BSMS = JacType.AV4I_BSMS.equals((Object)source.origin.type);
        if (AVI4_BSMS || source.api != null) {
            Heartbeat heartbeat = new Heartbeat(this.containerCache, appState, this.timeLine, source, this.timeMap, this.pool);
            this.cronjobs.scheduleWithFixedDelay(heartbeat, 500L, 500L, TimeUnit.MILLISECONDS);
        }
        if (source.api != null) {
            if (!appState.noTimeServer) {
                this.cronjobs.scheduleAtFixedRate(new TimeServer(source.api, this.timeLine), 0L, 10L, TimeUnit.HOURS);
            }
            this.cronjobs.scheduleAtFixedRate(new HighResTriggerTask(source.api), 5L, 30L, TimeUnit.SECONDS);
            this.cronjobs.scheduleAtFixedRate(new UsbFlashWritingAllowedTask(source.api, appState), 0L, 2L, TimeUnit.SECONDS);
        }
    }

    private File archivedDigestAsLocalFile() {
        if (!this.source.archives.ls().contains(CACHE_ON_DISK_FILENAME)) {
            return null;
        }
        try {
            File tmp = File.createTempFile("digest", ".zip");
            FileOutputStream to = new FileOutputStream(tmp);
            ByteStreams.copy(this.source.archives.open(CACHE_ON_DISK_FILENAME), to);
            to.close();
            return tmp;
        }
        catch (IOException ignore) {
            SGUtils.log("Could not import cache digest.", new Object[0]);
            return null;
        }
    }

    public long exportSize(Set<String> pars, Interval full, Interval light) throws IOException {
        float zRawLog = 0.55f;
        float zContainers = 0.038f;
        float zTimeMap = 0.04f;
        float zCurrData = 0.022f;
        float zCurrHead = 0.07f;
        if (pars == null) {
            pars = this.timeMap.logs.getLast().getValue().getHeader((Source)this.source, (Pool)this.pool).descriptors.keySet();
        }
        long size = 0L;
        for (Tag<Log> logTag : this.timeMap.logs.get(full)) {
            if (logTag.getValue() instanceof CurrentLog) continue;
            String filename = ((ArchiveLog)logTag.getValue()).filename;
            try {
                size = (long)((float)size + (float)this.source.archives.getSize(filename) * zRawLog);
            }
            catch (IOException e) {
                SGUtils.log("Could not determine size of %s.", filename);
            }
        }
        try {
            size = (long)((float)size + zCurrData * (float)this.source.current.getSize("Current.bin"));
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            size = (long)((float)size + zCurrHead * (float)this.source.current.getSize("Current.xml"));
        }
        catch (IOException ignore) {
            // empty catch block
        }
        for (String par : pars) {
            for (CacheTimeTile tt : this.timeLine.cacheTimeTiles().withDt(60)) {
                Tag<Log> tag = this.timeMap.logs.getLower((HwClock)tt.span.lowerEndpoint());
                Descriptor d = tag == null || tag.getValue().header == null ? this.timeMap.logs.getLast().getValue().header.descriptors.get(par) : tag.getValue().header.descriptors.get(par);
                if (d == null) continue;
                size = (long)((float)size + (float)(tt.length() * d.byteSize) * zContainers);
            }
        }
        size = (long)((float)size + (float)SGUtils.sizeOf(this.timeMap) * zTimeMap);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Component parent, Set<String> pars, Interval full, Interval light, File target) {
        AbortableProgressTask.update("Exporting log\u2026");
        Range<HwClock> digestSpan = null;
        if (light != null) {
            digestSpan = this.timeLine.toHwClock(light);
            for (CacheTimeTile tt : this.timeLine.cacheTimeTiles().in(light).withDt(60)) {
                if (pars.contains("")) {
                    this.queueProducer.requestKey(new CacheKey(tt, ""));
                    continue;
                }
                for (String par : pars) {
                    CacheKey key = new CacheKey(tt, par);
                    if (this.containerCache.asMap().containsKey(key)) continue;
                    this.queueProducer.requestKey(key);
                }
            }
        }
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
            Jac jac = this.source.origin;
            String dir = jac.productId + "_" + jac.serialNumber + "_" + DateTime.now().getMillis() + "/";
            Collection<String> lsContents = this.source.sysMsg.ls();
            if (lsContents.contains(SYS_MSG_1) || lsContents.contains(SYS_MSG_2)) {
                out.putNextEntry(new ZipEntry(dir + SYS_MSG_2));
                ByteStreams.copy(new FileInputStream(this.getSysMsg()), out);
            }
            dir = dir + "system_logs/";
            out.putNextEntry(new ZipEntry(dir + "time_refs.bin"));
            ByteStreams.copy(this.source.current.open("time_refs.bin"), out);
            this.garbageCollector.invalidateInactivePars(false);
            try {
                this.queueProducer.processRequests();
                AbortableProgressTask.update("Writing data\u2026");
                out.putNextEntry(new ZipEntry(dir + CACHE_ON_DISK_FILENAME));
                this.writeDigest(pars, digestSpan, out);
            }
            finally {
                this.queueProducer.reset();
                this.queueProducer.reorder();
                this.garbageCollector.invalidateInactivePars(true);
            }
            if (this.timeLine.getCurrent() != null) {
                Interval currentRange = TimeLine.m(this.timeLine.toDateTime(this.timeLine.getCurrent().span));
                if (full != null && full.overlaps(currentRange)) {
                    out.putNextEntry(new ZipEntry(dir + "Current.xml"));
                    ByteStreams.copy(this.source.current.open("Current.xml"), out);
                    out.putNextEntry(new ZipEntry(dir + "Current.bin"));
                    try {
                        ByteStreams.copy(this.source.current.open("Current.bin"), out);
                    }
                    finally {
                        this.source.current.release();
                    }
                }
            }
            HashSet<Tag<Log>> fullLogs = new HashSet<Tag<Log>>();
            if (light != null) {
                HwClock cacheEnd = this.timeLine.cacheCoverage.upperEndpoint();
                Range<HwClock> range = Range.greaterThan(cacheEnd);
                Range<HwClock> requested = range.intersection(this.timeLine.toHwClock(light));
                fullLogs.addAll(this.timeMap.logs.get(requested));
                if (this.timeMap.logs.getLower(cacheEnd) != null) {
                    fullLogs.add(this.timeMap.logs.getLower(cacheEnd));
                }
            }
            if (full != null) {
                fullLogs.addAll(this.timeMap.logs.get(full));
                if (this.timeMap.logs.getLower(full.getStart()) != null) {
                    fullLogs.add(this.timeMap.logs.getLower(full.getStart()));
                }
            }
            SGUtils.log("Number of logfiles: %d", fullLogs.size());
            for (Tag tag : fullLogs) {
                ArchiveLog log;
                if (tag.getValue() instanceof CurrentLog) continue;
                try {
                    log = (ArchiveLog)tag.getValue();
                }
                catch (ClassCastException e) {
                    SGUtils.err("Pruned data required in export: %s", tag.getValue());
                    continue;
                }
                try {
                    out.putNextEntry(new ZipEntry(dir + log.filename));
                }
                catch (ZipException e) {
                    if (e.getMessage().startsWith("duplicate entry:")) continue;
                    e.printStackTrace();
                }
                try {
                    ByteStreams.copy(this.source.archives.open(log.filename), out);
                }
                catch (IOException ioe) {
                    System.out.println("closed!!!: " + tag.getValue());
                }
            }
            SGUtils.log("Export completed. File: %s", target);
            out.flush();
            out.closeEntry();
            out.close();
        }
        catch (Exception e) {
            SGUtils.err("Export failed.", new Object[0]);
            String msg = "<html>Export failed: <br><br><em>" + e.getMessage() + "</em></html>";
            JOptionPaneTB.showMessageDialog(parent, msg, "Export failed", 0, SGUtils.PROGRAM_ICONS);
            e.printStackTrace();
        }
        finally {
            this.queueProducer.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCsv(Set<String> pars, Interval range, boolean borderIncluded, Duration dt, File selectedFile) {
        int n = (int)(range.toDurationMillis() / dt.getMillis()) + (borderIncluded ? 0 : 1);
        if (pars.contains("")) {
            pars = this.getPerLoggedPars(null);
        }
        TreeMap<String, ArrayList<Sample>> data = this.fromCacheOrSource(pars, range, dt, n);
        int sep = 59;
        int nl = 10;
        Header header = this.getHeaderAt(range.getEnd());
        FileWriter out = null;
        try {
            out = new FileWriter(selectedFile);
            out.write("DateTime;");
            HashSet<String> mutablePars = new HashSet<String>();
            mutablePars.addAll(pars);
            Iterator iterator = mutablePars.iterator();
            while (iterator.hasNext()) {
                String par = (String)iterator.next();
                Descriptor descriptor = header.descriptors.get(par);
                if (descriptor == null) {
                    SGUtils.err("No descriptor present for %s!", par);
                    iterator.remove();
                    continue;
                }
                out.write(descriptor.name);
                if (!descriptor.unit.isEmpty()) {
                    out.write(" [" + descriptor.unit + "]");
                }
                out.write(59);
            }
            out.write(10);
            DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
            ProgressTask.update("Writing .csv\u2026");
            for (int i = 0; i < n; ++i) {
                ProgressTask.update(100 * i / n);
                if (i >= data.get(mutablePars.iterator().next()).size()) {
                    break;
                }
                out.write(formatter.print(range.getStartMillis() + (long)i * dt.getMillis()) + ';');
                for (String par : mutablePars) {
                    Sample sample = data.get(par).get(i);
                    out.write(header.descriptors.get(par).getRepr(sample));
                    out.write(59);
                }
                out.write(10);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<String, ArrayList<Sample>> fromCacheOrSource(Set<String> pars, Interval range, Duration dt, int n) {
        TreeRangeMap<DateTime, TimeTile> sourceMap = TreeRangeMap.create();
        SGUtils.log("FromCacheOrSource n = " + n, new Object[0]);
        double dtMillis = dt.getMillis();
        for (TimeTile tt : this.timeLine.timeTiles().in(range).sortedBy(new TimeTile.ResolutionPriority(dtMillis / 1000.0))) {
            if ((double)tt.getDt() > dtMillis) continue;
            sourceMap.put(this.timeLine.toDateTime(tt.span), tt);
        }
        for (Map.Entry region : sourceMap.asMapOfRanges().entrySet()) {
            TimeTile tt = (TimeTile)region.getValue();
            for (String par : pars) {
                CacheKey key = new CacheKey(tt, par);
                this.queueProducer.requestKey(key);
            }
        }
        TreeMap<String, ArrayList<Sample>> data = new TreeMap<String, ArrayList<Sample>>();
        this.garbageCollector.protectInterval(this.timeLine.toHwClock(range));
        try {
            this.queueProducer.processRequests();
            for (String par : pars) {
                data.put(par, this.fromCache(par, range, n));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.queueProducer.reset();
            this.queueProducer.reorder();
            this.garbageCollector.protectInterval(null);
        }
        return data;
    }

    public ImmutableSet<String> getPerLoggedPars(HwClock at) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Log log = at == null ? this.timeMap.logs.getLast().getValue() : this.timeMap.logs.getLower(at).getValue();
        for (Map.Entry<String, Descriptor> entry : log.getHeader((Source)this.getSource(), (Pool)this.getPool()).descriptors.entrySet()) {
            if (entry.getValue().eventLogged) continue;
            builder.add(entry.getKey());
        }
        return builder.build();
    }

    private void injectMetaPars(AppState appState) {
        appState.putMetaPar(new MetaPar(EnumDescriptor.mock("TIMETILES", "Time tiles", 1)){

            @Override
            public Sample getSample(long millis) {
                Optional<FileTimeTile> tt = DataStore.this.timeLine.fileTimeTiles().at(millis).first();
                if (!tt.isPresent()) {
                    return Sample.ABSENT;
                }
                return new DiscreteSample(((HwClock)tt.get().span.lowerEndpoint()).ts, false, 1);
            }
        });
        appState.putMetaPar(new MetaPar(EnumDescriptor.mock("DS1", "Downsampling layer 1", 2)){

            @Override
            public Sample getSample(long millis) {
                Optional<CacheTimeTile> tt = DataStore.this.timeLine.cacheTimeTiles().at(millis).withDt(60).first();
                if (!tt.isPresent()) {
                    return Sample.ABSENT;
                }
                return new DiscreteSample(((HwClock)tt.get().span.lowerEndpoint()).ts, false, 1);
            }
        });
        appState.putMetaPar(new MetaPar(EnumDescriptor.mock("COVFEFE", "Coverage state", 3)){

            @Override
            public Sample getSample(long millis) {
                TimeLine.CoverageState coverageState = DataStore.this.timeLine.getCoverage().get(new DateTime(millis));
                return new DiscreteSample(coverageState == null ? -1 : coverageState.ordinal(), false, 1);
            }
        });
        int max = this.timeLine.getFileCoverage().asDescendingSetOfRanges().iterator().next().lowerEndpoint().ts;
        appState.putMetaPar(new MetaPar(FixedDescriptor.mock("MAPPING", "Time mapping", 5, 0.0f, max)){

            @Override
            public Sample getSample(long millis) {
                int ts = DataStore.this.timeLine.toHwClock((long)millis).ts;
                return new ContinuousSample(ts, ts, ts, 1);
            }
        });
        appState.putMetaPar(new MetaPar(EnumDescriptor.mock("DS2", "Downsampling layer 2", 3)){

            @Override
            public Sample getSample(long millis) {
                Optional<CacheTimeTile> tt = DataStore.this.timeLine.cacheTimeTiles().at(millis).withDt(600).first();
                if (!tt.isPresent()) {
                    return Sample.ABSENT;
                }
                return new DiscreteSample(((HwClock)tt.get().span.lowerEndpoint()).ts, false, 1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.terminateExecutors();
        ProgressTask.update("Writing cache\u2026");
        FileOutputStream outputStream = null;
        try {
            File digest = new File(this.source.localCache.getAbsolutePath(), CACHE_ON_DISK_FILENAME);
            outputStream = new FileOutputStream(digest);
            this.writeDigest(null, null, outputStream);
        }
        catch (FileNotFoundException ignore) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.source.api != null) {
            File timeRefs;
            try {
                timeRefs = new File(this.source.localCache.getAbsolutePath(), "time_refs.bin");
                outputStream = new FileOutputStream(timeRefs);
                ByteStreams.copy(this.source.current.open("time_refs.bin"), outputStream);
            }
            catch (IOException ignore) {
            }
            finally {
                BUtil.closeIgnoringExceptions(outputStream);
            }
            try {
                timeRefs = new File(this.source.localCache.getAbsolutePath(), "Current.xml");
                outputStream = new FileOutputStream(timeRefs);
                ByteStreams.copy(this.source.current.open("Current.xml"), outputStream);
            }
            catch (IOException ignore) {
            }
            finally {
                BUtil.closeIgnoringExceptions(outputStream);
            }
            try {
                timeRefs = new File(this.source.localCache.getAbsolutePath(), "Current.bin");
                outputStream = new FileOutputStream(timeRefs);
                try {
                    ByteStreams.copy(this.source.current.open("Current.bin"), outputStream);
                }
                finally {
                    this.source.current.release();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                BUtil.closeIgnoringExceptions(outputStream);
            }
        }
        this.source.destroy();
        SGUtils.log("Shutdown complete.\n", new Object[0]);
    }

    private int countAbsentChildren(CacheKey key) {
        int n = 0;
        for (CacheTimeTile child : key.tt.children) {
            if (this.containerCache.asMap().containsKey(new CacheKey(child, key.parId))) continue;
            ++n;
        }
        return n;
    }

    public void prepareData(long millis, Collection<String> pars) {
        Optional<FileTimeTile> tt_ = this.timeLine.fileTimeTiles().at(millis).first();
        if (!tt_.isPresent()) {
            return;
        }
        FileTimeTile tt = tt_.get();
        this.garbageCollector.registerUncachedFullUsage(tt);
        for (String par : pars) {
            CacheKey key = new CacheKey(tt, par);
            if (this.containerCache.asMap().containsKey(key)) continue;
            this.queueProducer.registerMissedKey(key);
        }
    }

    public void forceCacheLayer(int layer) {
        Iterator timeTiles = this.timeLine.timeTiles().at(0L).sorted().iterator();
        int dt = 0;
        if (layer == 0) {
            this.forcedDt = 0;
            SGUtils.err("Automatic cache layer.", layer, dt);
        }
        try {
            for (int i = 0; i < layer; ++i) {
                dt = ((TimeTile)timeTiles.next()).getDt();
            }
            this.forcedDt = dt;
            SGUtils.err("Enforcing cache layer %d with dt = %d", layer, dt);
        }
        catch (NoSuchElementException ignore) {
            SGUtils.err("No cache layer %d available. Ignoring.", layer);
        }
    }

    public Sample fromCache(String par, long millis) {
        HwClock ts = this.timeLine.toHwClock(millis);
        ImmutableSortedSet<TimeTile> timeTiles = this.timeLine.timeTiles().at(millis).sortedBy(new TimeTile.ResolutionPriority(0.0)).descendingSet();
        if (this.forcedDt > 0) {
            timeTiles = this.timeLine.timeTiles().withDt(this.forcedDt).at(millis).sorted();
        }
        for (TimeTile tt : timeTiles) {
            Header header = this.getHeaderAt(new DateTime(millis));
            if (header == null) {
                return Sample.ABSENT;
            }
            Descriptor d = header.descriptors.get(par);
            if (d == null) {
                return Sample.ABSENT;
            }
            if (d.eventLogged) {
                Tag<EventData> logEvent = this.timeMap.eventData.getLower(ts);
                if (logEvent == null) {
                    return Sample.ABSENT;
                }
                Sample s = (Sample)logEvent.getValue().get(par);
                if (s == null) {
                    return Sample.ABSENT;
                }
                return s;
            }
            CacheKey key = new CacheKey(tt, par);
            Container c2 = (Container)this.containerCache.getIfPresent(key);
            this.garbageCollector.registerUncachedPartialUsage(tt);
            if (c2 == null) continue;
            if (tt.isDtMissing()) {
                SGUtils.log("Access with unknown dt: %s @ %s", par, tt);
                continue;
            }
            int idx = tt.indexOf(ts);
            if (idx < 0) {
                return Sample.ABSENT;
            }
            return c2.getSample(idx, 1);
        }
        return Sample.UNCACHED;
    }

    public ArrayList<Sample> fromCache(String par, Interval interval, int count) {
        ArrayList<Sample> samples = new ArrayList<Sample>(count);
        double msPerPixel = (double)interval.toDurationMillis() / (double)count;
        ImmutableSortedSet<TimeTile> timeTiles = this.timeLine.timeTiles().in(interval).sortedBy(new TimeTile.ResolutionPriority(msPerPixel / 1000.0));
        if (this.forcedDt > 0) {
            timeTiles = this.timeLine.timeTiles().withDt(this.forcedDt).in(interval).sorted();
        }
        if (timeTiles.isEmpty()) {
            return new ArrayList<Sample>();
        }
        int dtBase = Integer.MAX_VALUE;
        TreeRangeMap<DateTime, TimeTile> sourceMap = TreeRangeMap.create();
        HashMap<TimeTile, Container> parCache = new HashMap<TimeTile, Container>();
        int targetDt = timeTiles.last().getDt();
        for (TimeTile timeTile : timeTiles) {
            CacheKey key = new CacheKey(timeTile, par);
            Container container = (Container)this.containerCache.asMap().get(key);
            if (timeTile.getDt() < dtBase) {
                dtBase = timeTile.getDt();
            }
            if (container instanceof NullContainer) continue;
            if (container == null) {
                if (timeTile.getDt() != targetDt && timeTile.covered()) continue;
                this.queueProducer.registerMissedKey(key);
                continue;
            }
            Range<DateTime> ttSpan = this.timeLine.toDateTime(timeTile.span);
            parCache.put(timeTile, container);
            sourceMap.put(ttSpan, timeTile);
        }
        for (Range<DateTime> range : this.timeLine.getUncoveredSet().asRanges()) {
            if (!range.hasUpperBound() || !range.hasLowerBound()) {
                sourceMap.remove(range);
                continue;
            }
            long pxl = (range.upperEndpoint().getMillis() - range.lowerEndpoint().getMillis()) / (long)msPerPixel;
            if (pxl <= 1L) continue;
            sourceMap.remove(range);
        }
        for (Map.Entry entry : sourceMap.asMapOfRanges().entrySet()) {
            Interval range = TimeLine.m((Range)entry.getKey());
            TimeTile tt = (TimeTile)entry.getValue();
            Interval sourceRange = range.overlap(interval);
            if (sourceRange == null || tt.isDtMissing()) continue;
            TreeMap errorData = new TreeMap();
            if (msPerPixel < 500.0) {
                if (this.errorDataCache.getIfPresent(tt) == null) {
                    this.queueProducer.registerMissedKey(new CacheKey(tt, "errordata"));
                } else {
                    for (Map.Entry<HwClock, EventData> e : this.errorDataCache.getIfPresent(tt).entrySet()) {
                        if (!e.getValue().containsKey(par)) continue;
                        errorData.put(e.getKey(), e.getValue().get(par));
                    }
                }
            }
            this.garbageCollector.registerUncachedPartialUsage(tt);
            Container container = (Container)parCache.get(tt);
            double sampleBnd = interval.getStartMillis() + (long)((double)samples.size() * msPerPixel);
            int n = 0;
            while (sampleBnd < (double)sourceRange.getStartMillis()) {
                ++n;
                samples.add(Sample.ABSENT);
                sampleBnd = interval.getStartMillis() + (long)((double)samples.size() * msPerPixel);
            }
            HwClock hwClock = this.timeLine.toHwClock((long)sampleBnd);
            if (tt.span.hasUpperBound() && hwClock.ts > tt.span.upperEndpoint().ts) continue;
            hwClock = new HwClock(hwClock.ts);
            int leftIdx = tt.indexOf(hwClock);
            int dt = dtBase * 1000;
            while (sampleBnd <= (double)sourceRange.getEndMillis() + msPerPixel && tt.span.contains(hwClock = this.timeLine.toHwClock((long)sampleBnd + (long)dt))) {
                int rightIdx = tt.indexOf(hwClock);
                int len = rightIdx - leftIdx;
                Sample sample = container.getSample(leftIdx, len);
                HwClock errTs = new HwClock(hwClock.ts - tt.getDt());
                if (errorData.containsKey(errTs)) {
                    Sample errSample = (Sample)errorData.get(errTs);
                    errorData.remove(errTs);
                    errSample.addFlag();
                    samples.add(errSample);
                    sampleBnd += msPerPixel;
                }
                samples.add(sample);
                leftIdx = rightIdx;
                sampleBnd += msPerPixel;
            }
        }
        return samples;
    }

    public Header getHeaderAt(DateTime cursor) {
        Tag<Log> logTag = this.timeMap.logs.getLower(this.timeLine.toHwClock(cursor));
        if (logTag == null) {
            logTag = this.timeMap.logs.getFirst();
        }
        return logTag.getValue().getHeader(this.source, this.pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDigest(Collection<String> pars, Range<HwClock> range, OutputStream outputStream) {
        HashMap<CacheKey, Container> toDisk = new HashMap<CacheKey, Container>();
        if (range == null) {
            range = Range.all();
        }
        ZipOutputStream stream = null;
        stream = new ZipOutputStream(outputStream);
        try {
            this.addToZip(stream, "Pool.ser", this.pool);
            for (Map.Entry entry : this.containerCache.asMap().entrySet()) {
                CacheKey key = (CacheKey)entry.getKey();
                Container container = (Container)entry.getValue();
                if (key.tt instanceof FileTimeTile || !range.encloses(key.tt.span) || pars != null && !pars.contains(key.parId)) continue;
                key.tt.cleanUp();
                toDisk.put(key, container);
            }
            this.addToZip(stream, "Containers.ser", toDisk);
            try {
                this.timeMap.lock();
                this.addToZip(stream, "TimeMap.ser", this.timeMap);
                this.timeMap.unlock();
                return;
            }
            catch (InterruptedException ignore) {
                return;
            }
            finally {
                this.timeMap.unlock();
            }
        }
        catch (IOException e) {
            SGUtils.err("Could not write cache digest: " + e.getMessage(), new Object[0]);
            return;
        }
        finally {
            try {
                stream.finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addToZip(ZipOutputStream stream, String filename, Object o) throws IOException {
        SGUtils.log(" - %s", filename);
        stream.putNextEntry(new ZipEntry(filename));
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(stream));
        oos.writeObject(o);
        oos.flush();
        stream.closeEntry();
    }

    private Object loadFromZip(ZipFile file, String filename) throws IOException, ClassNotFoundException {
        ZipEntry entry = file.getEntry(filename);
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(file.getInputStream(entry)));
        TimeTile.READING_OBJECT = true;
        Object o = ois.readObject();
        TimeTile.READING_OBJECT = false;
        ois.close();
        return o;
    }

    public void terminateExecutors() {
        this.cronjobs.shutdown();
        this.queueProducer.dsWorker.shutdown();
        this.queueConsumer.workers.shutdown();
        SGUtils.log("Shutting down. Stopping cronjobs\u2026", new Object[0]);
        try {
            this.cronjobs.awaitTermination(10L, TimeUnit.SECONDS);
            this.queueConsumer.workers.awaitTermination(2L, TimeUnit.SECONDS);
            this.queueProducer.dsWorker.awaitTermination(2L, TimeUnit.SECONDS);
            if (!this.cronjobs.isTerminated()) {
                this.cronjobs.shutdownNow();
                SGUtils.log("(terminated remaining cron jobs after timeout)", new Object[0]);
                this.cronjobs.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (!this.queueProducer.dsWorker.isTerminated()) {
                this.queueProducer.dsWorker.shutdownNow();
                SGUtils.log("(terminated remaining downsampling jobs after timeout)", new Object[0]);
                this.queueProducer.dsWorker.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (!this.queueConsumer.workers.isTerminated()) {
                this.queueConsumer.workers.shutdownNow();
                SGUtils.log("(terminated remaining queue jobs after timeout)", new Object[0]);
                this.queueConsumer.workers.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public File getSysMsg() throws IOException {
        File tmp = File.createTempFile("SystemMessages", ".txt");
        FileOutputStream out = new FileOutputStream(tmp);
        if (this.source.sysMsg.ls().contains(SYS_MSG_1)) {
            String archived = "jac.log.1.gz";
            if (this.source.sysMsg.ls().contains(archived)) {
                GZIPInputStream log = new GZIPInputStream(this.source.sysMsg.open(archived));
                SGUtils.eolNormalizingStreamCopy(log, out);
            }
            SGUtils.eolNormalizingStreamCopy(this.source.sysMsg.open(SYS_MSG_1), out);
        } else {
            SGUtils.eolNormalizingStreamCopy(this.source.sysMsg.open(SYS_MSG_2), out);
        }
        out.close();
        return tmp;
    }

    public Jac getJac() {
        return this.source.origin;
    }

    public Source getSource() {
        return this.source;
    }

    public void unregisterEvents(EventBus updates) {
        updates.unregister(this.queueProducer);
        updates.unregister(this.queueConsumer);
        updates.unregister(this);
    }

    public boolean invalidateDigest() {
        File digest = new File(this.source.localCache.getAbsolutePath(), CACHE_ON_DISK_FILENAME);
        if (digest.exists()) {
            return digest.delete();
        }
        return true;
    }

    public static boolean invalidateDigest(Source source) {
        File digest = new File(source.localCache.getAbsolutePath(), CACHE_ON_DISK_FILENAME);
        if (digest.exists()) {
            return digest.delete();
        }
        return true;
    }

    public Pool getPool() {
        return this.pool;
    }

    public boolean timeTileLoadOk() {
        return this.timeTileLoadOk;
    }
}

