/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.Demuxer;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.HeaderParser;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.io.Source;
import java.io.IOException;
import java.io.InputStream;

public class CurrentLog
extends Log {
    private static final long serialVersionUID = 1L;
    private transient Demuxer demuxer;
    private transient long dataSize = 0L;

    @Override
    public Header getHeader(Source source, Pool pool) {
        if (this.header == null) {
            try {
                this.header = HeaderParser.parse(pool, source.current.open("Current.xml"));
            }
            catch (IOException e) {
                SGUtils.err("Could not parse header in %s (ie. the current log)", "Current.xml");
            }
        }
        return this.header;
    }

    @Override
    Demuxer getDemuxer(Source source, Pool pool) throws IOException {
        if (this.demuxer == null) {
            this.demuxer = new Demuxer(this.getHeader(source, pool), source.current.open("Current.bin"));
        } else {
            source.current.release();
            this.demuxer.reattach(source.current.open("Current.bin"));
        }
        return this.demuxer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(Source source, Pool pool) {
        try {
            source.current.release();
            InputStream in = source.current.open("Current.bin");
            this.demuxer = new Demuxer(this.getHeader(source, pool), in);
            this.dataSize = 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            source.current.release();
        }
    }

    int dataSizeDiff(Source source) throws IOException {
        long dataSize_ = this.dataSize;
        this.dataSize = source.current.getSize("Current.bin");
        return (int)(this.dataSize - dataSize_);
    }

    @Override
    void release(Source source) {
        source.release();
    }
}

