/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.ConcatOrder;
import ch.bruker.jac.servicegui.data.CurrentLog;
import ch.bruker.jac.servicegui.data.Demuxer;
import ch.bruker.jac.servicegui.data.EventData;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.data.TimeMap;
import ch.bruker.jac.servicegui.data.TimeTile;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.cache.NullContainer;
import ch.bruker.jac.servicegui.data.io.Source;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;

class ContainerFactory {
    private final LoadingCache<CacheKey, Container> containerCache;
    private final Source source;
    private final Pool pool;
    private final Cache<FileTimeTile, SortedMap<HwClock, EventData>> errorDataCache;
    private TimeMap timeMap;
    private AppState appState;

    public ContainerFactory(LoadingCache<CacheKey, Container> containerCache, Cache<FileTimeTile, SortedMap<HwClock, EventData>> errorDataCache, Source source, TimeMap timeMap, AppState appState, Pool pool) {
        this.containerCache = containerCache;
        this.errorDataCache = errorDataCache;
        this.source = source;
        this.timeMap = timeMap;
        this.appState = appState;
        this.pool = pool;
    }

    private Container downsample(CacheTimeTile cacheTimeTile, String par, Descriptor descriptor, Map<CacheKey, Container> parents) {
        if (descriptor == null) {
            return new NullContainer(cacheTimeTile.length());
        }
        Container targetContainer = descriptor.createContainer(cacheTimeTile.length(), false);
        TreeSet<CacheKey> depKeys = new TreeSet<CacheKey>(new ConcatOrder());
        for (TimeTile tt : cacheTimeTile.parents) {
            depKeys.add(new CacheKey(tt, par));
        }
        HwClock cursor = (HwClock)cacheTimeTile.span.lowerEndpoint();
        for (CacheKey key : depKeys) {
            Container container = parents.get(key);
            if (container == null) {
                throw new IllegalStateException("Dependency for " + cacheTimeTile + " missing in cache: " + key);
            }
            container.remainingChildren.decrementAndGet();
            int factor = cacheTimeTile.getDt() / key.tt.getDt();
            int offset = (key.tt.span.lowerEndpoint().ts - cursor.ts) / key.tt.getDt();
            int old_len = targetContainer.getLength();
            int expected_new_length = old_len + (container.getLength() + offset) / factor;
            targetContainer.appendDownsampled(container, offset, factor);
            int new_len = targetContainer.getLength();
            cursor = key.tt.span.upperEndpoint();
        }
        return targetContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Container> load(FileTimeTile tt, Collection<String> pars) {
        HashMap<String, Container> containers = new HashMap<String, Container>();
        Tag<Log> logTag = this.timeMap.logs.getUpper((HwClock)tt.span.lowerEndpoint());
        if (logTag == null) {
            SGUtils.err("Load request for time tile without Log-header", new Object[0]);
            return null;
        }
        Log log = logTag.getValue();
        Demuxer demuxer = null;
        try {
            HwClock edge;
            demuxer = log.getDemuxer(this.source, this.pool);
            if (log instanceof CurrentLog) {
                pars.addAll(this.appState.getPerLoggedPars((HwClock)tt.span.lowerEndpoint()));
            }
            for (String p : pars) {
                demuxer.extract(p);
            }
            demuxer.run();
            log.release(this.source);
            if (!tt.span.hasUpperBound() && (edge = demuxer.getEdge()) != null) {
                this.appState.bumpTimeLineEnd(edge);
            }
        }
        catch (Exception e) {
            log.reset(this.source, this.pool);
            SGUtils.err("Could not parse %s: ", tt);
            e.printStackTrace();
            Map<String, Container> map = null;
            return map;
        }
        finally {
            log.release(this.source);
        }
        containers.putAll(demuxer.getContainers());
        this.timeMap.errorMessages.putAll(demuxer.getErrors());
        this.timeMap.systemInfo.putAll(demuxer.getSystemInfo());
        this.timeMap.eventData.putAll(demuxer.getEventData());
        this.errorDataCache.put(tt, demuxer.getErrorData());
        int dt = demuxer.getSamplePeriod();
        if (tt.isDtMissing() && dt > 0 || !tt.span.hasUpperBound()) {
            tt.setDt(dt);
        }
        return containers;
    }

    public Map<String, Container> load(CacheTimeTile cacheTimeTile, Collection<String> pars) {
        HashMap<String, Container> ret = new HashMap<String, Container>();
        for (String par : pars) {
            HashMap<CacheKey, Container> parents = new HashMap<CacheKey, Container>();
            for (TimeTile tt : cacheTimeTile.parents) {
                CacheKey key = new CacheKey(tt, par);
                parents.put(key, (Container)this.containerCache.getIfPresent(key));
            }
            ret.put(par, this.downsample(cacheTimeTile, par, cacheTimeTile.mergedDescriptor(this, par), parents));
        }
        return ret;
    }

    Header getHeaderFor(FileTimeTile fileTimeTile) {
        return this.timeMap.logs.get((HwClock)fileTimeTile.span.lowerEndpoint()).getValue().getHeader(this.source, this.pool);
    }
}

