/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.TitledBorder;

public class CheckBoxTitledBorder
extends AbstractBorder {
    private final TitledBorder parent = BorderFactory.createTitledBorder("");
    private final JCheckBox box;

    public CheckBoxTitledBorder(String title) {
        this.box = new JCheckBox(title);
        this.box.setOpaque(true);
        this.box.setFont(this.box.getFont().deriveFont(1));
    }

    public JCheckBox getBox() {
        return this.box;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        Insets borderInsets = this.parent.getBorderInsets(c2);
        Insets insets = this.getBorderInsets(c2);
        int temp = (insets.top - borderInsets.top) / 2 + 2;
        this.parent.paintBorder(c2, g, x, y + temp, width, height - temp);
        Dimension size = this.box.getPreferredSize();
        final Rectangle rectangle = new Rectangle(5, 0, size.width, size.height);
        final Container container = (Container)c2;
        container.addMouseListener(new MouseAdapter(){

            private void dispatchEvent(MouseEvent me) {
                if (rectangle.contains(me.getX(), me.getY())) {
                    Point pt = me.getPoint();
                    pt.translate(-5, 0);
                    CheckBoxTitledBorder.this.box.setBounds(rectangle);
                    CheckBoxTitledBorder.this.box.dispatchEvent(new MouseEvent(CheckBoxTitledBorder.this.box, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
                    if (!CheckBoxTitledBorder.this.box.isValid()) {
                        container.repaint();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                this.dispatchEvent(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.dispatchEvent(me);
            }
        });
        SwingUtilities.paintComponent(g, this.box, container, rectangle);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        Insets insets = this.parent.getBorderInsets(c2);
        insets.top = Math.max(insets.top, this.box.getPreferredSize().height);
        return insets;
    }
}

