/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CacheTaskProducer;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.DataStore;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.TimeLine;
import ch.bruker.jac.servicegui.data.cache.NullContainer;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class CacheVisualizer
implements Runnable {
    private final AppState appState;
    private final CacheTaskProducer queueProducer;
    private TreeRangeMap<DateTime, DataState> cacheState;
    private final DataStore dataStore;

    CacheVisualizer(DataStore dataStore, AppState appState, CacheTaskProducer queueProducer) {
        this.appState = appState;
        this.queueProducer = queueProducer;
        this.dataStore = dataStore;
        this.cacheState = TreeRangeMap.create();
        this.cacheState.put(Range.all(), DataState.VOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Interval scope = this.appState.getScope();
        if (scope == null) {
            return;
        }
        TreeRangeMap<DateTime, DataState> state_ = TreeRangeMap.create();
        Set keys = this.dataStore.containerCache.asMap().keySet();
        for (Map.Entry<Range<DateTime>, TimeLine.CoverageState> entry : this.dataStore.timeLine.getCoverage().asMapOfRanges().entrySet()) {
            if (!entry.getValue().equals((Object)TimeLine.CoverageState.DOWNSAMPLED)) continue;
            state_.put(entry.getKey(), DataState.PRUNED);
        }
        for (CacheKey key : this.dataStore.containerCache.asMap().keySet()) {
            if (key.tt instanceof CacheTimeTile || this.dataStore.containerCache.asMap().get(key) instanceof NullContainer) continue;
            state_.put(this.dataStore.timeLine.toDateTime(key.tt.span), DataState.FULLRES_REMAINING);
        }
        for (CacheKey key : this.queueProducer.getMisses()) {
            if (key.tt.getDt() >= 10) continue;
            state_.put(this.dataStore.timeLine.toDateTime(key.tt.span), DataState.MISSING);
        }
        for (CacheTaskProducer.Task task : this.queueProducer.pending) {
            state_.put(this.dataStore.timeLine.toDateTime(task.timeTile.span), DataState.LOADING);
        }
        for (FileTimeTile timeTile : this.queueProducer.failedAttempts) {
            state_.put(this.dataStore.timeLine.toDateTime(timeTile.span), DataState.FAILED);
        }
        if (this.cacheState.equals(state_)) {
            return;
        }
        CacheVisualizer cacheVisualizer = this;
        synchronized (cacheVisualizer) {
            this.cacheState = state_;
        }
        this.appState.updates.post(new Trigger("timeLineRepaint"));
    }

    public TreeRangeMap<DateTime, DataState> getCacheState() {
        return this.cacheState;
    }

    public static enum DataState {
        VOID,
        MISSING,
        FULLRES_REMAINING,
        PRUNED,
        FAILED,
        LOADING;

    }
}

