/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.data.ContainerFactory;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.TimeTile;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

class CacheTimeTile
extends TimeTile {
    private static final long serialVersionUID = 1L;
    final SortedSet<TimeTile> parents;

    CacheTimeTile(int dt, Range<HwClock> clkRange, ImmutableSortedSet<? extends TimeTile> parents) {
        super(dt, clkRange);
        this.parents = new TreeSet<TimeTile>((Collection<? extends TimeTile>)parents);
    }

    @Override
    public Map<String, Container> dispatchLoad(ContainerFactory loader, Collection<String> pars) {
        return loader.load(this, pars);
    }

    @Override
    public Descriptor mergedDescriptor(ContainerFactory factory, String par) {
        Descriptor checked = null;
        for (TimeTile tt : this.parents) {
            boolean incompatible;
            Descriptor descriptor = tt.mergedDescriptor(factory, par);
            if (descriptor == null) {
                return null;
            }
            boolean bl = incompatible = checked != null && descriptor.byteSize != checked.byteSize;
            if (incompatible) {
                return null;
            }
            checked = descriptor;
        }
        return checked;
    }

    @Override
    public Range<HwClock> backedSpan() {
        Range<HwClock> total = null;
        for (TimeTile parent : this.parents) {
            if (total == null) {
                total = parent.span;
            }
            total = total.span(parent.span);
        }
        return total;
    }

    @Override
    void setDt(int dt) {
        throw new UnsupportedOperationException();
    }
}

