/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Colors;
import ch.bruker.jac.servicegui.NamedThreadFactory;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CacheTimeTile;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.TimeTile;
import ch.bruker.jac.servicegui.data.cache.Container;
import ch.bruker.util.PlotFrame;
import ch.bruker.util.ProgressTask;
import com.google.common.base.MoreObjects;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.eventbus.Subscribe;
import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStatsAccumulator;
import java.awt.Color;
import java.awt.Frame;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JOptionPane;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;

public class CacheTaskProducer
implements Iterator<Task> {
    private static final int MAX_ATTEMPTS = 5;
    private final AppState appState;
    private final LoadingCache<CacheKey, Container> cache;
    final ThreadPoolExecutor dsWorker;
    final ScheduledReordering scheduledReordering;
    private final Set<CacheKey> misses;
    private final Set<CacheKey> requests;
    private volatile WishList activeWishList = WishList.MISSES;
    private volatile LinkedList<FileTimeTile> queue;
    final Set<Task> pending;
    public final Collection<Task> stats = new ConcurrentLinkedQueue<Task>();
    Multiset<FileTimeTile> failedAttempts = ConcurrentHashMultiset.create();
    private Set<String> pendingRemovals = new HashSet<String>();

    public CacheTaskProducer(LoadingCache<CacheKey, Container> cache, AppState appState) {
        this.cache = cache;
        this.appState = appState;
        this.pending = Collections.newSetFromMap(new ConcurrentHashMap());
        this.queue = new LinkedList();
        this.misses = Collections.newSetFromMap(new ConcurrentHashMap());
        this.requests = Collections.newSetFromMap(new ConcurrentHashMap());
        this.dsWorker = (ThreadPoolExecutor)Executors.newFixedThreadPool(1, new NamedThreadFactory("Downsampling Worker", 5));
        this.scheduledReordering = new ScheduledReordering();
    }

    @Subscribe
    public void handleScopeUpdate(Interval scope) {
        this.appState.doAsync(new Runnable(){

            @Override
            public void run() {
                CacheTaskProducer.this.reorder();
            }
        });
    }

    @Subscribe
    public void handleCursorUpdate(DateTime cursor) {
        this.appState.doAsync(new Runnable(){

            @Override
            public void run() {
                CacheTaskProducer.this.reorder();
            }
        });
    }

    @Subscribe
    public void handleTrigger(Trigger trigger) {
        if (trigger.is("reorderQueue")) {
            this.appState.doAsync(new Runnable(){

                @Override
                public void run() {
                    CacheTaskProducer.this.reorder();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorder() {
        Iterator<CacheKey> iterator = this.misses.iterator();
        while (iterator.hasNext()) {
            CacheKey miss = iterator.next();
            if (!this.pendingRemovals.contains(miss.parId)) continue;
            iterator.remove();
        }
        this.pendingRemovals.clear();
        long cursor = this.appState.getCursor().getMillis();
        Interval scope = this.appState.getScope();
        if (!scope.contains(cursor)) {
            cursor = cursor > scope.getEndMillis() ? scope.getEndMillis() : scope.getStartMillis();
        }
        HwClock timestamp = this.appState.millisToHwClock(cursor);
        TimeTile.DistancePriority distancePriority = new TimeTile.DistancePriority(timestamp);
        TreeSet<TimeTile> missingFileTimeTiles = new TreeSet<TimeTile>(distancePriority);
        Set<CacheKey> pendingKeys = this.activeWishList == WishList.MISSES ? this.misses : this.requests;
        for (CacheKey key : pendingKeys) {
            if (missingFileTimeTiles.contains(key.tt) || this.failedAttempts.count(key.tt) >= 5) continue;
            missingFileTimeTiles.add((FileTimeTile)key.tt);
        }
        if (!missingFileTimeTiles.isEmpty()) {
            CacheTaskProducer cacheTaskProducer = this;
            synchronized (cacheTaskProducer) {
                this.queue = new LinkedList<TimeTile>(missingFileTimeTiles);
            }
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public synchronized Task next() {
        FileTimeTile dueTimeTile = this.queue.pollFirst();
        if (dueTimeTile == null) {
            return null;
        }
        Task task = new Task(dueTimeTile);
        this.pending.add(task);
        return task;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ImmutableSet<CacheKey> getMisses() {
        return ImmutableSet.copyOf(this.misses);
    }

    public void removeMiss(String par) {
        this.pendingRemovals.add(par);
    }

    public void registerMissedKey(CacheKey key) {
        if (key.tt instanceof FileTimeTile && !this.appState.getFileCoverage().contains(key.tt.span.lowerEndpoint())) {
            return;
        }
        Collection<CacheKey> ancestors = this.ancestors(key);
        this.misses.addAll(ancestors);
        this.scheduleReorderIfNecessary();
    }

    private synchronized void scheduleReorderIfNecessary() {
        if (this.activeWishList == WishList.MISSES && this.queue.isEmpty()) {
            this.appState.doAsync(new Runnable(){

                @Override
                public void run() {
                    CacheTaskProducer.this.reorder();
                }
            });
        }
    }

    public void requestKey(CacheKey key) {
        this.requests.addAll(this.ancestors(key));
    }

    private Collection<CacheKey> ancestors(CacheKey key) {
        LinkedList<CacheKey> missingParents = new LinkedList<CacheKey>();
        if (key.tt instanceof FileTimeTile) {
            for (Task pendingTask : this.pending) {
                if (!key.tt.equals(pendingTask.timeTile)) continue;
                return missingParents;
            }
            if (!this.appState.getFileCoverage().contains(key.tt.span.lowerEndpoint())) {
                return missingParents;
            }
            missingParents.add(key);
            return missingParents;
        }
        for (TimeTile parent : ((CacheTimeTile)key.tt).parents) {
            CacheKey k = new CacheKey(parent, key.parId);
            if (this.cache.asMap().containsKey(k)) continue;
            missingParents.addAll(this.ancestors(k));
        }
        return missingParents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.activeWishList = WishList.MISSES;
        this.misses.clear();
        this.requests.clear();
        this.pending.clear();
        CacheTaskProducer cacheTaskProducer = this;
        synchronized (cacheTaskProducer) {
            this.queue.clear();
        }
        this.reorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequests() throws InterruptedException {
        if (this.requests.isEmpty()) {
            return;
        }
        try {
            this.activeWishList = WishList.REQUESTS;
            this.reorder();
            int queueSize = 0;
            CacheTaskProducer cacheTaskProducer = this;
            synchronized (cacheTaskProducer) {
                queueSize = this.queue.size();
            }
            int tasks = Math.max(this.queue.size(), 1);
            DateTime start = DateTime.now();
            ProgressTask.update("Processing logfiles\u2026");
            while (!(Thread.currentThread().isInterrupted() || queueSize <= 0 && this.dsWorker.getActiveCount() <= 0)) {
                long elapsed = DateTime.now().getMillis() - start.getMillis();
                CacheTaskProducer cacheTaskProducer2 = this;
                synchronized (cacheTaskProducer2) {
                    queueSize = this.queue.size();
                }
                if (tasks != queueSize) {
                    long projected = elapsed / (long)(tasks - queueSize) * (long)queueSize;
                    Duration duration = Duration.millis(projected);
                    String durationLabel = SGUtils.PERIOD_FORMATTER.print(new Period(duration));
                    if (durationLabel.isEmpty()) {
                        ProgressTask.update("Almost there...");
                    } else {
                        ProgressTask.update(durationLabel + " remaining.");
                    }
                    CacheTaskProducer cacheTaskProducer3 = this;
                    synchronized (cacheTaskProducer3) {
                        queueSize = this.queue.size();
                    }
                    ProgressTask.update((tasks - queueSize + this.pending.size()) * 100 / tasks);
                }
                Thread.sleep(1000L);
            }
        }
        finally {
            this.activeWishList = WishList.MISSES;
            this.reorder();
        }
    }

    private void createChildren(final TimeTile tt, final Set<String> pars) {
        this.dsWorker.submit(new Runnable(){

            @Override
            public void run() {
                for (CacheTimeTile child : tt.children) {
                    for (String par : pars) {
                        LinkedList<CacheKey> depKeys = new LinkedList<CacheKey>();
                        for (TimeTile dtt : child.parents) {
                            depKeys.add(new CacheKey(dtt, par));
                        }
                        ImmutableMap parents = CacheTaskProducer.this.cache.getAllPresent(depKeys);
                        if (parents.size() < child.parents.size()) continue;
                        boolean incomplete = false;
                        for (TimeTile tt2 : child.parents) {
                            if (tt2.getDt() != 0) continue;
                            SGUtils.err("Could not create downsampled cache for %s / %s.", tt2, par);
                            incomplete = true;
                            break;
                        }
                        if (incomplete) continue;
                        try {
                            CacheKey key = new CacheKey(child, par);
                            CacheTaskProducer.this.cache.get(key);
                            CacheTaskProducer.this.createChildren(child, Collections.singleton(par));
                            CacheTaskProducer.this.misses.remove(key);
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public void printStats(Frame owner) {
        HashMap rushes = new HashMap();
        for (Task task : this.stats) {
            TreeMap<Integer, Integer> hist = (TreeMap<Integer, Integer>)rushes.get(task.pars);
            if (hist == null) {
                hist = new TreeMap<Integer, Integer>();
                rushes.put(task.pars, hist);
            }
            if (!task.timeTile.span.hasUpperBound() || task.timeTile.isDtMissing()) continue;
            hist.put(task.timeTile.length(), (int)task.duration);
        }
        PlotFrame plot = new PlotFrame(owner, "Caching performance", "Time tile length", "Duration / ms");
        boolean draw = false;
        for (Map.Entry e : rushes.entrySet()) {
            Set pars = (Set)e.getKey();
            TreeMap hist = (TreeMap)e.getValue();
            PairedStatsAccumulator s = new PairedStatsAccumulator();
            if (hist.size() < 5) continue;
            draw = true;
            for (Map.Entry entry : hist.entrySet()) {
                plot.add(((Integer)entry.getKey()).intValue(), (double)((Integer)entry.getValue()).intValue());
                s.add(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
            }
            Color c2 = Colors.getHashColor(1.0f, 1.0f, hist);
            plot.markerColor = Colors.fixOpacity(c2, 0.3f);
            plot.strokeWidth = 0;
            plot.markerSize = 4;
            plot.draw();
            plot.strokeColor = c2;
            plot.strokeWidth = 1;
            plot.markerSize = 0;
            LinearTransformation t = s.leastSquaresFit();
            plot.add(0.0, t.transform(0.0));
            int xMax = (int)s.xStats().max();
            double yMax = t.transform(xMax);
            plot.add(xMax, yMax);
            plot.draw();
            String label = String.format("%.1f ns/point + %.1f ms (%d pars)", 1000.0 * t.slope() / (double)pars.size(), t.transform(0.0), pars.size());
            plot.label(xMax, yMax, label, 1.0);
        }
        if (draw) {
            plot.setParent(owner);
            plot.finish(true);
        } else {
            JOptionPane.showMessageDialog(owner, "Not yet enough data collected.");
        }
    }

    class Task {
        final FileTimeTile timeTile;
        final Set<String> pars;
        final long start;
        double duration;

        Task(FileTimeTile timeTile) {
            this.timeTile = timeTile;
            this.pars = new HashSet<String>();
            this.start = System.nanoTime();
        }

        Set<CacheKey> getKeys() {
            Iterator it = Iterators.concat(CacheTaskProducer.this.requests.iterator(), CacheTaskProducer.this.misses.iterator());
            LinkedHashSet<CacheKey> keys = new LinkedHashSet<CacheKey>();
            while (it.hasNext()) {
                CacheKey key = (CacheKey)it.next();
                if (!key.tt.equals(this.timeTile)) continue;
                keys.add(key);
                this.pars.add(key.parId);
                CacheTaskProducer.this.misses.remove(key);
                CacheTaskProducer.this.requests.remove(key);
            }
            if (this.pars.contains("")) {
                this.pars.addAll(CacheTaskProducer.this.appState.getPerLoggedPars((HwClock)this.timeTile.span.lowerEndpoint()));
                this.pars.remove("");
                for (String par : this.pars) {
                    CacheKey key = new CacheKey(this.timeTile, par);
                    keys.add(key);
                    CacheTaskProducer.this.misses.remove(key);
                    CacheTaskProducer.this.requests.remove(key);
                }
            }
            return keys;
        }

        void tick() {
            System.out.print(".");
            CacheTaskProducer.this.pending.remove(this);
            this.duration = 1.0E-6 * (double)(System.nanoTime() - this.start);
            if (!this.pars.isEmpty()) {
                CacheTaskProducer.this.stats.add(this);
            }
            CacheTaskProducer.this.createChildren(this.timeTile, this.pars);
            CacheTaskProducer.this.failedAttempts.setCount(this.timeTile, 0);
        }

        void tock() {
            CacheTaskProducer.this.pending.remove(this);
            if (!this.timeTile.span.hasUpperBound()) {
                return;
            }
            CacheTaskProducer.this.failedAttempts.add(this.timeTile);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("size", this.timeTile.length()).add("pars", this.pars.size()).toString();
        }
    }

    public class ScheduledReordering
    implements Runnable {
        @Override
        public void run() {
            CacheTaskProducer.this.scheduleReorderIfNecessary();
        }
    }

    static enum WishList {
        MISSES,
        REQUESTS;

    }
}

